/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.materializer;

import java.util.Arrays;
import java.util.Map;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.materializer.WorkspaceMaterializer;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.model.WorkspaceBinding;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class WorkspaceBindingInstallJob
extends WorkspaceJob {
    private static WorkspaceBindingInstallJob active = null;
    public static final int REPEAT_DELAY = 60000;

    public static void start() {
        if (active != null) {
            return;
        }
        active = new WorkspaceBindingInstallJob();
        active.addJobChangeListener((IJobChangeListener)new Repeater());
        active.schedule(5000L);
    }

    public static void stop() {
        WorkspaceBindingInstallJob job = active;
        active = null;
        if (job != null) {
            job.cancel();
        }
    }

    private WorkspaceBindingInstallJob() {
        super(Messages.Workspace_binding_installer);
        this.setPriority(40);
        this.setSystem(true);
        this.setUser(false);
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        StorageManager sm = StorageManager.getDefault();
        Object[] wsBindings = (WorkspaceBinding[])sm.getWorkspaceBindings().getElements();
        if (wsBindings.length == 0) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            return Status.OK_STATUS;
        }
        monitor.beginTask(null, wsBindings.length * 100);
        WorkspaceMaterializer wsMaterializer = new WorkspaceMaterializer();
        Arrays.sort(wsBindings);
        Object[] objectArray = wsBindings;
        int n = wsBindings.length;
        int n2 = 0;
        while (n2 < n) {
            Object wsBinding = objectArray[n2];
            wsMaterializer.installLocal((WorkspaceBinding)wsBinding, new RMContext((Map<String, ? extends Object>)((WorkspaceBinding)wsBinding).getProperties()), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
            ((WorkspaceBinding)wsBinding).remove(sm);
            ++n2;
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    private static class Repeater
    extends JobChangeAdapter {
        private Repeater() {
        }

        public void done(IJobChangeEvent event) {
            WorkspaceBindingInstallJob job = active;
            if (job != null) {
                job.schedule(60000L);
            }
        }
    }
}

