/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.metadata.AbstractSaxableStorage;
import org.eclipse.buckminster.core.metadata.TimestampedKey;
import org.eclipse.buckminster.core.metadata.model.ElementNotFoundException;
import org.eclipse.buckminster.core.parser.IParser;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.UUIDKeyed;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStorage<T extends UUIDKeyed>
extends AbstractSaxableStorage<T> {
    private final HashMap<UUID, TimestampedKey> timestamps = new HashMap();
    private static final String SEQUENCE_FILE = ".sqfile";
    private final File folder;
    private final File sqFile;
    private final HashMap<UUID, T> parsed = new HashMap();
    private transient T[] allElements;
    private final IParser<T> parser;
    private long cacheTime;
    private long lastChecked;
    private boolean sequenceChanged;

    public FileStorage(File folder, IParser<T> parser, Class<T> clazz, int sequenceNumber) throws CoreException {
        super(clazz);
        this.folder = folder;
        this.sqFile = new File(folder, SEQUENCE_FILE);
        this.parser = parser;
        FileUtils.createDirectory(folder, null);
        Lock lock = Lock.lock(this.sqFile, true);
        try {
            try {
                ByteBuffer bf = ByteBuffer.allocateDirect(4);
                bf.order(ByteOrder.LITTLE_ENDIAN);
                FileChannel fc = lock.getLockChannel();
                int foundSequenceNumber = fc.read(bf) == 4 ? bf.getInt(0) : -1;
                boolean bl = this.sequenceChanged = foundSequenceNumber >= 0 && foundSequenceNumber != sequenceNumber;
                if (foundSequenceNumber < 0 || this.sequenceChanged) {
                    bf.clear();
                    bf.putInt(sequenceNumber);
                    bf.flip();
                    fc.position(0L);
                    fc.write(bf);
                }
                File[] files = folder.listFiles();
                int idx = files.length;
                while (--idx >= 0) {
                    File file = files[idx];
                    String name = file.getName();
                    if (name.charAt(0) == '.') continue;
                    UUID id = UUID.fromString(name);
                    this.timestamps.put(id, new TimestampedKey(id, file.lastModified()));
                }
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        finally {
            lock.release();
        }
        this.cacheTime = this.sqFile.lastModified();
        this.lastChecked = System.currentTimeMillis();
    }

    @Override
    public synchronized void clear() {
        try {
            Lock lock = Lock.lock(this.sqFile, true);
            try {
                File[] fileArray = this.folder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!file.equals(this.sqFile)) {
                        file.delete();
                    }
                    ++n2;
                }
            }
            finally {
                lock.release();
            }
        }
        catch (CoreException e) {
            CorePlugin.getLogger().error((Throwable)e, e.toString(), new Object[0]);
        }
        this.parsed.clear();
        this.timestamps.clear();
    }

    @Override
    public synchronized boolean contains(T element) throws CoreException {
        this.checkCache();
        return this.timestamps.containsKey(element.getId());
    }

    @Override
    public synchronized long getCreationTime(UUID elementId) throws ElementNotFoundException {
        this.checkCache();
        TimestampedKey tsKey = this.timestamps.get(elementId);
        if (tsKey == null) {
            throw new ElementNotFoundException(this, elementId);
        }
        return tsKey.getCreationTime();
    }

    @Override
    public synchronized T getElement(UUID elementId) throws CoreException {
        UUIDKeyed uUIDKeyed;
        this.checkCache();
        if (!this.timestamps.containsKey(elementId)) {
            throw new ElementNotFoundException(this, elementId);
        }
        UUIDKeyed element = (UUIDKeyed)this.parsed.get(elementId);
        if (element != null) {
            return (T)element;
        }
        Lock lock = Lock.lock(this.sqFile, false);
        FileInputStream input = null;
        try {
            File elementFile = this.getElementFile(elementId);
            input = new FileInputStream(elementFile);
            element = (UUIDKeyed)this.parser.parse(elementFile.toString(), input);
            element.setId(elementId);
            this.parsed.put(elementId, element);
            uUIDKeyed = element;
        }
        catch (FileNotFoundException e) {
            try {
                throw new ElementNotFoundException(this, elementId);
            }
            catch (Throwable throwable) {
                IOUtils.close(input);
                lock.release();
                throw throwable;
            }
        }
        IOUtils.close((Closeable)input);
        lock.release();
        return (T)uUIDKeyed;
    }

    @Override
    public synchronized T[] getElements() throws CoreException {
        this.checkCache();
        if (this.allElements == null) {
            Set<UUID> keys = this.timestamps.keySet();
            HashSet<UUID> badKeys = null;
            int idx = keys.size();
            UUIDKeyed[] elems = this.createArray(idx);
            for (UUID key : keys) {
                try {
                    elems[--idx] = this.getElement(key);
                }
                catch (CoreException e) {
                    CorePlugin.getLogger().warning(BuckminsterException.unwind((Throwable)e), NLS.bind((String)Messages.Unable_to_read_0, (Object)this.getElementClass().getName()), new Object[0]);
                    if (badKeys == null) {
                        badKeys = new HashSet<UUID>();
                    }
                    badKeys.add(key);
                }
            }
            if (badKeys != null) {
                idx = elems.length;
                int goodIdx = idx - badKeys.size();
                UUIDKeyed[] goodElems = this.createArray(goodIdx);
                while (--idx >= 0) {
                    UUIDKeyed elem = elems[idx];
                    if (elem == null) continue;
                    goodElems[--goodIdx] = elem;
                }
                elems = goodElems;
                for (UUID badKey : badKeys) {
                    this.timestamps.remove(badKey);
                }
            }
            this.allElements = elems;
        }
        return this.allElements;
    }

    @Override
    public synchronized UUID[] getKeys() {
        this.checkCache();
        Set<UUID> keys = this.timestamps.keySet();
        return keys.toArray(new UUID[keys.size()]);
    }

    @Override
    public String getName() {
        return this.folder.getName();
    }

    @Override
    public synchronized List<UUID> getReferencingKeys(UUID foreignKey, String keyName) throws CoreException {
        List<UUID> result = null;
        Method getter = this.getGetter(keyName);
        try {
            for (UUID elementId : this.timestamps.keySet()) {
                T element = this.getElement(elementId);
                UUID fkey = (UUID)getter.invoke(element, Trivial.EMPTY_OBJECT_ARRAY);
                if (fkey == null || !fkey.equals(foreignKey)) continue;
                if (result == null) {
                    result = new ArrayList<UUID>();
                }
                result.add(elementId);
            }
            if (result == null) {
                result = Collections.emptyList();
            }
            return result;
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    @Override
    public synchronized TimestampedKey[] getTimestampedKeys() {
        this.checkCache();
        Collection<TimestampedKey> values = this.timestamps.values();
        return values.toArray(new TimestampedKey[values.size()]);
    }

    @Override
    public synchronized void putElement(T element) throws CoreException {
        long timestamp;
        UUID id = element.getId();
        if (!this.timestamps.containsKey(id)) {
            this.parsed.put(id, element);
            this.persistImage(id, element.getImage());
            timestamp = System.currentTimeMillis();
        } else {
            timestamp = System.currentTimeMillis();
            this.getElementFile(id).setLastModified(timestamp);
        }
        this.timestamps.put(id, new TimestampedKey(id, timestamp));
    }

    @Override
    public synchronized void putElement(UUID id, T element) throws CoreException {
        UUID realId = element.getId();
        this.putElement(element);
        if (id.equals(realId)) {
            return;
        }
        CorePlugin.getLogger().debug("Element id discrepancy in storage %s, expected %s, was %s", new Object[]{this.getName(), realId, id});
        if (this.timestamps.containsKey(id)) {
            return;
        }
        this.parsed.put(id, element);
        this.persistImage(id, element.getImage());
        this.timestamps.put(id, new TimestampedKey(id, System.currentTimeMillis()));
    }

    @Override
    public synchronized void removeElement(UUID elementId) throws CoreException {
        this.parsed.remove(elementId);
        this.persistImage(elementId, null);
    }

    @Override
    public boolean sequenceChanged() {
        return this.sequenceChanged;
    }

    private void checkCache() {
        long now = System.currentTimeMillis();
        if (now - this.lastChecked < 1000L) {
            return;
        }
        if (this.cacheTime >= this.sqFile.lastModified()) {
            this.lastChecked = now;
            return;
        }
        try {
            Lock lock = Lock.lock(this.sqFile, false);
            try {
                this.timestamps.clear();
                this.parsed.clear();
                this.allElements = null;
                File[] files = this.folder.listFiles();
                int idx = files.length;
                while (--idx >= 0) {
                    File file = files[idx];
                    String name = file.getName();
                    if (name.charAt(0) == '.') continue;
                    UUID id = UUID.fromString(name);
                    this.timestamps.put(id, new TimestampedKey(id, file.lastModified()));
                }
                this.cacheTime = this.sqFile.lastModified();
                this.lastChecked = System.currentTimeMillis();
            }
            finally {
                lock.release();
            }
        }
        catch (CoreException e) {
            CorePlugin.getLogger().error((Throwable)e, e.getMessage(), new Object[0]);
        }
    }

    private File getElementFile(UUID elementId) {
        return new File(this.folder, elementId.toString());
    }

    private void persistImage(UUID elementId, byte[] image) throws CoreException {
        Lock lock = Lock.lock(this.sqFile, true);
        try {
            this.allElements = null;
            File elementFile = this.getElementFile(elementId);
            if (image == null) {
                if (!elementFile.delete() && elementFile.exists()) {
                    throw new FileUtils.DeleteException(elementFile);
                }
                this.timestamps.remove(elementId);
            } else {
                FileOutputStream output = null;
                try {
                    try {
                        output = new FileOutputStream(elementFile);
                        ((OutputStream)output).write(image);
                    }
                    catch (IOException e) {
                        elementFile.delete();
                        throw BuckminsterException.wrap((Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.close(output);
                    throw throwable;
                }
                IOUtils.close((Closeable)output);
            }
            this.lastChecked = this.cacheTime = System.currentTimeMillis();
            this.sqFile.setLastModified(this.cacheTime);
        }
        finally {
            lock.release();
        }
    }

    public static class Lock {
        private final RandomAccessFile lockFile;
        private FileLock lock;

        public static Lock lock(File file, boolean exclusive) throws CoreException {
            return new Lock(file, exclusive);
        }

        private Lock(File file, boolean exclusive) throws CoreException {
            RandomAccessFile raFile = null;
            try {
                raFile = new RandomAccessFile(file, "rws");
                this.lock = raFile.getChannel().lock(0L, Long.MAX_VALUE, !exclusive);
                this.lockFile = raFile;
            }
            catch (IOException e) {
                IOUtils.close(raFile);
                throw BuckminsterException.wrap((Throwable)e);
            }
        }

        public FileChannel getLockChannel() {
            return this.lock.channel();
        }

        public RandomAccessFile getLockFile() {
            return this.lockFile;
        }

        public void migrateToExclusive() throws CoreException {
            if (this.lock.isShared()) {
                FileLock shared = this.lock;
                try {
                    FileChannel channel = shared.channel();
                    shared.release();
                    this.lock = channel.lock(0L, Long.MAX_VALUE, true);
                }
                catch (IOException e) {
                    throw BuckminsterException.wrap((Throwable)e);
                }
            }
        }

        public void release() {
            try {
                this.lock.release();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            IOUtils.close((Closeable)this.lockFile);
        }
    }
}

