/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.cspec.AbstractResolutionBuilder;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.metadata.ReferentialIntegrityException;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.Materialization;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.query.builder.ComponentQueryBuilder;
import org.eclipse.buckminster.core.reader.EclipsePreferencesReader;
import org.eclipse.buckminster.core.resolver.LocalResolver;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.runtime.AttachableProgressMonitor;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;

public class MetadataSynchronizer
implements IResourceChangeListener {
    private static MetadataSynchronizer defaultSynchronizer = new MetadataSynchronizer();
    private final HashMap<String, Pattern> cspecSources = new HashMap();
    private MetadataRefreshJob currentRefreshJob;
    private final HashMap<String, IPath> deletedProjectLocations = new HashMap();
    private final Set<IProject> projectsNeedingUpdate = new HashSet<IProject>();
    private final Set<IPath> removedEntries = new HashSet<IPath>();

    public static MetadataSynchronizer getDefault() {
        return defaultSynchronizer;
    }

    public static void refreshProject(IProject project, IProgressMonitor monitor) throws CoreException {
        if (project.getName().equals(".buckminster") || !project.isAccessible()) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            return;
        }
        IPath location = project.getLocation();
        if (location == null) {
            return;
        }
        Resolution oldInfo = null;
        ComponentIdentifier cid = WorkspaceInfo.getComponentIdentifier((IResource)project);
        if (cid != null) {
            oldInfo = WorkspaceInfo.getResolution(cid);
        }
        monitor.beginTask(null, 100);
        try {
            ComponentRequest request = oldInfo == null ? new ComponentRequest(project.getName(), null, null) : new ComponentRequest(oldInfo.getRequest().getName(), null, null);
            ComponentQueryBuilder queryBld = new ComponentQueryBuilder();
            queryBld.setRootRequest(request);
            queryBld.setPlatformAgnostic(true);
            ResolutionContext context = new ResolutionContext(queryBld.createComponentQuery());
            Resolution res = LocalResolver.fromPath(context.getRootNodeQuery(), project.getLocation(), oldInfo);
            if (!res.equals(oldInfo)) {
                StorageManager sm = StorageManager.getDefault();
                res.store(sm);
                ComponentIdentifier ci = res.getComponentIdentifier();
                Materialization mat = new Materialization(location.addTrailingSeparator(), ci);
                mat.store(sm);
                WorkspaceInfo.setComponentIdentifier((IResource)project, ci);
                if (oldInfo != null) {
                    try {
                        oldInfo.remove(sm);
                        oldInfo.getCSpec().remove(sm);
                    }
                    catch (ReferentialIntegrityException referentialIntegrityException) {
                        // empty catch block
                    }
                }
            }
            MetadataSynchronizer.updateProjectReferences(project, res.getCSpec(), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
        }
        finally {
            monitor.done();
        }
    }

    public static void setUp() {
        IExtensionRegistry exReg = Platform.getExtensionRegistry();
        if (exReg == null) {
            return;
        }
        IConfigurationElement[] elems = exReg.getConfigurationElementsFor("org.eclipse.buckminster.core.componentTypes");
        defaultSynchronizer.registerCSpecSource("buckminster.cspex");
        defaultSynchronizer.registerCSpecSource(EclipsePreferencesReader.BUCKMINSTER_PROJECT_PREFS_PATH);
        IConfigurationElement[] iConfigurationElementArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = elem.getChildren("metaFile");
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement metaFile = iConfigurationElementArray2[n4];
                String metaPath = metaFile.getAttribute("path");
                if (metaPath != null) {
                    if ((metaPath = metaPath.trim()).length() > 0) {
                        defaultSynchronizer.registerCSpecSource(metaPath);
                    }
                    String[] stringArray = TextUtils.split(metaFile.getAttribute("aliases"), ",");
                    int n5 = stringArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String alias = stringArray[n6];
                        if ((alias = alias.trim()).length() > 0) {
                            defaultSynchronizer.registerCSpecSource(alias);
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.addResourceChangeListener((IResourceChangeListener)defaultSynchronizer, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tearDown() {
        MetadataSynchronizer mds = defaultSynchronizer;
        if (mds == null) {
            return;
        }
        defaultSynchronizer = null;
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        if (ws != null) {
            ws.removeResourceChangeListener((IResourceChangeListener)mds);
        }
        MetadataSynchronizer metadataSynchronizer = mds;
        synchronized (metadataSynchronizer) {
            if (mds.currentRefreshJob != null) {
                mds.currentRefreshJob.cancel();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static void workspaceCatchUp(IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        wsRoot.accept((IResourceVisitor)new ResetVisitor());
        MonitorUtils.worked((IProgressMonitor)monitor, (int)50);
        IProject[] projects = wsRoot.getProjects();
        MonitorUtils.worked((IProgressMonitor)monitor, (int)50);
        if (projects.length > 0) {
            int ticksPerRefresh = 900 / projects.length;
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                try {
                    MetadataSynchronizer.refreshProject(project, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)ticksPerRefresh));
                }
                catch (Exception e) {
                    CorePlugin.getLogger().warning((Throwable)e, NLS.bind((String)Messages.Problem_during_meta_data_refresh_0, (Object)e.getMessage()), new Object[0]);
                }
                ++n2;
            }
        }
    }

    private static void updateProjectReferences(IProject project, ICSpecData cspec, IProgressMonitor monitor) throws CoreException {
        int n;
        Collection<? extends IComponentRequest> crefs = cspec.getDependencies();
        if (crefs.size() == 0) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            return;
        }
        ProjectDescription projDesc = (ProjectDescription)project.getDescription();
        IProject[] refs = projDesc.getAllReferences(false);
        HashSet<String> oldSet = new HashSet<String>(refs.length);
        IProject[] iProjectArray = refs;
        int n2 = refs.length;
        int n3 = 0;
        while (n3 < n2) {
            IProject oldRef = iProjectArray[n3];
            oldSet.add(oldRef.getName());
            ++n3;
        }
        Logger logger = CorePlugin.getLogger();
        monitor.beginTask(null, 50 + crefs.size() * 10);
        ArrayList<IProject> refdProjs = null;
        for (IComponentRequest iComponentRequest : crefs) {
            IResource[] iResourceArray = WorkspaceInfo.getResources(iComponentRequest);
            int n4 = iResourceArray.length;
            n = 0;
            while (n < n4) {
                IResource resource = iResourceArray[n];
                if (resource instanceof IProject) {
                    IProject refdProj = (IProject)resource;
                    if (!refdProj.isOpen()) {
                        logger.warning(NLS.bind((String)Messages.Project_0_references_closed_project_1, (Object)project.getName(), (Object)iComponentRequest.getName()), new Object[0]);
                    } else if (!oldSet.contains(refdProj.getName())) {
                        if (refdProjs == null) {
                            refdProjs = new ArrayList<IProject>();
                            IProject[] iProjectArray2 = projDesc.getDynamicReferences(false);
                            int n5 = iProjectArray2.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IProject dynRef = iProjectArray2[n6];
                                refdProjs.add(dynRef);
                                ++n6;
                            }
                        }
                        refdProjs.add(refdProj);
                    }
                }
                ++n;
            }
            monitor.worked(10);
        }
        if (refdProjs != null) {
            refs = refdProjs.toArray(new IProject[refdProjs.size()]);
            projDesc.setDynamicReferences(refs);
            project.setDescription((IProjectDescription)projDesc, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            if (logger.isDebugEnabled()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(NLS.bind((String)Messages.Project_0_now_has_dynamic_dependencies_to, (Object)project.getName()));
                IProject[] iProjectArray3 = refs;
                n = refs.length;
                int n7 = 0;
                while (n7 < n) {
                    IProject ref = iProjectArray3[n7];
                    stringBuilder.append(' ');
                    stringBuilder.append(ref.getName());
                    ++n7;
                }
                logger.debug(stringBuilder.toString(), new Object[0]);
            }
        }
        monitor.done();
    }

    public void registerCSpecSource(String path) {
        if ((path = TextUtils.notEmptyTrimmedString(path)) == null) {
            return;
        }
        StringBuilder bld = new StringBuilder(path.length() + 10);
        bld.append('^');
        int top = path.length();
        int idx = 0;
        while (idx < top) {
            char c = path.charAt(idx);
            switch (c) {
                case '\\': {
                    bld.append('/');
                    break;
                }
                case '$': 
                case '&': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    bld.append('\\');
                    bld.append(c);
                    break;
                }
                case '?': {
                    bld.append('.');
                    break;
                }
                case '*': {
                    bld.append(".*");
                    break;
                }
                default: {
                    bld.append(c);
                }
            }
            ++idx;
        }
        bld.append('$');
        int flags = 0;
        if (FileUtils.CASE_INSENSITIVE_FS) {
            flags = 2;
        }
        this.cspecSources.put(path, Pattern.compile(bld.toString(), flags));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        if (defaultSynchronizer == null) {
            return;
        }
        if (event.getType() == 4) {
            IResource resource = event.getResource();
            if (resource instanceof IProject) {
                this.deletedProjectLocations.put(resource.getName(), resource.getLocation());
            }
            return;
        }
        try {
            event.getDelta().accept((IResourceDeltaVisitor)new Visitor());
            this.deletedProjectLocations.clear();
        }
        catch (CoreException e) {
            CorePlugin.getLogger().error((Throwable)e, e.getMessage(), new Object[0]);
        }
        MetadataSynchronizer metadataSynchronizer = this;
        synchronized (metadataSynchronizer) {
            if (this.currentRefreshJob == null && (this.projectsNeedingUpdate.size() > 0 || this.removedEntries.size() > 0)) {
                this.currentRefreshJob = new MetadataRefreshJob();
                this.currentRefreshJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void done(IJobChangeEvent ev) {
                        if (defaultSynchronizer == null) {
                            return;
                        }
                        MetadataSynchronizer metadataSynchronizer = MetadataSynchronizer.this;
                        synchronized (metadataSynchronizer) {
                            if (MetadataSynchronizer.this.removedEntries.isEmpty() && MetadataSynchronizer.this.projectsNeedingUpdate.isEmpty()) {
                                MetadataSynchronizer.this.currentRefreshJob = null;
                            } else {
                                MetadataSynchronizer.this.currentRefreshJob.schedule();
                            }
                        }
                    }
                });
                this.currentRefreshJob.schedule();
            }
        }
    }

    synchronized IProject getNextProjectNeedingUpdate() {
        if (this.projectsNeedingUpdate.isEmpty()) {
            return null;
        }
        IProject entry = this.projectsNeedingUpdate.iterator().next();
        this.projectsNeedingUpdate.remove(entry);
        return entry;
    }

    synchronized IPath getNextRemovedEntry() {
        if (this.removedEntries.isEmpty()) {
            return null;
        }
        IPath entry = this.removedEntries.iterator().next();
        this.removedEntries.remove(entry);
        return entry;
    }

    private boolean isCSpecSource(IResource resource, IPath path) {
        String pathStr = path.toPortableString();
        for (Pattern pattern : this.cspecSources.values()) {
            Matcher m = pattern.matcher(pathStr);
            if (!m.matches()) continue;
            return true;
        }
        IProject project = resource.getProject();
        if (project == null) {
            return false;
        }
        ProjectScope scope = new ProjectScope(project);
        IEclipsePreferences prefs = scope.getNode(CorePlugin.getID());
        String tmp = AbstractResolutionBuilder.getMetadataFile(prefs, IComponentType.PREF_CSPEC_FILE, "buckminster.cspec");
        if (path.equals((Object)Path.fromPortableString((String)tmp))) {
            return true;
        }
        tmp = AbstractResolutionBuilder.getMetadataFile(prefs, IComponentType.PREF_CSPEX_FILE, "buckminster.cspex");
        return path.equals((Object)Path.fromPortableString((String)tmp));
    }

    class MetadataRefreshJob
    extends Job {
        public MetadataRefreshJob() {
            super(Messages.Metadata_refresh);
            this.setPriority(20);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            int ticks;
            MetadataSynchronizer metadataSynchronizer = MetadataSynchronizer.this;
            synchronized (metadataSynchronizer) {
                ticks = MetadataSynchronizer.this.removedEntries.size() * 30 + MetadataSynchronizer.this.projectsNeedingUpdate.size() * 70;
            }
            if (ticks == 0) {
                MonitorUtils.complete((IProgressMonitor)monitor);
                return Status.OK_STATUS;
            }
            monitor.beginTask(null, ticks);
            try {
                StorageManager sm = StorageManager.getDefault();
                boolean didSomething = true;
                while (didSomething && defaultSynchronizer != null) {
                    IProject project;
                    IPath removedEntry;
                    didSomething = false;
                    while (defaultSynchronizer != null && (removedEntry = MetadataSynchronizer.this.getNextRemovedEntry()) != null) {
                        didSomething = true;
                        Materialization[] materializationArray = (Materialization[])sm.getMaterializations().getElements();
                        int n = materializationArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Materialization mat = materializationArray[n2];
                            if (mat.getComponentLocation().equals((Object)removedEntry)) {
                                if (removedEntry.toFile().exists()) break;
                                Resolution res = WorkspaceInfo.getResolution(mat.getComponentIdentifier());
                                try {
                                    res.remove(sm);
                                }
                                catch (ReferentialIntegrityException referentialIntegrityException) {
                                    // empty catch block
                                }
                                mat.remove(sm);
                                break;
                            }
                            ++n2;
                        }
                        MonitorUtils.worked((IProgressMonitor)monitor, (int)30);
                    }
                    while (defaultSynchronizer != null && (project = MetadataSynchronizer.this.getNextProjectNeedingUpdate()) != null) {
                        didSomething = true;
                        monitor.subTask(NLS.bind((String)Messages.Refreshing_0, (Object)project.getName()));
                        try {
                            MetadataSynchronizer.refreshProject(project, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)70));
                        }
                        catch (Exception e) {
                            if (defaultSynchronizer == null || !project.isAccessible()) continue;
                            CorePlugin.getLogger().error((Throwable)e, NLS.bind((String)Messages.Project_refresh_on_0_failed_1, (Object)project.getName(), (Object)e.getMessage()), new Object[0]);
                        }
                    }
                }
                return Status.OK_STATUS;
            }
            catch (Exception e) {
                if (defaultSynchronizer != null) {
                    CorePlugin.getLogger().error((Throwable)e, e.toString(), new Object[0]);
                }
                return BuckminsterException.wrap((Throwable)e).getStatus();
            }
        }
    }

    static class ResetVisitor
    implements IResourceVisitor {
        ResetVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IProject && !((IProject)resource).isOpen()) {
                return false;
            }
            String cidStr = resource.getPersistentProperty(WorkspaceInfo.PPKEY_COMPONENT_ID);
            if (cidStr != null) {
                resource.setPersistentProperty(WorkspaceInfo.PPKEY_COMPONENT_ID, null);
            }
            return true;
        }
    }

    private class Visitor
    implements IResourceDeltaVisitor {
        private Visitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean visit(IResourceDelta delta) throws CoreException {
            int kind = delta.getKind();
            IResource resource = delta.getResource();
            if (kind == 2) {
                if ((delta.getFlags() & 0x2000) != 0) {
                    return false;
                }
                if (resource == null) {
                    return false;
                }
                IProject project = resource.getProject();
                if (project == null) {
                    return true;
                }
                IPath relPath = resource.getProjectRelativePath();
                IPath path = resource.getLocation();
                if (path == null) {
                    IPath projPath = (IPath)MetadataSynchronizer.this.deletedProjectLocations.get(project.getName());
                    if (projPath == null) {
                        return false;
                    }
                    path = projPath.append(relPath);
                }
                if (!(resource instanceof IFile)) {
                    path = path.addTrailingSeparator();
                }
                MetadataSynchronizer metadataSynchronizer = MetadataSynchronizer.this;
                synchronized (metadataSynchronizer) {
                    block19: {
                        MetadataSynchronizer.this.removedEntries.add(path);
                        if (!MetadataSynchronizer.this.isCSpecSource(resource, relPath)) break block19;
                        MetadataSynchronizer.this.projectsNeedingUpdate.add(resource.getProject());
                        return false;
                    }
                    return true;
                }
            }
            if (kind == 1 && (delta.getFlags() & 0x1000) != 0) {
                MetadataSynchronizer metadataSynchronizer = MetadataSynchronizer.this;
                synchronized (metadataSynchronizer) {
                    WorkspaceInfo.setComponentIdentifier(resource, null);
                    MetadataSynchronizer.this.projectsNeedingUpdate.add(resource.getProject());
                }
                return false;
            }
            if ((kind == 1 || (delta.getFlags() & 0x40100) != 0) && (resource instanceof IProject || MetadataSynchronizer.this.isCSpecSource(resource, resource.getProjectRelativePath()))) {
                MetadataSynchronizer metadataSynchronizer = MetadataSynchronizer.this;
                synchronized (metadataSynchronizer) {
                    MetadataSynchronizer.this.projectsNeedingUpdate.add(resource.getProject());
                }
                return false;
            }
            return true;
        }
    }

    static class WorkspaceCatchUpJob
    extends Job {
        private static final QualifiedName QN_ATTACHABLE_PROGRESS_MONITOR = new QualifiedName(CorePlugin.getID(), "attachableProgressMonitor");
        private AttachableProgressMonitor attachableMonitor;

        public WorkspaceCatchUpJob() {
            super(Messages.Buckminster_workspace_catch_up);
            this.setPriority(20);
            this.attachableMonitor = new AttachableProgressMonitor();
            this.setProperty(QN_ATTACHABLE_PROGRESS_MONITOR, this.attachableMonitor);
        }

        public boolean belongsTo(Object family) {
            return family == MetadataSynchronizer.class;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor = this.attachableMonitor.wrap(monitor);
            monitor.beginTask(Messages.Refreshing_project_meta_data, 1000);
            try {
                try {
                    MetadataSynchronizer.workspaceCatchUp(monitor);
                }
                catch (Exception e) {
                    CorePlugin.getLogger().warning((Throwable)e, NLS.bind((String)Messages.Problem_during_meta_data_refresh_0, (Object)e.getMessage()), new Object[0]);
                    this.setProperty(QN_ATTACHABLE_PROGRESS_MONITOR, null);
                    monitor.done();
                }
            }
            finally {
                this.setProperty(QN_ATTACHABLE_PROGRESS_MONITOR, null);
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }
}

