/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.mspec.builder;

import java.util.regex.Pattern;
import org.eclipse.buckminster.core.mspec.IMaterializationNode;
import org.eclipse.buckminster.core.mspec.builder.MaterializationDirectiveBuilder;
import org.eclipse.buckminster.core.mspec.model.MaterializationNode;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class MaterializationNodeBuilder
extends MaterializationDirectiveBuilder
implements IMaterializationNode {
    private Pattern namePattern;
    private Filter filter;
    private IPath leafArtifact;
    private String componentTypeID;
    private boolean exclude;
    private Pattern bindingNamePattern;
    private String bindingNameReplacement;
    private String suffix;
    private boolean unpack;
    private boolean expand = true;
    private IPath resourcePath;

    public void clear() {
        super.clear();
        this.namePattern = null;
        this.filter = null;
        this.leafArtifact = null;
        this.componentTypeID = null;
        this.resourcePath = null;
        this.exclude = false;
        this.bindingNamePattern = null;
        this.bindingNameReplacement = null;
        this.suffix = null;
        this.unpack = false;
        this.expand = true;
    }

    public MaterializationNode createMaterializationNode() {
        return new MaterializationNode(this);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        if (adapter.isAssignableFrom(MaterializationNode.class)) {
            return new MaterializationNode(this);
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public Pattern getBindingNamePattern() {
        return this.bindingNamePattern;
    }

    public String getBindingNameReplacement() {
        return this.bindingNameReplacement;
    }

    public String getComponentTypeID() {
        return this.componentTypeID;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public IPath getLeafArtifact() {
        return this.leafArtifact;
    }

    public Pattern getNamePattern() {
        return this.namePattern;
    }

    public IPath getResourcePath() {
        return this.resourcePath;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void initFrom(IMaterializationNode mn) {
        super.initFrom(mn);
        this.namePattern = mn.getNamePattern();
        this.filter = mn.getFilter();
        this.leafArtifact = mn.getLeafArtifact();
        this.componentTypeID = mn.getComponentTypeID();
        this.resourcePath = mn.getResourcePath();
        this.exclude = mn.isExclude();
        this.bindingNamePattern = mn.getBindingNamePattern();
        this.bindingNameReplacement = mn.getBindingNameReplacement();
        this.suffix = mn.getSuffix();
        this.unpack = mn.isUnpack();
        this.expand = mn.isExpand();
    }

    public boolean isExclude() {
        return this.exclude;
    }

    public boolean isExpand() {
        return this.expand;
    }

    public boolean isUnpack() {
        return this.unpack;
    }

    public void setBindingNamePattern(Pattern bindingNamePattern) {
        this.bindingNamePattern = bindingNamePattern;
    }

    public void setBindingNameReplacement(String bindingNameReplacement) {
        this.bindingNameReplacement = bindingNameReplacement;
    }

    public void setComponentTypeID(String componentTypeID) {
        this.componentTypeID = componentTypeID;
    }

    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }

    public void setExpand(boolean expand) {
        this.expand = expand;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setLeafArtifact(IPath leafArtifact) {
        this.leafArtifact = leafArtifact;
    }

    public void setNamePattern(Pattern namePattern) {
        this.namePattern = namePattern;
    }

    public void setResourcePath(IPath resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setUnpack(boolean unpack) {
        this.unpack = unpack;
    }
}

