/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.reader;

import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.reader.AbstractReaderType;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IVersionFinder;
import org.eclipse.buckminster.core.reader.LocalReader;
import org.eclipse.buckminster.core.reader.URLCatalogReaderType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.AbstractVersionFinder;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class LocalReaderType
extends URLCatalogReaderType {
    private static final IVersionFinder blindFinder = new AbstractVersionFinder(null, null, null){

        public VersionMatch getBestVersion(IProgressMonitor monitor) throws CoreException {
            MonitorUtils.complete((IProgressMonitor)monitor);
            return null;
        }
    };

    public IPath getFixedLocation(Resolution rc) throws CoreException {
        try {
            File file = FileUtils.getFile(URLUtils.normalizeToURL((String)rc.getRepository()));
            if (file == null) {
                throw new IllegalArgumentException(Messages.Resolution_not_created_using_LocalReader);
            }
            IPath path = Path.fromOSString((String)file.toString());
            if (path.toFile().isDirectory()) {
                path = path.addTrailingSeparator();
            }
            return path;
        }
        catch (MalformedURLException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public IComponentReader getReader(ProviderMatch providerMatch, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new LocalReader(this, providerMatch);
    }

    public IVersionFinder getVersionFinder(Provider provider, IComponentType ctype, NodeQuery nodeQuery, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return nodeQuery.useWorkspace() || nodeQuery.useMaterialization() ? new AbstractReaderType.DefaultVersionFinder(provider, ctype, nodeQuery) : blindFinder;
    }
}

