/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.resolver;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.GeneratorNode;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.core.resolver.ResolverNode;
import org.eclipse.buckminster.core.resolver.ResourceMapResolver;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

class ResolverNodeWithJob
extends ResolverNode {
    private final ResourceMapResolver resolver;
    private final NodeResolutionJob job;
    private static final String SOURCE_SUFFIX = ".source";
    private static final String SOURCE_FEATURE_SUFFIX = ".source.feature";

    public static String getIdWithoutSource(String sourceId) {
        if (sourceId.endsWith(SOURCE_SUFFIX)) {
            return sourceId.substring(0, sourceId.length() - SOURCE_SUFFIX.length());
        }
        if (sourceId.endsWith(SOURCE_FEATURE_SUFFIX)) {
            return String.valueOf(sourceId.substring(0, sourceId.length() - SOURCE_FEATURE_SUFFIX.length())) + ".feature";
        }
        return null;
    }

    ResolverNodeWithJob(ResourceMapResolver resolver, ResolutionContext context, QualifiedDependency qDep, String requestorInfo) {
        super(context.getNodeQuery(qDep), requestorInfo);
        this.job = new NodeResolutionJob(qDep.getRequest().toString());
        this.resolver = resolver;
    }

    public synchronized void addDependencyQualification(QualifiedDependency newQDep, String tagInfo) throws CoreException {
        super.addDependencyQualification(newQDep, tagInfo);
        if (this.isInvalidated() && !this.isForceUnresolved() && !this.isScheduled()) {
            this.resolver.schedule(this);
        }
    }

    /*
     * Loose catch block
     */
    protected IStatus run(IProgressMonitor monitor) {
        block16: {
            if (this.isForceUnresolved()) {
                this.resolver.resolutionPartDone();
                return Status.OK_STATUS;
            }
            this.clearInvalidationFlag();
            this.resolver.addJobMonitor(monitor);
            BOMNode node = null;
            try {
                try {
                    node = this.resolve(monitor);
                    if (node != null) {
                        this.resolver.resolutionPartDone();
                        this.buildTree(node);
                    }
                }
                catch (CoreException e) {
                    ResolutionContext context = this.resolver.getContext();
                    ((RMContext)context).addRequestStatus(this.getQuery().getComponentRequest(), e.getStatus());
                    if (!((RMContext)context).isContinueOnError()) {
                        this.resolver.cancelTopMonitor();
                    }
                    this.resolver.removeJobMonitor(monitor);
                    if (node == null) {
                        this.resolver.resolutionPartDone();
                    }
                }
                catch (OperationCanceledException e) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    this.resolver.removeJobMonitor(monitor);
                    if (node == null) {
                        this.resolver.resolutionPartDone();
                    }
                    return iStatus;
                }
                catch (Throwable e) {
                    this.resolver.getContext().addRequestStatus(this.getQuery().getComponentRequest(), BuckminsterException.wrap((Throwable)e).getStatus());
                    this.resolver.removeJobMonitor(monitor);
                    if (node == null) {
                        this.resolver.resolutionPartDone();
                    }
                    break block16;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                this.resolver.removeJobMonitor(monitor);
                if (node == null) {
                    this.resolver.resolutionPartDone();
                }
            }
        }
        return Status.OK_STATUS;
    }

    NodeResolutionJob getJob() {
        return this.job;
    }

    boolean isScheduled() {
        return this.job.isScheduled();
    }

    boolean rebuildTree(BOMNode node) throws CoreException {
        this.clearInvalidationFlag();
        return this.buildTree(node);
    }

    void setScheduled(boolean scheduled) {
        this.job.setScheduled(scheduled);
    }

    private boolean buildTree(BOMNode node) throws CoreException {
        if (this.isInvalidated()) {
            return false;
        }
        ResolutionContext context = this.getQuery().getResolutionContext();
        GeneratorNode generatorNode = context.getGeneratorNode(node.getRequest());
        if (generatorNode != null) {
            this.setGeneratorNode(generatorNode);
            return false;
        }
        Resolution resolution = node.getResolution();
        if (resolution == null) {
            return this.resolver.schedule(this);
        }
        context = this.startResolvingChildren(node);
        if (context == null) {
            return false;
        }
        List<BOMNode> nodeChildren = node.getChildren();
        int top = nodeChildren.size();
        if (top == 0) {
            this.setResolution(resolution, null);
            return false;
        }
        CSpec cspec = resolution.getCSpec();
        String tagInfo = cspec.getTagInfo(this.getTagInfo());
        boolean isInSourceForm = "workspace".equals(resolution.getProvider().getReaderType().getRecommendedMaterializer());
        ArrayList<ResolverNode> children = null;
        boolean didSchedule = false;
        int idx = 0;
        while (idx < top) {
            String name;
            if (this.isInvalidated()) {
                return false;
            }
            BOMNode childNode = nodeChildren.get(idx);
            QualifiedDependency childReq = childNode.getQualifiedDependency();
            if (!(isInSourceForm && childReq.getRequest().isSyntheticSource() && ResolverNodeWithJob.getIdWithoutSource(name = childReq.getRequest().getName()).equals(cspec.getName()))) {
                ComponentQuery childQuery = childNode.getQuery();
                ResolutionContext childContext = childQuery == null ? context : new ResolutionContext(childQuery, context);
                ResolverNode child = this.resolver.getResolverNode(childContext, childReq, tagInfo);
                if (children == null) {
                    children = new ArrayList<ResolverNode>();
                }
                children.add(child);
                if (((ResolverNodeWithJob)child).buildTree(childNode)) {
                    didSchedule = true;
                }
            }
            ++idx;
        }
        this.setResolution(resolution, children == null ? null : children.toArray(new ResolverNode[children.size()]));
        return didSchedule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BOMNode resolve(IProgressMonitor monitor) throws CoreException {
        NodeQuery query;
        ResolverNodeWithJob resolverNodeWithJob = this;
        synchronized (resolverNodeWithJob) {
            query = this.getQuery();
            if (query.skipComponent() || this.isResolved()) {
                MonitorUtils.complete((IProgressMonitor)monitor);
                return null;
            }
        }
        if (this.isInvalidated()) {
            return null;
        }
        return this.resolver.innerResolve(query, monitor);
    }

    class NodeResolutionJob
    extends Job {
        private boolean scheduled;

        NodeResolutionJob(String name) {
            super(name);
        }

        public boolean belongsTo(Object family) {
            return family == ResolverNodeWithJob.this.resolver;
        }

        protected IStatus run(IProgressMonitor monitor) {
            return ResolverNodeWithJob.this.run(monitor);
        }

        ResolverNodeWithJob getNode() {
            return ResolverNodeWithJob.this;
        }

        boolean isScheduled() {
            return this.scheduled;
        }

        void setScheduled(boolean flag) {
            this.scheduled = flag;
        }
    }
}

