/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.parser;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.common.model.Format;
import org.eclipse.buckminster.core.common.parser.DocumentationHandler;
import org.eclipse.buckminster.core.common.parser.FormatHandler;
import org.eclipse.buckminster.core.common.parser.PropertyManagerHandler;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.SearchPath;
import org.eclipse.buckminster.core.rmap.model.URIMatcher;
import org.eclipse.buckminster.core.rmap.model.VersionConverterDesc;
import org.eclipse.buckminster.core.rmap.parser.DigestHandler;
import org.eclipse.buckminster.core.rmap.parser.SearchPathHandler;
import org.eclipse.buckminster.core.rmap.parser.URIMatcherHandler;
import org.eclipse.buckminster.core.rmap.parser.VersionConverterHandler;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.MissingRequiredAttributeException;
import org.osgi.framework.InvalidSyntaxException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderHandler
extends PropertyManagerHandler {
    public static final String TAG = "provider";
    private DocumentationHandler documentationHandler;
    private FormatHandler uriHandler;
    private DigestHandler digestHandler;
    private VersionConverterHandler versionConverterHandler;
    private URIMatcherHandler uriMetaDataHandler;
    private URIMatcher uriMatcher;
    private Documentation documentation;
    private String readerType;
    private String[] componentTypes;
    private Format uriFormat;
    private Format digestFormat;
    private String digestAlgorithm;
    private VersionConverterDesc versionConverter;
    private Filter resolutionFilter;
    private final Map<String, String> properties = new ExpandingProperties<String>();

    public ProviderHandler(AbstractHandler parent) {
        super(parent, TAG);
    }

    @Override
    public void childPopped(ChildHandler child) throws SAXException {
        if (child == this.uriHandler) {
            this.uriFormat = (Format)this.uriHandler.getValueHolder();
        } else if (child == this.digestHandler) {
            this.digestFormat = (Format)this.digestHandler.getValueHolder();
            this.digestAlgorithm = this.digestHandler.getAlgorithm();
        } else if (child == this.versionConverterHandler) {
            this.versionConverter = this.versionConverterHandler.getVersionConverter();
        } else if (child == this.documentationHandler) {
            this.documentation = this.documentationHandler.createDocumentation();
        } else if (child == this.uriMetaDataHandler) {
            try {
                this.uriMatcher = this.uriMetaDataHandler.createURIMetaData();
            }
            catch (Exception e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), e);
            }
        } else {
            super.childPopped(child);
        }
    }

    @Override
    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        ChildHandler ch;
        if ("uri".equals(localName)) {
            if (this.uriHandler == null) {
                this.uriHandler = new FormatHandler((AbstractHandler)this);
            }
            ch = this.uriHandler;
        } else if ("digest".equals(localName)) {
            if (this.digestHandler == null) {
                this.digestHandler = new DigestHandler((AbstractHandler)this);
            }
            ch = this.digestHandler;
        } else if ("documentation".equals(localName)) {
            if (this.documentationHandler == null) {
                this.documentationHandler = new DocumentationHandler((AbstractHandler)this);
            }
            ch = this.documentationHandler;
        } else if ("versionConverter".equals(localName)) {
            if (this.versionConverterHandler == null) {
                this.versionConverterHandler = new VersionConverterHandler((AbstractHandler)this);
            }
            ch = this.versionConverterHandler;
        } else if ("matcher".equals(localName)) {
            if (this.uriMetaDataHandler == null) {
                this.uriMetaDataHandler = new URIMatcherHandler((AbstractHandler)this);
            }
            ch = this.uriMetaDataHandler;
        } else {
            ch = super.createHandler(uri, localName, attrs);
        }
        return ch;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Provider getProvider() {
        return new Provider(this.getSearchPath(), this.readerType, this.componentTypes, this.versionConverter, this.uriFormat, this.digestFormat, this.digestAlgorithm, this.resolutionFilter, this.properties, this.uriMatcher, this.documentation);
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        String resFilter;
        this.readerType = this.getStringValue(attrs, "readerType");
        if (this.readerType.equals("eclipse.import")) {
            this.logAttributeValueDeprecation(this.getTAG(), "readerType", "eclipse.import", "p2");
            this.readerType = "p2";
        }
        this.componentTypes = null;
        String tmp = ProviderHandler.getOptionalStringValue((Attributes)attrs, (String)"componentTypes");
        if (tmp == null) {
            ArrayList<String> expanded;
            tmp = ProviderHandler.getOptionalStringValue((Attributes)attrs, (String)"componentType");
            if (tmp == null) {
                throw new MissingRequiredAttributeException(this.getTAG(), "componentTypes", this.getDocumentLocator());
            }
            this.logAttributeDeprecation(this.getTAG(), "componentType", "componentTypes");
            boolean canManageBundle = true;
            boolean canManageFeature = true;
            String[] managedCategories = TextUtils.split(ProviderHandler.getOptionalStringValue((Attributes)attrs, (String)"managedCategories"), ",");
            if (managedCategories.length > 0) {
                this.logAttributeDeprecation(this.getTAG(), "managedCategories", "componentTypes");
                canManageBundle = false;
                canManageFeature = false;
                String[] stringArray = managedCategories;
                int n = managedCategories.length;
                int n2 = 0;
                while (n2 < n) {
                    String category = stringArray[n2];
                    if ("plugin".equals(category)) {
                        canManageBundle = true;
                    } else if ("feature".equals(category)) {
                        canManageFeature = true;
                    }
                    ++n2;
                }
            }
            if (tmp.equals("eclipse.project")) {
                expanded = new ArrayList<String>(3);
                if (canManageBundle) {
                    expanded.add("osgi.bundle");
                }
                if (canManageFeature) {
                    expanded.add("eclipse.feature");
                }
                expanded.add("buckminster");
                this.componentTypes = expanded.toArray(new String[expanded.size()]);
            } else if (tmp.equals("eclipse.installed")) {
                expanded = new ArrayList(3);
                if (canManageBundle) {
                    expanded.add("osgi.bundle");
                }
                if (canManageFeature) {
                    expanded.add("eclipse.feature");
                }
                this.componentTypes = expanded.toArray(new String[expanded.size()]);
            }
        } else if ("eclipse.project".equals(tmp)) {
            tmp = "osgi.bundle,eclipse.feature,buckminster";
        }
        if (this.componentTypes == null) {
            this.componentTypes = TextUtils.split(tmp, ",");
        }
        if (!ProviderHandler.getOptionalBooleanValue((Attributes)attrs, (String)"mutable", (boolean)true)) {
            this.properties.put("buckminster.mutable", "false");
        }
        if (!ProviderHandler.getOptionalBooleanValue((Attributes)attrs, (String)"source", (boolean)true)) {
            this.properties.put("buckminster.source", "false");
        }
        if ((tmp = ProviderHandler.getOptionalStringValue((Attributes)attrs, (String)"space")) != null) {
            tmp = "(buckminster.spacepath=" + tmp + ')';
        }
        if ((resFilter = ProviderHandler.getOptionalStringValue((Attributes)attrs, (String)"resolutionFilter")) == null) {
            resFilter = tmp;
        } else if (tmp != null) {
            resFilter = "(&" + resFilter + tmp + ')';
        }
        if (resFilter != null) {
            try {
                this.resolutionFilter = FilterFactory.newInstance((String)resFilter);
            }
            catch (InvalidSyntaxException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), (Exception)((Object)e));
            }
        } else {
            this.resolutionFilter = null;
        }
        this.uriFormat = null;
        this.digestFormat = null;
        this.digestAlgorithm = null;
        this.versionConverter = null;
        this.uriMatcher = null;
        this.documentation = null;
    }

    protected final String[] getComponentTypes() {
        return this.componentTypes;
    }

    protected final String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    protected final Format getDigestFormat() {
        return this.digestFormat;
    }

    protected final Documentation getDocumentation() {
        return this.documentation;
    }

    protected final String getReaderType() {
        return this.readerType;
    }

    protected final Filter getResolutionFilter() {
        return this.resolutionFilter;
    }

    protected SearchPath getSearchPath() {
        SearchPath searchPath = null;
        AbstractHandler parent = this.getParentHandler();
        if (parent instanceof SearchPathHandler) {
            searchPath = ((SearchPathHandler)parent).getSearchPath();
        }
        return searchPath;
    }

    protected final Format getUriFormat() {
        return this.uriFormat;
    }

    protected final VersionConverterDesc getVersionConverter() {
        return this.versionConverter;
    }
}

