/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.helpers.AbstractExtension;
import org.eclipse.buckminster.core.helpers.DateAndTimeUtils;
import org.eclipse.buckminster.core.version.IQualifierGenerator;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildTimestampQualifierGenerator
extends AbstractExtension
implements IQualifierGenerator {
    public static final String DEFAULT_FORMAT = "'v'yyyyMMddHHmm";
    public static final String FORMAT_PROPERTY = "generator.buildTimestamp.format";
    public static final String TIMESTAMP_PROPERTY = "buckminster.build.timestamp";
    private static final UUID timestampKey = UUID.randomUUID();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getBuildTimestamp(IActionContext context) throws CoreException {
        Map<UUID, Object> invocationCache = context.getGlobalContext().getInvocationCache();
        UUID uUID = timestampKey;
        synchronized (uUID) {
            Date timestamp = (Date)invocationCache.get(timestampKey);
            if (timestamp == null) {
                Object isoTS = context.getProperties().get(TIMESTAMP_PROPERTY);
                if (isoTS instanceof String) {
                    try {
                        timestamp = DateAndTimeUtils.fromString((String)isoTS);
                    }
                    catch (ParseException e) {
                        throw BuckminsterException.fromMessage((Throwable)e, (String)NLS.bind((String)Messages.property_0_not_ISO_8601_conformant_timestamp_string, (Object)TIMESTAMP_PROPERTY), (Object[])new Object[0]);
                    }
                } else {
                    timestamp = new Date();
                }
                invocationCache.put(timestampKey, timestamp);
            }
            return timestamp;
        }
    }

    @Override
    public Version generateQualifier(IActionContext context, ComponentIdentifier cid, List<ComponentIdentifier> dependencies) throws CoreException {
        Version currentVersion = cid.getVersion();
        if (currentVersion == null) {
            return null;
        }
        Map<String, ? extends Object> props = context.getProperties();
        String format = (String)props.get(FORMAT_PROPERTY);
        if (format == null) {
            format = DEFAULT_FORMAT;
        }
        SimpleDateFormat mf = new SimpleDateFormat(format);
        mf.setTimeZone(DateAndTimeUtils.UTC);
        mf.setLenient(false);
        Date timestamp = BuildTimestampQualifierGenerator.getBuildTimestamp(context);
        String newQual = mf.format(timestamp);
        newQual = VersionHelper.getQualifier(currentVersion).replace("qualifier", newQual);
        return VersionHelper.replaceQualifier(currentVersion, newQual);
    }
}

