/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import java.util.Date;
import org.eclipse.buckminster.core.helpers.DateAndTimeUtils;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.equinox.p2.metadata.Version;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class VersionMatch
extends AbstractSaxableElement {
    public static final VersionMatch DEFAULT = new VersionMatch(null, null, -1L, null, null);
    public static final String TAG = "versionMatch";
    public static final String ATTR_ARTIFACT_INFO = "artifactInfo";
    public static final String ATTR_BRANCH_OR_TAG = "branchOrTag";
    public static final String ATTR_REVISION = "revision";
    public static final String ATTR_TIMESTAMP = "timestamp";
    private final String artifactInfo;
    private final VersionSelector branchOrTag;
    private final String revision;
    private final Date timestamp;
    private final Version version;

    public static boolean satisfiesRevision(String revision, String satisfiedBy) {
        if (revision == null) {
            return true;
        }
        if (satisfiedBy == null) {
            return false;
        }
        if (revision.equals(satisfiedBy)) {
            return true;
        }
        try {
            return Long.parseLong(revision) >= Long.parseLong(satisfiedBy);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public VersionMatch(Version version, VersionSelector branchOrTag, long revision, Date timestamp, String artifactInfo) {
        this(version, branchOrTag, revision == -1L ? null : Long.toString(revision), timestamp, artifactInfo);
    }

    public VersionMatch(Version version, VersionSelector branchOrTag, String revision, Date timestamp, String artifactInfo) {
        this.version = version;
        if (branchOrTag != null && branchOrTag.isDefault()) {
            branchOrTag = null;
        }
        this.branchOrTag = branchOrTag;
        this.revision = revision;
        this.timestamp = timestamp;
        this.artifactInfo = artifactInfo;
    }

    public VersionMatch copyWithVersion(Version newVersion) {
        if (Trivial.equalsAllowNull((Object)this.version, (Object)newVersion)) {
            return this;
        }
        return new VersionMatch(newVersion, this.branchOrTag, -1L, null, this.artifactInfo);
    }

    public String getArtifactInfo() {
        return this.artifactInfo;
    }

    public VersionSelector getBranchOrTag() {
        return this.branchOrTag;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public long getNumericRevision() {
        return this.revision == null ? -1L : Long.parseLong(this.revision);
    }

    public String getRevision() {
        return this.revision;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean satisfiesRevision(String rev) {
        return VersionMatch.satisfiesRevision(rev, this.revision);
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        this.toString(bld);
        return bld.toString();
    }

    public void toString(StringBuilder bld) {
        boolean needSep = false;
        if (this.version != null) {
            bld.append(VersionHelper.getHumanReadable(this.version));
            needSep = true;
        }
        if (this.branchOrTag != null) {
            if (needSep) {
                bld.append(':');
            }
            this.branchOrTag.toString(bld);
        }
        if (this.revision != null) {
            if (needSep) {
                bld.append(':');
            }
            bld.append('#');
            bld.append(this.revision);
        }
        if (this.timestamp != null) {
            bld.append(':');
            bld.append(DateAndTimeUtils.toISOFormat(this.timestamp));
        }
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        if (this.artifactInfo != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ARTIFACT_INFO, (String)this.artifactInfo);
        }
        if (this.branchOrTag != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_BRANCH_OR_TAG, (String)this.branchOrTag.toString());
        }
        if (this.revision != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_REVISION, (String)this.revision);
        }
        if (this.timestamp != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_TIMESTAMP, (String)DateAndTimeUtils.toISOFormat(this.timestamp));
        }
        if (this.version != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"version", (String)this.version.toString());
        }
    }
}

