/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.Property;
import org.eclipse.ant.internal.core.InternalCoreAntMessages;
import org.eclipse.buckminster.runtime.BuckminsterPreferences;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntRunner {
    public static final int MSG_ERR = 0;
    public static final int MSG_WARN = 1;
    public static final int MSG_INFO = 2;
    public static final int MSG_VERBOSE = 3;
    public static final int MSG_DEBUG = 4;
    private static boolean buildRunning = false;
    private static final Class<?> internalAntRunnerClass;
    private static final Method addBuildLogger;
    private static final Method getBuildErrorMessage;
    private static final Method setBuildFileLocation;
    private static final Method setAntHome;
    private static final Method addUserProperties;
    private static final Method addPropertyFiles;
    private static final Method setArguments;
    private static final Method setProgressMonitor;
    private static final Method setMessageOutputLevel;
    private static final Method setExecutionTargets;
    private static final Method run;
    private String buildFileLocation = "build.xml";
    private String[] targets;
    private Map<String, String> userProperties;
    private String[] arguments;
    private String[] propertyFiles;
    private String antHome;
    private String buildLoggerClassName;

    static {
        try {
            Class[] string = new Class[]{String.class};
            Class[] strings = new Class[]{String[].class};
            internalAntRunnerClass = AntRunner.getInternalAntRunnerClass();
            addBuildLogger = internalAntRunnerClass.getMethod("addBuildLogger", string);
            getBuildErrorMessage = internalAntRunnerClass.getMethod("getBuildExceptionErrorMessage", Throwable.class);
            run = internalAntRunnerClass.getMethod("run", Trivial.EMPTY_CLASS_ARRAY);
            setBuildFileLocation = internalAntRunnerClass.getMethod("setBuildFileLocation", string);
            setAntHome = internalAntRunnerClass.getMethod("setAntHome", string);
            addUserProperties = internalAntRunnerClass.getMethod("addUserProperties", Map.class);
            addPropertyFiles = internalAntRunnerClass.getMethod("addPropertyFiles", strings);
            setArguments = internalAntRunnerClass.getMethod("setArguments", strings);
            setProgressMonitor = internalAntRunnerClass.getMethod("setProgressMonitor", IProgressMonitor.class);
            setMessageOutputLevel = internalAntRunnerClass.getMethod("setMessageOutputLevel", Integer.TYPE);
            setExecutionTargets = internalAntRunnerClass.getMethod("setExecutionTargets", strings);
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError((Throwable)AntRunner.problemLoadingClass(e));
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static boolean isBuildRunning() {
        return buildRunning;
    }

    static CoreException handleInvocationTargetException(Object runner, Class<?> classInternalAntRunner, InvocationTargetException e) {
        Throwable realException = e.getTargetException();
        if (realException instanceof OperationCanceledException) {
            return new CoreException(Status.CANCEL_STATUS);
        }
        String message = null;
        if (runner != null) {
            try {
                message = (String)getBuildErrorMessage.invoke(runner, realException);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (message == null && (realException instanceof NoClassDefFoundError || realException instanceof ClassNotFoundException)) {
            return AntRunner.problemLoadingClass(realException);
        }
        boolean internalError = false;
        if (message == null) {
            internalError = true;
            message = realException.getMessage() == null ? InternalCoreAntMessages.AntRunner_Build_Failed__3 : realException.getMessage();
        }
        Status status = new Status(4, "org.eclipse.ant.core", 1, message, realException);
        if (internalError) {
            AntCorePlugin.getPlugin().getLog().log((IStatus)status);
        }
        return new CoreException((IStatus)status);
    }

    static CoreException problemLoadingClass(Throwable e) {
        String message;
        String missingClassName = e.getMessage();
        if (missingClassName != null) {
            missingClassName = missingClassName.replace('/', '.');
            message = InternalCoreAntMessages.AntRunner_Could_not_find_one_or_more_classes__Please_check_the_Ant_classpath__2;
            message = NLS.bind((String)message, (Object[])new String[]{missingClassName});
        } else {
            message = InternalCoreAntMessages.AntRunner_Could_not_find_one_or_more_classes__Please_check_the_Ant_classpath__1;
        }
        Status status = new Status(4, "org.eclipse.ant.core", 1, message, e);
        AntCorePlugin.getPlugin().getLog().log((IStatus)status);
        return new CoreException((IStatus)status);
    }

    private static ClassLoader getClassLoader() {
        return AntCorePlugin.getPlugin().getNewClassLoader();
    }

    private static List<Property> getGlobalAntProperties() {
        return AntCorePlugin.getPlugin().getPreferences().getProperties();
    }

    private static Class<?> getInternalAntRunnerClass() throws ClassNotFoundException {
        ClassLoader loader = AntRunner.getClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        return loader.loadClass("org.eclipse.ant.internal.core.ant.InternalAntRunner");
    }

    public void addUserProperties(Map<String, String> properties) {
        if (this.userProperties == null) {
            this.userProperties = new HashMap<String, String>(properties);
        } else {
            this.userProperties.putAll(properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor monitor) throws CoreException {
        Class<?> clazz = internalAntRunnerClass;
        synchronized (clazz) {
            Object runner = null;
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    int messageOutputLevel;
                    runner = internalAntRunnerClass.newInstance();
                    setBuildFileLocation.invoke(runner, this.buildFileLocation);
                    if (this.antHome != null) {
                        setAntHome.invoke(runner, this.antHome);
                    }
                    if (this.buildLoggerClassName == null) {
                        this.buildLoggerClassName = "";
                    }
                    addBuildLogger.invoke(runner, this.buildLoggerClassName);
                    if (this.userProperties != null) {
                        Map<String, String> allProps = this.userProperties;
                        List<Property> properties = AntRunner.getGlobalAntProperties();
                        if (properties != null) {
                            allProps = new HashMap<String, String>(this.userProperties);
                            for (Property property : properties) {
                                String value = property.getValue(true);
                                if (value == null) continue;
                                allProps.put(property.getName(), value);
                            }
                        }
                        addUserProperties.invoke(runner, allProps);
                    }
                    if (this.propertyFiles != null && this.propertyFiles.length > 0) {
                        addPropertyFiles.invoke(runner, new Object[]{this.propertyFiles});
                    }
                    if (this.arguments != null && this.arguments.length > 0) {
                        setArguments.invoke(runner, new Object[]{this.arguments});
                    }
                    if (monitor != null) {
                        setProgressMonitor.invoke(runner, monitor);
                    }
                    switch (BuckminsterPreferences.getLogLevelAntLogger()) {
                        case 0: {
                            messageOutputLevel = 4;
                            break;
                        }
                        case 2: {
                            messageOutputLevel = 1;
                            break;
                        }
                        case 4: {
                            messageOutputLevel = 0;
                            break;
                        }
                        default: {
                            messageOutputLevel = 2;
                        }
                    }
                    if (messageOutputLevel != 2) {
                        setMessageOutputLevel.invoke(runner, new Integer(messageOutputLevel));
                    }
                    if (this.targets != null) {
                        setExecutionTargets.invoke(runner, new Object[]{this.targets});
                    }
                    run.invoke(runner, Trivial.EMPTY_OBJECT_ARRAY);
                }
                catch (NoClassDefFoundError e) {
                    throw AntRunner.problemLoadingClass(e);
                }
                catch (InvocationTargetException e) {
                    throw AntRunner.handleInvocationTargetException(runner, internalAntRunnerClass, e);
                }
                catch (Exception e) {
                    String message = e.getMessage() == null ? InternalCoreAntMessages.AntRunner_Build_Failed__3 : e.getMessage();
                    Status status = new Status(4, "org.eclipse.ant.core", 1, message, (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
            finally {
                buildRunning = false;
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    public void setAntHome(String antHome) {
        this.antHome = antHome;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public void setBuildFileLocation(IPath buildFileLocation) {
        this.buildFileLocation = buildFileLocation == null ? "build.xml" : buildFileLocation.toOSString();
    }

    public void setBuildLogger(String className) {
        this.buildLoggerClassName = className;
    }

    public void setExecutionTargets(String[] executionTargets) {
        this.targets = executionTargets;
    }

    public void setPropertyFiles(String[] propertyFiles) {
        this.propertyFiles = propertyFiles;
    }
}

