/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.actor;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.tools.ant.DirectoryScanner;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class CopyActor
extends AbstractActor {
    public static final String ID = "copy";
    public static final String PROP_INCLUDES = "includes";
    public static final String PROP_EXCLUDES = "excludes";
    public static final String PROP_DEFAULT_EXCLUDES = "defaultExcludes";

    protected IStatus internalPerform(IActionContext ctx, IProgressMonitor monitor) throws CoreException {
        Action action = ctx.getAction();
        File outputPath = AbstractActor.getSingleAttributePath((IActionContext)ctx, (Attribute)action, (boolean)true).toFile();
        outputPath.mkdirs();
        Map properties = action.getProperties();
        String[] includes = TextUtils.splitAndTrim((String)((String)properties.get(PROP_INCLUDES)), (String)",");
        String[] excludes = TextUtils.splitAndTrim((String)((String)properties.get(PROP_EXCLUDES)), (String)",");
        String dfltExcl = (String)properties.get(PROP_DEFAULT_EXCLUDES);
        boolean defaultExcludes = dfltExcl == null ? true : Boolean.parseBoolean(dfltExcl);
        PathGroup[] pgs = action.getPrerequisiteGroup().getPathGroups((IModelCache)ctx, null);
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)(pgs.length * 100));
        PathGroup[] pathGroupArray = pgs;
        int n = pgs.length;
        int n2 = 0;
        while (n2 < n) {
            PathGroup pg = pathGroupArray[n2];
            this.scanAndCopy(pg, includes, excludes, defaultExcludes, outputPath, (IProgressMonitor)subMon.newChild(100));
            ++n2;
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    private void scanAndCopy(PathGroup pg, String[] includes, String[] excludes, boolean defaultExcludes, File outputPath, IProgressMonitor monitor) throws CoreException {
        String includedFile;
        int n;
        int n2;
        String[] stringArray;
        File base = pg.getBase().toFile();
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(base);
        scanner.setIncludes(includes.length == 0 ? null : includes);
        scanner.setExcludes(excludes.length == 0 ? null : excludes);
        if (defaultExcludes) {
            scanner.addDefaultExcludes();
        }
        scanner.scan();
        String[] includedFiles = scanner.getIncludedFiles();
        if (includedFiles.length == 0) {
            return;
        }
        IPath[] paths = pg.getPaths();
        int npaths = paths.length;
        if (npaths > 0) {
            String[] osPaths = new String[npaths];
            int idx = 0;
            while (idx < npaths) {
                osPaths[idx] = paths[idx].toOSString();
                ++idx;
            }
            ArrayList<String> limitedList = new ArrayList<String>(paths.length);
            stringArray = includedFiles;
            n2 = includedFiles.length;
            n = 0;
            while (n < n2) {
                includedFile = stringArray[n];
                int idx2 = 0;
                while (idx2 < npaths) {
                    String osPath = osPaths[idx2];
                    if (includedFile.startsWith(osPath) && (includedFile.length() == osPath.length() || paths[idx2].hasTrailingSeparator())) {
                        limitedList.add(includedFile);
                        break;
                    }
                    ++idx2;
                }
                ++n;
            }
            includedFiles = limitedList.toArray(new String[limitedList.size()]);
            if (includedFiles.length == 0) {
                return;
            }
        }
        File lastOutputParent = null;
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)includedFiles.length);
        stringArray = includedFiles;
        n2 = includedFiles.length;
        n = 0;
        while (n < n2) {
            includedFile = stringArray[n];
            File outputFile = new File(outputPath, includedFile);
            File outputParent = outputFile.getParentFile();
            if (lastOutputParent == null || !lastOutputParent.equals(outputParent)) {
                outputParent.mkdirs();
                lastOutputParent = outputParent;
            }
            File inputFile = new File(base, includedFile);
            FileUtils.copyFile((File)inputFile, (File)outputParent, (String)outputFile.getName(), (IProgressMonitor)subMon.newChild(1));
            ++n;
        }
    }
}

