/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.materializer;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.eclipse.buckminster.ant.Messages;
import org.eclipse.buckminster.core.helpers.AbstractExtension;
import org.eclipse.buckminster.core.helpers.NullOutputStream;
import org.eclipse.buckminster.download.IExpander;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class TarExpander
extends AbstractExtension
implements IExpander {
    private FileFilter filter;
    private boolean flatten = false;

    public void expand(InputStream inputs, File destinationFolder, IProgressMonitor monitor) throws CoreException {
        TarInputStream input = null;
        int ticksLeft = 600;
        MonitorUtils.begin((IProgressMonitor)monitor, (int)ticksLeft);
        if (destinationFolder != null) {
            if (!destinationFolder.isDirectory() && !destinationFolder.mkdirs()) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.TarExpander_unable_to_unzip_into_directory_0, (Object)destinationFolder), (Object[])new Object[0]);
            }
            MonitorUtils.worked((IProgressMonitor)monitor, (int)10);
            ticksLeft -= 10;
        }
        try {
            try {
                TarEntry entry;
                input = new TarInputStream(inputs);
                while ((entry = input.getNextEntry()) != null) {
                    if (entry.isDirectory() && this.flatten) continue;
                    String name = this.getName(entry);
                    if (entry.isDirectory()) {
                        if (destinationFolder == null) continue;
                        File subDir = new File(destinationFolder, name);
                        if (!subDir.isDirectory() && !subDir.mkdirs()) {
                            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.TarExpander_unable_to_unzip_into_directory_0, (Object)destinationFolder), (Object[])new Object[0]);
                        }
                        if (ticksLeft < 10) continue;
                        MonitorUtils.worked((IProgressMonitor)monitor, (int)10);
                        ticksLeft -= 10;
                        continue;
                    }
                    Object output = null;
                    try {
                        if (destinationFolder == null) {
                            output = NullOutputStream.INSTANCE;
                        } else {
                            File subDir = new File(destinationFolder, name).getParentFile();
                            if (subDir != null && !subDir.isDirectory() && !subDir.mkdirs()) {
                                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.TarExpander_unable_to_unzip_into_directory_0, (Object)destinationFolder), (Object[])new Object[0]);
                            }
                            output = this.filter == null || this.filter.accept(new File(entry.getName())) ? new FileOutputStream(new File(destinationFolder, name)) : NullOutputStream.INSTANCE;
                        }
                        IProgressMonitor subMon = null;
                        if (ticksLeft >= 20) {
                            subMon = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10);
                            ticksLeft -= 10;
                        }
                        IOUtils.copy((InputStream)input, (OutputStream)output, (IProgressMonitor)subMon);
                    }
                    finally {
                        IOUtils.close((Closeable)output);
                    }
                }
                if (ticksLeft > 0) {
                    MonitorUtils.worked((IProgressMonitor)monitor, (int)ticksLeft);
                }
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public void setFlattenHierarchy(boolean shouldFlatten) {
        this.flatten = shouldFlatten;
    }

    private String getName(TarEntry entry) {
        String name = entry.getName();
        return this.flatten ? new File(name).getName() : name;
    }
}

