/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.buckminster.ant.Messages;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureCleanerTask {
    private final List<File> jarFiles;
    private final byte[] buffer = new byte[32768];

    public SignatureCleanerTask(List<File> jarFiles) {
        this.jarFiles = jarFiles;
    }

    public void clean() throws IOException {
        for (File jarFile : this.jarFiles) {
            File folder = jarFile.getParentFile();
            File tmpFile1 = File.createTempFile("jarclean", ".tmp", folder);
            boolean cleaned = false;
            try {
                ZipInputStream zipInput = null;
                ZipOutputStream zipOutput = null;
                try {
                    ZipEntry entry;
                    zipInput = new ZipInputStream(new BufferedInputStream(new FileInputStream(jarFile), 32768));
                    zipOutput = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(tmpFile1), 32768));
                    while ((entry = zipInput.getNextEntry()) != null) {
                        int len;
                        String name = entry.getName();
                        if (name.startsWith("META-INF/") && name.indexOf(47, 9) < 0 && (name.endsWith(".RSA") || name.endsWith(".DSA") || name.endsWith(".SF"))) {
                            cleaned = true;
                            continue;
                        }
                        zipOutput.putNextEntry(entry);
                        while ((len = zipInput.read(this.buffer)) > 0) {
                            zipOutput.write(this.buffer, 0, len);
                        }
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.close(zipInput);
                    IOUtils.close(zipOutput);
                    throw throwable;
                }
                IOUtils.close((Closeable)zipInput);
                IOUtils.close((Closeable)zipOutput);
                if (!cleaned) continue;
                File tmpFile2 = new File(String.valueOf(tmpFile1.getAbsolutePath()) + ".delete");
                if (!jarFile.renameTo(tmpFile2)) {
                    throw new IOException(NLS.bind((String)Messages.SignatureCleanerTask_Unable_to_rename_jar_0_to_tmp_1, (Object)jarFile, (Object)tmpFile2));
                }
                if (!tmpFile1.renameTo(jarFile)) {
                    tmpFile2.renameTo(jarFile);
                    throw new IOException(NLS.bind((String)Messages.SignatureCleanerTask_Unable_to_rename_tmp_1_to_jar_1, (Object)tmpFile1, (Object)jarFile));
                }
                tmpFile1 = tmpFile2;
            }
            finally {
                tmpFile1.delete();
            }
        }
    }
}

