/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.tasks;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.ant.Messages;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.helpers.BMProperties;
import org.eclipse.buckminster.core.helpers.UnmodifiableMapUnion;
import org.eclipse.buckminster.core.version.IQualifierGenerator;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionQualifierTask {
    public static final String GENERATOR_PREFIX = "generator:";
    public static final String QUALIFIER_SUFFIX = "qualifier";
    public static final String PROPERTY_CONTEXT = "context";
    public static final String PROPERTY_NONE = "none";
    private static final String QUALIFIER_REPLACEMENT_PREFIX = "qualifier.replacement.";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
    private final Map<String, ? extends Object> properties;
    private final String qualifier;

    public VersionQualifierTask(File propertiesFile, String qualifier) throws CoreException {
        this.qualifier = qualifier;
        Map globalProps = AbstractActor.getActiveContext().getProperties();
        if (propertiesFile == null) {
            this.properties = globalProps;
        } else {
            BufferedInputStream input = null;
            try {
                try {
                    input = new BufferedInputStream(new FileInputStream(propertiesFile));
                    this.properties = new UnmodifiableMapUnion((Map)new BMProperties((InputStream)input), globalProps);
                }
                catch (IOException e) {
                    throw BuckminsterException.fromMessage((Throwable)e, (String)NLS.bind((String)Messages.VersionQualifierTask_Unable_to_read_properties_from_0, (Object)propertiesFile), (Object[])new Object[0]);
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(input);
                throw throwable;
            }
            IOUtils.close((Closeable)input);
        }
    }

    public Map<String, ? extends Object> getProperties() {
        return this.properties;
    }

    public boolean isContextReplacement() {
        return this.qualifier == null || this.qualifier.equalsIgnoreCase(PROPERTY_CONTEXT);
    }

    public boolean isUsingGenerator(ComponentIdentifier ci) {
        Version version = ci.getVersion();
        if (version == null) {
            return false;
        }
        String vq = VersionHelper.getQualifier((Version)version);
        if (vq == null || !vq.endsWith(QUALIFIER_SUFFIX)) {
            return false;
        }
        String newQualifier = this.getQualifierReplacement(ci);
        return newQualifier != null && newQualifier.startsWith(GENERATOR_PREFIX);
    }

    public Version replaceQualifier(ComponentIdentifier ci, List<ComponentIdentifier> deps) {
        Version version = ci.getVersion();
        if (version == null) {
            return version;
        }
        String vq = VersionHelper.getQualifier((Version)version);
        if (vq == null) {
            return version;
        }
        if (!vq.endsWith(QUALIFIER_SUFFIX)) {
            return version;
        }
        String newQualifier = this.getQualifierReplacement(ci);
        if (newQualifier == null) {
            return VersionHelper.replaceQualifier((Version)version, null);
        }
        if (newQualifier.startsWith(GENERATOR_PREFIX)) {
            String generatorId = newQualifier.substring(GENERATOR_PREFIX.length());
            try {
                IQualifierGenerator generator = CorePlugin.getDefault().getQualifierGenerator(generatorId);
                version = generator.generateQualifier(AbstractActor.getActiveContext(), ci, deps);
            }
            catch (CoreException e) {
                CorePlugin.getLogger().error((Throwable)e, Messages.VersionQualifierTask_Unable_to_qualify_version, new Object[0]);
            }
        } else if (!vq.equals(newQualifier = vq.replaceFirst(QUALIFIER_SUFFIX, newQualifier))) {
            version = VersionHelper.replaceQualifier((Version)version, (String)newQualifier);
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getQualifierReplacement(ComponentIdentifier id) {
        String newQualifier = null;
        if (this.isContextReplacement()) {
            if (this.properties.size() != 0) {
                StringBuilder bld = new StringBuilder();
                bld.append(id.getName());
                bld.append(',');
                int lenWithId = bld.length();
                String versionStr = id.getVersion().toString();
                bld.append(versionStr, 0, versionStr.length() - QUALIFIER_SUFFIX.length() - 1);
                String idName = bld.toString();
                bld.setLength(lenWithId);
                bld.append("0.0.0");
                String idNameWithEmptyVersion = bld.toString();
                int bestMatchLength = -1;
                for (Map.Entry<String, ? extends Object> entry : this.properties.entrySet()) {
                    String key = entry.getKey();
                    if (!key.startsWith(QUALIFIER_REPLACEMENT_PREFIX)) continue;
                    int idx = QUALIFIER_REPLACEMENT_PREFIX.length();
                    int top = key.length();
                    int exprLength = top - idx;
                    if (exprLength <= bestMatchLength) continue;
                    StringBuilder matchBld = new StringBuilder();
                    matchBld.append('^');
                    while (idx < top) {
                        char c = key.charAt(idx++);
                        switch (c) {
                            case '?': {
                                matchBld.append('.');
                                break;
                            }
                            case '*': {
                                matchBld.append(".*");
                                break;
                            }
                            case '$': 
                            case '(': 
                            case ')': 
                            case '.': 
                            case '[': 
                            case ']': 
                            case '{': 
                            case '|': 
                            case '}': {
                                matchBld.append('\\');
                                matchBld.append(c);
                                break;
                            }
                            default: {
                                matchBld.append(c);
                            }
                        }
                    }
                    matchBld.append('$');
                    Pattern pattern = Pattern.compile(matchBld.toString());
                    Matcher m = pattern.matcher(idName);
                    if (!m.matches() && !(m = pattern.matcher(idNameWithEmptyVersion)).matches()) continue;
                    bestMatchLength = exprLength;
                    newQualifier = entry.getValue().toString();
                }
            }
            if (newQualifier == null) {
                SimpleDateFormat simpleDateFormat = dateFormat;
                synchronized (simpleDateFormat) {
                    newQualifier = dateFormat.format(new Date());
                }
            }
        } else if (!this.qualifier.equalsIgnoreCase(PROPERTY_NONE)) {
            newQualifier = this.qualifier;
        }
        return newQualifier;
    }
}

