/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.tasks;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.util.FileUtils;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.materializer.IMaterializer;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.metadata.model.Materialization;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.model.ResolvedNode;
import org.eclipse.buckminster.core.mspec.builder.MaterializationSpecBuilder;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.core.query.builder.ComponentQueryBuilder;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.resolver.LocalResolver;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class WorkspaceBindTask {
    private final File projectDir;

    public WorkspaceBindTask(File projectDir) {
        this.projectDir = projectDir;
    }

    public void execute() throws CoreException {
        BufferedInputStream input = null;
        IProjectDescription projDesc = null;
        try {
            try {
                input = new BufferedInputStream(new FileInputStream(new File(this.projectDir, ".project")));
                projDesc = ResourcesPlugin.getWorkspace().loadProjectDescription((InputStream)input);
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(input);
            throw throwable;
        }
        FileUtils.close((InputStream)input);
        ComponentQueryBuilder qbld = new ComponentQueryBuilder();
        qbld.setRootRequest((IComponentRequest)new ComponentRequest(projDesc.getName(), null, null));
        qbld.setPlatformAgnostic(true);
        ComponentQuery query = qbld.createComponentQuery();
        ResolutionContext context = new ResolutionContext(query);
        NodeQuery topQuery = context.getRootNodeQuery();
        IPath projectPath = Path.fromOSString((String)this.projectDir.toString()).addTrailingSeparator();
        Resolution resolution = LocalResolver.fromPath((NodeQuery)topQuery, (IPath)projectPath, null);
        Materialization mat = new Materialization(projectPath, resolution.getComponentIdentifier());
        StorageManager sm = StorageManager.getDefault();
        resolution.store(sm);
        mat.store(sm);
        BillOfMaterials bom = BillOfMaterials.create((BOMNode)new ResolvedNode(topQuery, resolution), (ComponentQuery)query);
        MaterializationSpecBuilder mspecBuilder = new MaterializationSpecBuilder();
        mspecBuilder.setName(bom.getViewName());
        mspecBuilder.setMaterializerID("workspace");
        MaterializationSpec mspec = mspecBuilder.createMaterializationSpec();
        IMaterializer wsMat = CorePlugin.getDefault().getMaterializer("workspace");
        MaterializationContext matCtx = new MaterializationContext(bom, mspec, (RMContext)context);
        wsMat.performInstallAction(mat.getResolution(), matCtx, (IProgressMonitor)new NullProgressMonitor());
        IStatus status = matCtx.getStatus();
        if (status.getSeverity() == 4) {
            throw new CoreException(status);
        }
    }
}

