/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.jdt.ant;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.buckminster.jdt.internal.SaxableClasspath;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectClasspath
extends Task {
    private IPath projectDir;
    private ArrayList<Entry> entries;
    private ArrayList<FileSet> librarySets;

    static IPath fileToPath(File file) throws BuildException {
        try {
            return file == null ? null : Path.fromOSString((String)file.getCanonicalPath().toString());
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void addLibrarySet(FileSet fileSet) {
        if (this.librarySets == null) {
            this.librarySets = new ArrayList();
        }
        this.librarySets.add(fileSet);
    }

    public ContainerEntry createContainerEntry() {
        ContainerEntry entry = new ContainerEntry();
        this.getEntries().add(entry);
        return entry;
    }

    public LibraryEntry createLibraryEntry() {
        LibraryEntry entry = new LibraryEntry();
        this.getEntries().add(entry);
        return entry;
    }

    public ProjectEntry createProjectEntry() {
        ProjectEntry entry = new ProjectEntry();
        this.getEntries().add(entry);
        return entry;
    }

    public VariableEntry createVariableEntry() {
        VariableEntry entry = new VariableEntry();
        this.getEntries().add(entry);
        return entry;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (this.projectDir == null) {
            throw this.missingRequiredAttribute("projectDir");
        }
        if (this.librarySets != null) {
            for (FileSet fileSet : this.librarySets) {
                DirectoryScanner ds = fileSet.getDirectoryScanner(this.getProject());
                IPath base = ProjectClasspath.fileToPath(ds.getBasedir());
                for (String fileName : ds.getIncludedFiles()) {
                    LibraryEntry le = this.createLibraryEntry();
                    le.setPath(base.append(fileName));
                    le.setExported(true);
                }
            }
            this.librarySets = null;
        }
        BufferedOutputStream output = null;
        try {
            IClasspathEntry[] classPaths;
            output = new BufferedOutputStream(new FileOutputStream(this.projectDir.append(".classpath").toFile()));
            if (this.entries == null) {
                classPaths = new IClasspathEntry[]{};
            } else {
                int top = this.entries.size();
                classPaths = new IClasspathEntry[top];
                for (int idx = 0; idx < top; ++idx) {
                    classPaths[idx] = this.entries.get(idx).createEntry();
                }
            }
            Utils.serialize((ISaxable)new SaxableClasspath(this.projectDir, classPaths), (OutputStream)output);
        }
        catch (SAXException e) {
            try {
                throw new BuildException((Throwable)e, this.getLocation());
                catch (IOException e2) {
                    throw new BuildException((Throwable)e2, this.getLocation());
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(output);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)output);
    }

    public void setProjectDir(File projectDir) {
        this.projectDir = ProjectClasspath.fileToPath(projectDir);
    }

    BuildException missingRequiredAttribute(String attributeName) {
        return new BuildException("Missing required attribute " + attributeName, this.getLocation());
    }

    private ArrayList<Entry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        return this.entries;
    }

    public class ContainerEntry
    extends Entry {
        public IClasspathEntry createEntry() throws BuildException {
            return JavaCore.newContainerEntry((IPath)this.getRequiredPath(), (boolean)this.isExported());
        }
    }

    public abstract class Entry {
        private boolean exported;
        private IPath path;

        public abstract IClasspathEntry createEntry() throws BuildException;

        public IPath getPath() {
            return this.path;
        }

        public boolean isExported() {
            return this.exported;
        }

        public void setExported(boolean exported) {
            this.exported = exported;
        }

        public void setPath(IPath path) {
            this.path = path;
        }

        public void setPath(String path) {
            this.path = new Path(path);
        }

        protected IPath getRequiredPath() {
            if (this.path == null) {
                throw ProjectClasspath.this.missingRequiredAttribute("path");
            }
            return this.path;
        }
    }

    public class LibraryEntry
    extends Entry {
        private IPath sourceAttachmentPath;
        private IPath sourceAttachmentRootPath;

        public IClasspathEntry createEntry() throws BuildException {
            return JavaCore.newLibraryEntry((IPath)this.getRequiredPath(), (IPath)this.sourceAttachmentPath, (IPath)this.sourceAttachmentRootPath, (boolean)this.isExported());
        }

        public IPath getSourceAttachmentPath() {
            return this.sourceAttachmentPath;
        }

        public IPath getSourceAttachmentRootPath() {
            return this.sourceAttachmentRootPath;
        }

        public void setSourceAttachmentPath(File sourceAttachmentPath) {
            this.sourceAttachmentPath = ProjectClasspath.fileToPath(sourceAttachmentPath);
        }

        public void setSourceAttachmentRootPath(File sourceAttachmentRootPath) {
            this.sourceAttachmentRootPath = ProjectClasspath.fileToPath(sourceAttachmentRootPath);
        }
    }

    public class ProjectEntry
    extends Entry {
        public IClasspathEntry createEntry() throws BuildException {
            return JavaCore.newProjectEntry((IPath)this.getRequiredPath(), (boolean)this.isExported());
        }
    }

    public class VariableEntry
    extends LibraryEntry {
        public IClasspathEntry createEntry() throws BuildException {
            return JavaCore.newVariableEntry((IPath)this.getRequiredPath(), (IPath)this.getSourceAttachmentPath(), (IPath)this.getSourceAttachmentRootPath(), (boolean)this.isExported());
        }
    }
}

