/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.maven.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.AbstractResolutionBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.ctype.AbstractComponentType;
import org.eclipse.buckminster.core.ctype.MissingCSpecSourceException;
import org.eclipse.buckminster.core.helpers.AccessibleByteArrayOutputStream;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.ResolvedNode;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IFileReader;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.core.reader.LocalReader;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.maven.Messages;
import org.eclipse.buckminster.maven.internal.MavenComponentType;
import org.eclipse.buckminster.maven.internal.MavenReader;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.metadata.Version;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MavenCSpecBuilder
extends AbstractResolutionBuilder
implements IStreamConsumer<Document> {
    MavenCSpecBuilder() {
    }

    public BOMNode build(IComponentReader[] readerHandle, boolean forResolutionAidOnly, IProgressMonitor monitor) throws CoreException {
        IComponentReader reader = readerHandle[0];
        ProviderMatch ri = reader.getProviderMatch();
        monitor.beginTask(null, 3000);
        monitor.subTask(Messages.generating_cspec_from_maven_artifact);
        try {
            Document pomDoc = null;
            IProgressMonitor subMon = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)2000);
            if (reader instanceof MavenReader) {
                pomDoc = ((MavenReader)reader).getPOMDocument(subMon);
            } else if (reader instanceof LocalReader) {
                File jarFile = new File(URI.create(ri.getRepositoryURI()));
                if (jarFile.isFile()) {
                    File jarFolder = jarFile.getParentFile();
                    Version v = VersionHelper.createVersion((String)"Triplet", (String)jarFolder.getName());
                    ri.setVersionMatch(new VersionMatch(v, null, null, null, null));
                    String jarName = jarFile.getName();
                    int lastDot = jarName.lastIndexOf(46);
                    if (lastDot > 0) {
                        String pomName = String.valueOf(jarName.substring(0, lastDot)) + ".pom";
                        try {
                            pomDoc = MavenReader.getPOMDocument(new File(jarFolder, pomName));
                        }
                        catch (Exception exception) {}
                    }
                }
            } else {
                try {
                    if (reader instanceof ICatalogReader) {
                        try {
                            pomDoc = (Document)((ICatalogReader)reader).readFile("pom.xml", (IStreamConsumer)this, subMon);
                        }
                        catch (FileNotFoundException e) {
                            pomDoc = (Document)((ICatalogReader)reader).readFile("project.xml", (IStreamConsumer)this, subMon);
                        }
                    } else {
                        pomDoc = (Document)((IFileReader)reader).readFile((IStreamConsumer)this, subMon);
                    }
                }
                catch (FileNotFoundException e2) {
                    throw new MissingCSpecSourceException(reader.getProviderMatch());
                }
            }
            CSpecBuilder cspecBld = ri.createCSpec();
            cspecBld.setComponentTypeID("maven");
            GroupBuilder archives = AbstractComponentType.addSelfAsJarArtifactGroups((CSpecBuilder)cspecBld);
            if (pomDoc != null) {
                ExpandingProperties properties = new ExpandingProperties();
                String packaging = MavenComponentType.addDependencies(reader, pomDoc, cspecBld, archives, (ExpandingProperties<String>)properties);
                if (reader instanceof MavenReader && !"jar".equals(packaging)) {
                    ((MavenReader)reader).setPackaging(packaging);
                }
            }
            this.applyExtensions(cspecBld, forResolutionAidOnly, reader, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
            ResolvedNode resolvedNode = this.createNode(reader, cspecBld);
            return resolvedNode;
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        finally {
            monitor.done();
        }
    }

    public Document consumeStream(IComponentReader reader, String streamName, InputStream stream, IProgressMonitor monitor) throws CoreException, IOException {
        monitor.beginTask(streamName, 1);
        try {
            AccessibleByteArrayOutputStream buffer = new AccessibleByteArrayOutputStream(8192, 0x100000);
            FileUtils.copyFile((InputStream)stream, (OutputStream)buffer, (byte[])new byte[4096], (IProgressMonitor)monitor);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBld = factory.newDocumentBuilder();
            try {
                Document document = docBld.parse(buffer.getInputStream());
                return document;
            }
            catch (SAXParseException e) {
                Document document;
                try {
                    String msg = e.getMessage();
                    if (msg == null || !msg.contains("UTF-8")) {
                        throw e;
                    }
                    InputSource input = new InputSource(buffer.getInputStream());
                    input.setEncoding("ISO-8859-1");
                    docBld.reset();
                    document = docBld.parse(input);
                }
                catch (SAXException e2) {
                    throw BuckminsterException.wrap((Throwable)e2);
                }
                catch (ParserConfigurationException e3) {
                    throw BuckminsterException.wrap((Throwable)e3);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
                monitor.done();
                return document;
            }
        }
        finally {
            MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
            monitor.done();
        }
    }
}

