/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.iproduct.IJREInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.util.VMUtil;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.ComboViewerPart;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class JRESection
extends PDESection {
    private Button fEEButton;
    private Button fExecutionEnvironmentsButton;
    private ComboViewerPart fEEsCombo;
    private boolean fBlockChanges;
    private static final String[] TAB_LABELS = new String[]{"linux", "macosx", "solaris", "win32"};
    private static final String[] TAB_OS = new String[]{"linux", "macosx", "solaris", "win32"};
    private CTabFolder fTabFolder;
    private int fLastTab;

    public JRESection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        section.setLayoutData((Object)data);
        section.setText(PDEUIMessages.ProductJRESection_title);
        section.setDescription(PDEUIMessages.ProductJRESection_desc);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 3));
        client.setLayoutData((Object)new GridData(768));
        this.fTabFolder = new CTabFolder(client, 0x800080);
        toolkit.adapt((Control)this.fTabFolder, true, true);
        GridData gd = new GridData(256);
        this.fTabFolder.setLayoutData((Object)gd);
        gd.heightHint = 2;
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        toolkit.getColors().initializeSectionToolBarColors();
        Color selectedColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        this.fTabFolder.setSelectionBackground(new Color[]{selectedColor, toolkit.getColors().getBackground()}, new int[]{100}, true);
        this.fTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRESection.this.refresh();
            }
        });
        this.fTabFolder.setUnselectedImageVisible(false);
        FormText text = toolkit.createFormText(client, false);
        text.setLayoutData((Object)new GridData(32));
        text.setText(PDEUIMessages.ProductJRESection_eeName, false, false);
        this.fEEsCombo = new ComboViewerPart();
        this.fEEsCombo.createControl(client, toolkit, 2060);
        this.fEEsCombo.getControl().setLayoutData((Object)new GridData(768));
        this.fEEsCombo.setLabelProvider((IBaseLabelProvider)new EELabelProvider());
        this.fEEsCombo.setComparator(new ViewerComparator());
        this.fEEsCombo.setItems(VMUtil.getExecutionEnvironments());
        this.fEEsCombo.addItem("", 0);
        this.fEEsCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!JRESection.this.fBlockChanges) {
                    Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    JRESection.this.setEE(selection instanceof IExecutionEnvironment ? (IExecutionEnvironment)selection : null);
                    JRESection.this.fEEButton.setEnabled(selection instanceof IExecutionEnvironment);
                }
            }
        });
        this.fEEsCombo.setEnabled(this.isEditable());
        this.fExecutionEnvironmentsButton = toolkit.createButton(client, PDEUIMessages.ProductJRESection_browseEEs, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.fExecutionEnvironmentsButton);
        this.fExecutionEnvironmentsButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PreferencesUtil.createPreferenceDialogOn((Shell)JRESection.this.getSection().getShell(), (String)"org.eclipse.jdt.debug.ui.jreProfiles", (String[])new String[]{"org.eclipse.jdt.debug.ui.jreProfiles"}, null).open();
            }
        });
        this.fExecutionEnvironmentsButton.setEnabled(this.isEditable());
        this.fEEButton = toolkit.createButton(client, PDEUIMessages.ProdctJRESection_bundleJRE, 32);
        GridData buttonLayout = new GridData(768);
        buttonLayout.horizontalSpan = 2;
        this.fEEButton.setLayoutData((Object)buttonLayout);
        this.fEEButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRESection.this.getJVMLocations().setIncludeJREWithProduct(JRESection.this.getOS(JRESection.this.fLastTab), JRESection.this.fEEButton.getSelection());
            }
        });
        this.fEEButton.setEnabled(this.isEditable());
        this.createTabs();
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        this.getProductModel().addModelChangedListener((IModelChangedListener)this);
    }

    private void setEE(IExecutionEnvironment ee) {
        IPath eePath = null;
        if (ee != null) {
            eePath = JavaRuntime.newJREContainerPath((IExecutionEnvironment)ee);
        }
        this.getJVMLocations().setJREContainerPath(this.getOS(this.fLastTab), eePath);
    }

    private IProductModel getProductModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    public void dispose() {
        IProductModel model = this.getProductModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    private void createTabs() {
        int i = 0;
        while (i < TAB_LABELS.length) {
            CTabItem item = new CTabItem(this.fTabFolder, 0);
            item.setText(TAB_LABELS[i]);
            item.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_OPERATING_SYSTEM_OBJ));
            ++i;
        }
        this.fLastTab = 0;
        this.fTabFolder.setSelection(this.fLastTab);
        String currentTarget = TargetPlatform.getOS();
        if ("win32".equals(currentTarget)) {
            this.fTabFolder.setSelection(3);
        } else if ("macosx".equals(currentTarget)) {
            this.fTabFolder.setSelection(1);
        } else if ("solaris".equals(currentTarget)) {
            this.fTabFolder.setSelection(2);
        }
    }

    public void refresh() {
        this.fBlockChanges = true;
        this.fLastTab = this.fTabFolder.getSelectionIndex();
        this.fEEButton.setSelection(this.getJVMLocations().includeJREWithProduct(this.getOS(this.fLastTab)));
        IPath jrePath = this.getJVMLocations().getJREContainerPath(this.getOS(this.fLastTab));
        if (jrePath != null) {
            String eeID = JavaRuntime.getExecutionEnvironmentId((IPath)jrePath);
            IExecutionEnvironment env = VMUtil.getExecutionEnvironment((String)eeID);
            if (env != null) {
                if (!this.fEEsCombo.getItems().contains(env)) {
                    this.fEEsCombo.addItem(env);
                }
                this.fEEsCombo.select(env);
            } else {
                IVMInstall install = JavaRuntime.getVMInstall((IPath)jrePath);
                if (install != null) {
                    this.fEEsCombo.select(null);
                }
            }
        } else {
            this.fEEsCombo.select(null);
        }
        this.updateWidgets();
        super.refresh();
        this.fBlockChanges = false;
    }

    private IJREInfo getJVMLocations() {
        IJREInfo info = this.getProduct().getJREInfo();
        if (info == null) {
            info = this.getModel().getFactory().createJVMInfo();
            this.getProduct().setJREInfo(info);
        }
        return info;
    }

    private String getOS(int tab) {
        if (tab >= 0 && tab < TAB_OS.length) {
            return TAB_OS[tab];
        }
        return null;
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        return d.getFocusControl() instanceof Text;
    }

    protected void updateWidgets() {
        this.fEEButton.setEnabled(this.isEditable() && this.fEEsCombo.getSelection() instanceof IExecutionEnvironment);
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.refresh();
        this.getPage().setLastFocusControl(this.fEEsCombo.getControl());
    }

    private final class EELabelProvider
    extends LabelProvider {
        private EELabelProvider() {
        }

        public String getText(Object element) {
            if (!(element instanceof IExecutionEnvironment)) {
                return "";
            }
            IExecutionEnvironment env = (IExecutionEnvironment)element;
            IPath path = JavaRuntime.newJREContainerPath((IExecutionEnvironment)env);
            IVMInstall install = JavaRuntime.getVMInstall((IPath)path);
            String eeItem = install != null ? MessageFormat.format((String)PDEUIMessages.JRESection_eeBoundJRE, (Object[])new Object[]{env.getId(), install.getName()}) : MessageFormat.format((String)PDEUIMessages.JRESection_eeUnboundJRE, (Object[])new Object[]{env.getId()});
            return eeItem;
        }
    }
}

