/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.nls;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.nls.GetNonExternalizedStringsAction;
import org.eclipse.pde.internal.ui.nls.InternationalizeModelTable;
import org.eclipse.pde.internal.ui.nls.InternationalizeWizardLocalePage;
import org.eclipse.pde.internal.ui.nls.InternationalizeWizardPluginPage;
import org.eclipse.pde.internal.ui.nls.NLSFragmentGenerator;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternationalizeWizard
extends Wizard
implements IImportWizard {
    private static final String STORE_SECTION = "InternationalizeWizard";
    private InternationalizeWizardPluginPage page1;
    private InternationalizeWizardLocalePage page2;
    private InternationalizeModelTable fInternationalizePluginModelTable;
    private InternationalizeModelTable fInternationalizeLocaleModelTable;

    public InternationalizeWizard(InternationalizeModelTable pluginTable) {
        this.fInternationalizePluginModelTable = pluginTable;
        this.populateLocaleModelTable();
        IDialogSettings masterSettings = PDEPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_XHTML_CONVERT_WIZ);
        this.setWindowTitle(PDEUIMessages.InternationalizeWizard_title);
    }

    private void populateLocaleModelTable() {
        this.fInternationalizeLocaleModelTable = new InternationalizeModelTable();
        Locale[] availableLocales = Locale.getAvailableLocales();
        int i = 0;
        while (i < availableLocales.length) {
            this.fInternationalizeLocaleModelTable.addModel(availableLocales[i]);
            ++i;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.setNeedsProgressMonitor(true);
        this.page1 = new InternationalizeWizardPluginPage(this.fInternationalizePluginModelTable, "Plug-ins");
        this.addPage((IWizardPage)this.page1);
        this.page2 = new InternationalizeWizardLocalePage(this.fInternationalizeLocaleModelTable, "Locales");
        this.addPage((IWizardPage)this.page2);
    }

    private IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    private List<?> getPluginModelsForInternationalization() {
        return this.page1.getModelsToInternationalize();
    }

    private List<?> getLocalesForInternationalization() {
        return this.page2.getLocalesForInternationalization();
    }

    public boolean performFinish() {
        this.page1.storeSettings();
        this.page2.storeSettings();
        String template = String.valueOf(this.page1.getTemplate()) + (this.page1.createIndividualFragments() ? ".${locale}" : "");
        NLSFragmentGenerator fragmentGenerator = new NLSFragmentGenerator(template, this.getPluginModelsForInternationalization(), this.getLocalesForInternationalization(), this.getContainer(), this.page1.overwriteWithoutAsking());
        return fragmentGenerator.generate();
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        if (currentPage.equals((Object)this.page1)) {
            this.ensurePluginsAreExternalized();
            return this.page2;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage currentPage) {
        if (currentPage.equals((Object)this.page2)) {
            return this.page1;
        }
        return null;
    }

    public boolean canFinish() {
        return this.getPluginModelsForInternationalization().size() > 0 && this.getLocalesForInternationalization().size() > 0;
    }

    public void ensurePluginsAreExternalized() {
        GetNonExternalizedStringsAction externalize = new GetNonExternalizedStringsAction();
        ArrayList<IProject> projects = new ArrayList<IProject>();
        List<?> pluginModels = this.getPluginModelsForInternationalization();
        for (IPluginModelBase pluginModel : pluginModels) {
            if (pluginModel instanceof ExternalPluginModel) continue;
            IProject project = pluginModel.getUnderlyingResource().getProject();
            projects.add(project);
        }
        StructuredSelection externalizeSelection = new StructuredSelection(projects);
        externalize.setExternalizeSelectedPluginsOnly(true);
        externalize.setSkipMessageDialog(true);
        externalize.runGetNonExternalizedStringsAction((ISelection)externalizeSelection);
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    public void setContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
        if (this.getContainer() instanceof TrayDialog) {
            ((TrayDialog)this.getContainer()).setHelpAvailable(false);
        }
    }
}

