/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.search.dependencies.AddNewDependenciesOperation;
import org.eclipse.pde.internal.ui.search.dependencies.PackageFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddNewBinaryDependenciesOperation
extends AddNewDependenciesOperation {
    protected IClassFile[] fClassFiles;

    public AddNewBinaryDependenciesOperation(IProject project, IBundlePluginModelBase base) {
        this(project, base, PackageFinder.getClassFiles(project, base));
    }

    public AddNewBinaryDependenciesOperation(IProject project, IBundlePluginModelBase base, IClassFile[] classFiles) {
        super(project, base);
        this.fClassFiles = classFiles;
    }

    @Override
    protected void findSecondaryDependencies(String[] secDeps, Set<String> ignorePkgs, Map<ExportPackageDescription, String> additionalDeps, IBundle bundle, boolean useRequireBundle, IProgressMonitor monitor) {
        monitor.beginTask(PDEUIMessages.AddNewDependenciesOperation_searchProject, 100);
        Set<String> projectPkgs = PackageFinder.findPackagesInClassFiles(this.fClassFiles, (IProgressMonitor)new SubProgressMonitor(monitor, 75));
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        SubProgressMonitor searchMonitor = new SubProgressMonitor(monitor, 25);
        searchMonitor.beginTask("", secDeps.length);
        int i = 0;
        while (i < secDeps.length) {
            IPluginModelBase base = manager.findModel(secDeps[i]);
            if (base != null) {
                ExportPackageDescription[] pkgs = this.findExportedPackages(base.getBundleDescription());
                int j = 0;
                while (j < pkgs.length) {
                    String pkgName = pkgs[j].getName();
                    if (!ignorePkgs.contains(pkgName) && projectPkgs.contains(pkgName)) {
                        additionalDeps.put(pkgs[j], secDeps[i]);
                        ignorePkgs.add(pkgName);
                        if (useRequireBundle) {
                            while (j < pkgs.length) {
                                ignorePkgs.add(pkgs[j].getName());
                                ++j;
                            }
                        }
                    }
                    ++j;
                }
            }
            searchMonitor.worked(1);
            ++i;
        }
    }
}

