/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.search.dependencies.CalculateUsesOperation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IProgressConstants;

public class CalculateUsesAction
extends Action {
    private IProject fProject;
    private IBundlePluginModelBase fModel;

    public CalculateUsesAction(IProject project, IBundlePluginModelBase model) {
        this.fProject = project;
        this.fModel = model;
    }

    public void run() {
        Job job = this.createJob();
        job.setUser(true);
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)PDEPluginImages.DESC_PSEARCH_OBJ.createImage());
        job.schedule();
    }

    protected Job createJob() {
        return new WorkspaceJob(PDEUIMessages.CalculateUsesAction_jobName){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                block7: {
                    CalculateUsesOperation op = CalculateUsesAction.this.getOperation();
                    try {
                        op.run(monitor);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        monitor.done();
                        break block7;
                    }
                    catch (InterruptedException interruptedException) {
                        try {
                            break block7;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            monitor.done();
                        }
                    }
                    monitor.done();
                }
                return new Status(0, PDEPlugin.getPluginId(), 0, "", null);
            }
        };
    }

    protected CalculateUsesOperation getOperation() {
        return new CalculateUsesOperation(this.fProject, this.fModel){

            @Override
            protected void handleSetUsesDirectives(final Map<String, HashSet<String>> pkgsAndUses) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (pkgsAndUses.isEmpty()) {
                            return;
                        }
                        this.setUsesDirectives(pkgsAndUses);
                    }
                });
            }
        };
    }
}

