/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.imagebrowser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.views.imagebrowser.ImageElement;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.services.ISourceProviderService;

public class SaveToWorkspace
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Map currentState;
        Object data;
        ISourceProviderService service = (ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class);
        ISourceProvider provider = service.getSourceProvider("org.eclipse.pde.ui.imagebrowser.activeImage");
        if (provider != null && (data = (currentState = provider.getCurrentState()).get("org.eclipse.pde.ui.imagebrowser.activeImage")) instanceof ImageElement) {
            SaveAsDialog dialog = new SaveAsDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
            dialog.setTitle(PDEUIMessages.SaveToWorkspace_SaveImageToWorkspace);
            dialog.setOriginalName(((ImageElement)data).getFileName());
            if (dialog.open() == 0) {
                boolean confirm;
                IPath result = dialog.getResult();
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(result);
                boolean exists = file.exists();
                if (exists && !(confirm = MessageDialog.openConfirm((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)PDEUIMessages.SaveToWorkspace_ConfirmOverwrite, (String)NLS.bind((String)PDEUIMessages.SaveToWorkspace_ConfirmOverwriteText, (Object)result)))) {
                    return null;
                }
                int imageType = this.getImageType(result);
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ImageLoader imageLoader = new ImageLoader();
                    imageLoader.data = new ImageData[]{((ImageElement)data).getImageData()};
                    imageLoader.save((OutputStream)out, imageType);
                    ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                    if (exists) {
                        file.setContents((InputStream)in, true, false, null);
                    } else {
                        file.create((InputStream)in, true, null);
                    }
                    file.getParent().refreshLocal(0, null);
                }
                catch (CoreException e) {
                    PDEPlugin.log(e);
                }
            }
        }
        return null;
    }

    private int getImageType(IPath path) {
        String extension = path.getFileExtension();
        if ("gif".equalsIgnoreCase(extension)) {
            return 2;
        }
        if ("bmp".equalsIgnoreCase(extension)) {
            return 0;
        }
        if ("png".equalsIgnoreCase(extension)) {
            return 5;
        }
        if ("ico".equalsIgnoreCase(extension)) {
            return 3;
        }
        return 5;
    }
}

