/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.imagebrowser.repositories;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.views.imagebrowser.IImageTarget;
import org.eclipse.pde.internal.ui.views.imagebrowser.repositories.AbstractRepository;
import org.eclipse.ui.PlatformUI;

public class TargetPlatformRepository
extends AbstractRepository {
    private List<TargetBundle> fBundles = null;
    private boolean fUseCurrent;

    public TargetPlatformRepository(IImageTarget target, boolean useCurrent) {
        super(target);
        this.fUseCurrent = useCurrent;
    }

    protected boolean populateCache(IProgressMonitor monitor) {
        if (this.fBundles == null) {
            this.initialize(monitor);
        }
        if (this.fBundles != null && !this.fBundles.isEmpty()) {
            TargetBundle bundle = this.fBundles.remove(this.fBundles.size() - 1);
            URI location = bundle.getBundleInfo().getLocation();
            File file = new File(location);
            if (this.isJar(file)) {
                this.searchJarFile(file, monitor);
            } else if (file.isDirectory()) {
                this.searchDirectory(file, monitor);
            }
            return true;
        }
        return false;
    }

    private void initialize(IProgressMonitor monitor) {
        try {
            ITargetPlatformService service = (ITargetPlatformService)PlatformUI.getWorkbench().getService(ITargetPlatformService.class);
            if (service != null) {
                ITargetDefinition fDefinition = null;
                if (this.fUseCurrent) {
                    ITargetHandle workspaceTargetHandle = service.getWorkspaceTargetHandle();
                    if (workspaceTargetHandle != null) {
                        fDefinition = workspaceTargetHandle.getTargetDefinition();
                    }
                } else {
                    fDefinition = service.newDefaultTarget();
                }
                if (fDefinition != null) {
                    TargetBundle[] allBundles;
                    if (!fDefinition.isResolved()) {
                        fDefinition.resolve(monitor);
                    }
                    this.fBundles = (allBundles = fDefinition.getAllBundles()) != null ? new ArrayList<TargetBundle>(Arrays.asList(allBundles)) : Collections.emptyList();
                }
            } else {
                PDEPlugin.log(PDEUIMessages.TargetPlatformRepository_CouldNotFindTargetPlatformService);
            }
        }
        catch (CoreException e) {
            PDEPlugin.log(e);
        }
    }

    public String toString() {
        if (!this.fUseCurrent) {
            return PDEUIMessages.TargetPlatformRepository_RunningPlatform;
        }
        try {
            ITargetHandle workspaceTargetHandle;
            ITargetPlatformService service = (ITargetPlatformService)PlatformUI.getWorkbench().getService(ITargetPlatformService.class);
            if (service != null && (workspaceTargetHandle = service.getWorkspaceTargetHandle()) != null) {
                ITargetDefinition definition = workspaceTargetHandle.getTargetDefinition();
                String name = definition.getName();
                if (name.length() > 30) {
                    name = name.substring(0, 30);
                }
                return NLS.bind((String)PDEUIMessages.TargetPlatformRepository_TargetPlatformLabel, (Object)name);
            }
        }
        catch (CoreException e) {
            PDEPlugin.log(e);
        }
        return super.toString();
    }
}

