/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.shared.CachedCheckboxTreeViewer;
import org.eclipse.pde.internal.ui.shared.FilteredCheckboxTree;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverwriteProjectsSelectionDialog
extends SelectionStatusDialog {
    private static final String ID = "id";
    private ArrayList<?> fPluginProjectList;
    private FilteredCheckboxTree fFilteredTree;
    private CachedCheckboxTreeViewer fCheckboxTreeViewer;

    public OverwriteProjectsSelectionDialog(Shell parent, ArrayList<?> plugins) {
        super(parent);
        this.setTitle(PDEUIMessages.PluginImportOperation_OverwritePluginProjects);
        Assert.isNotNull(plugins);
        this.fPluginProjectList = plugins;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.pde.doc.user.plugin_import_overwrite_dialog");
    }

    protected void computeResult() {
        List<Object> result = Arrays.asList(this.fCheckboxTreeViewer.getCheckedLeafElements());
        this.setResult(result);
    }

    protected Control createDialogArea(Composite parent) {
        Composite tableComposite = SWTFactory.createComposite(parent, 1, 1, 1808, 15, 15);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 400;
        gd.widthHint = 500;
        tableComposite.setLayoutData((Object)gd);
        if (this.fPluginProjectList != null && this.fPluginProjectList.size() == 1) {
            this.setMessage(PDEUIMessages.DuplicatePluginResolutionDialog_messageSingular);
        } else {
            this.setMessage(PDEUIMessages.DuplicatePluginResolutionDialog_message);
        }
        SWTFactory.createWrapLabel(tableComposite, this.getMessage(), 1, 400);
        SWTFactory.createVerticalSpacer(tableComposite, 1);
        SWTFactory.createLabel(tableComposite, PDEUIMessages.OverwriteProjectsSelectionDialog_0, 1);
        this.createTableArea(tableComposite);
        Composite buttonComposite = SWTFactory.createComposite(tableComposite, 2, 1, 896, 0, 5);
        Button buttonSelectAll = SWTFactory.createPushButton(buttonComposite, PDEUIMessages.DuplicatePluginResolutionDialog_selectAll, null);
        Button buttonDeselectAll = SWTFactory.createPushButton(buttonComposite, PDEUIMessages.DuplicatePluginResolutionDialog_deselectAll, null);
        buttonSelectAll.addSelectionListener((SelectionListener)new ButtonSelectionListener());
        buttonSelectAll.setData(ID, (Object)PDEUIMessages.DuplicatePluginResolutionDialog_selectAll);
        buttonDeselectAll.addSelectionListener((SelectionListener)new ButtonSelectionListener());
        buttonDeselectAll.setData(ID, (Object)PDEUIMessages.DuplicatePluginResolutionDialog_deselectAll);
        return tableComposite;
    }

    private void createTableArea(Composite parent) {
        this.fFilteredTree = new FilteredCheckboxTree(parent, null);
        this.fFilteredTree.getPatternFilter().setIncludeLeadingWildcard(true);
        this.fCheckboxTreeViewer = this.fFilteredTree.getCheckboxTreeViewer();
        this.fCheckboxTreeViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.fCheckboxTreeViewer.setLabelProvider((IBaseLabelProvider)new StyledPluginLabelProvider());
        this.fCheckboxTreeViewer.setUseHashlookup(true);
        this.fCheckboxTreeViewer.setInput(this.fPluginProjectList.toArray(new IPluginModelBase[this.fPluginProjectList.size()]));
        int i = 0;
        while (i < this.fPluginProjectList.size()) {
            this.fCheckboxTreeViewer.setChecked(this.fPluginProjectList.get(i), true);
            ++i;
        }
    }

    private class ButtonSelectionListener
    extends SelectionAdapter {
        private ButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            String buttonID = (String)e.widget.getData(OverwriteProjectsSelectionDialog.ID);
            if (PDEUIMessages.DuplicatePluginResolutionDialog_selectAll.equals(buttonID)) {
                OverwriteProjectsSelectionDialog.this.fCheckboxTreeViewer.setAllChecked(true);
            } else if (PDEUIMessages.DuplicatePluginResolutionDialog_deselectAll.equals(buttonID)) {
                OverwriteProjectsSelectionDialog.this.fCheckboxTreeViewer.setAllChecked(false);
            }
        }
    }

    private class PluginContentProvider
    implements ITreeContentProvider {
        private PluginContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return (IPluginModelBase[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class StyledPluginLabelProvider
    extends StyledCellLabelProvider
    implements ILabelProvider {
        private StyledPluginLabelProvider() {
        }

        public Image getImage(Object element) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }

        public String getText(Object element) {
            return this.getStyledText(element).getString();
        }

        public void update(ViewerCell cell) {
            StyledString string = this.getStyledText(cell.getElement());
            cell.setText(string.getString());
            cell.setStyleRanges(string.getStyleRanges());
            cell.setImage(this.getImage(cell.getElement()));
            super.update(cell);
        }

        private StyledString getStyledText(Object element) {
            StyledString styledString = new StyledString();
            IPluginModelBase plugin = (IPluginModelBase)element;
            String symbolicName = plugin.getBundleDescription().getSymbolicName();
            Version version = plugin.getBundleDescription().getVersion();
            String versionString = String.valueOf(String.valueOf(version.getMajor())) + '.' + String.valueOf(version.getMinor()) + '.' + String.valueOf(version.getMicro());
            String projectName = plugin.getUnderlyingResource().getProject().getName();
            styledString.append(projectName);
            styledString.append(' ');
            styledString.append('(', StyledString.DECORATIONS_STYLER);
            styledString.append(symbolicName, StyledString.DECORATIONS_STYLER);
            styledString.append(' ');
            styledString.append(versionString, StyledString.DECORATIONS_STYLER);
            styledString.append(')', StyledString.DECORATIONS_STYLER);
            return styledString;
        }
    }
}

