/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.util.VMUtil;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LauncherUtils;
import org.eclipse.pde.launching.EquinoxLaunchConfiguration;

public class VMHelper {
    public static String getDefaultEEName(ILaunchConfiguration configuration) throws CoreException {
        LinkedList<IExecutionEnvironment> validEEs = new LinkedList<IExecutionEnvironment>();
        validEEs.addAll(Arrays.asList(JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments()));
        boolean isOSGiLaunch = configuration instanceof EquinoxLaunchConfiguration;
        IPluginModelBase[] plugins = BundleLauncherHelper.getMergedBundles(configuration, isOSGiLaunch);
        int i = 0;
        while (i < plugins.length) {
            String[] bundleEnvs;
            BundleDescription desc;
            if (validEEs.isEmpty()) break;
            if (!plugins[i].isFragmentModel() && (desc = plugins[i].getBundleDescription()) != null && (bundleEnvs = desc.getExecutionEnvironments()).length > 0) {
                Iterator iterator = validEEs.iterator();
                while (iterator.hasNext()) {
                    IExecutionEnvironment currentEE = (IExecutionEnvironment)iterator.next();
                    boolean isValid = false;
                    int j = 0;
                    while (j < bundleEnvs.length) {
                        if (isValid) break;
                        if (bundleEnvs[j].equals(currentEE.getId())) {
                            isValid = true;
                            break;
                        }
                        IExecutionEnvironment[] currentSubEE = currentEE.getSubEnvironments();
                        int k = 0;
                        while (k < currentSubEE.length) {
                            if (bundleEnvs[j].equals(currentSubEE[k].getId())) {
                                isValid = true;
                                break;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    if (isValid) continue;
                    iterator.remove();
                }
            }
            ++i;
        }
        if (!validEEs.isEmpty()) {
            return ((IExecutionEnvironment)validEEs.iterator().next()).getId();
        }
        return null;
    }

    public static String getDefaultVMInstallName(ILaunchConfiguration configuration) throws CoreException {
        IJavaProject javaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
        IVMInstall vmInstall = null;
        if (javaProject != null) {
            vmInstall = JavaRuntime.getVMInstall((IJavaProject)javaProject);
        }
        if (vmInstall != null) {
            return vmInstall.getName();
        }
        return VMUtil.getDefaultVMInstallName();
    }

    public static IVMInstall getVMInstall(ILaunchConfiguration configuration) throws CoreException {
        String defaultVMName;
        IVMInstall vm;
        String jre = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, null);
        if (jre != null) {
            IPath jrePath = Path.fromPortableString((String)jre);
            IVMInstall vm2 = JavaRuntime.getVMInstall((IPath)jrePath);
            if (vm2 == null) {
                String id = JavaRuntime.getExecutionEnvironmentId((IPath)jrePath);
                if (id == null) {
                    String name = JavaRuntime.getVMInstallName((IPath)jrePath);
                    throw new CoreException(LauncherUtils.createErrorStatus(NLS.bind((String)PDEMessages.WorkbenchLauncherConfigurationDelegate_noJRE, (Object)name)));
                }
                throw new CoreException(LauncherUtils.createErrorStatus(NLS.bind((String)PDEMessages.VMHelper_cannotFindExecEnv, (Object)id)));
            }
            return vm2;
        }
        String vmInstallAttribute = configuration.getAttribute("vminstall", null);
        if (vmInstallAttribute != null) {
            IVMInstall vm3 = VMHelper.getVMInstall(vmInstallAttribute);
            if (vm3 == null) {
                throw new CoreException(LauncherUtils.createErrorStatus(NLS.bind((String)PDEMessages.WorkbenchLauncherConfigurationDelegate_noJRE, (Object)vmInstallAttribute)));
            }
            return vm3;
        }
        String eeId = VMHelper.getDefaultEEName(configuration);
        if (eeId != null) {
            IVMInstall vm4;
            IExecutionEnvironment ee = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(eeId);
            String vmName = VMUtil.getVMInstallName((IExecutionEnvironment)ee);
            if (ee != null && (vm4 = VMHelper.getVMInstall(vmName)) != null) {
                return vm4;
            }
        }
        if ((vm = VMHelper.getVMInstall(defaultVMName = VMHelper.getDefaultVMInstallName(configuration))) != null) {
            return vm;
        }
        throw new CoreException(LauncherUtils.createErrorStatus(NLS.bind((String)PDEMessages.WorkbenchLauncherConfigurationDelegate_noJRE, (Object)defaultVMName)));
    }

    public static IVMInstall getVMInstall(String name) {
        if (name != null) {
            IVMInstall[] installs = VMUtil.getAllVMInstances();
            int i = 0;
            while (i < installs.length) {
                if (installs[i].getName().equals(name)) {
                    return installs[i];
                }
                ++i;
            }
        }
        return JavaRuntime.getDefaultVMInstall();
    }

    public static IVMInstall createLauncher(ILaunchConfiguration configuration) throws CoreException {
        IVMInstall launcher = VMHelper.getVMInstall(configuration);
        if (!launcher.getInstallLocation().exists()) {
            throw new CoreException(LauncherUtils.createErrorStatus(PDEMessages.WorkbenchLauncherConfigurationDelegate_jrePathNotFound));
        }
        return launcher;
    }
}

