/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.generic.ui.actions;

import org.eclipse.buckminster.generic.ui.GenericUiPlugin;
import org.eclipse.buckminster.generic.ui.Messages;
import org.eclipse.buckminster.generic.ui.actions.AbstractAction;
import org.eclipse.buckminster.generic.ui.actions.IBrowseable;
import org.eclipse.buckminster.generic.ui.actions.IBrowseableFeed;
import org.eclipse.buckminster.generic.ui.actions.IDescribedURL;
import org.eclipse.buckminster.generic.ui.utils.UiUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class ViewInBrowserAction
extends AbstractAction {
    private IWorkbenchBrowserSupport browserSupport = UiUtils.getWorkbench().getBrowserSupport();
    private boolean internal;
    private boolean feed;

    public ViewInBrowserAction(Viewer viewer, boolean internal) {
        this(viewer, internal, null, false);
    }

    public ViewInBrowserAction(Viewer viewer, boolean internal, String what, boolean feed) {
        super(viewer);
        this.internal = internal;
        this.feed = feed;
        String txt = what != null ? NLS.bind((String)Messages.view_0_in_1_, (Object)what, (Object)(internal ? Messages.browser_internal : Messages.browser_external)) : NLS.bind((String)Messages.view_in_0_, (Object)(internal ? Messages.browser_internal : Messages.browser_external));
        this.setText(txt);
        this.setToolTipText(txt);
        this.setImageDescriptor(feed ? GenericUiPlugin.getImageDescriptor("icons/rssfeed.png") : UiUtils.getImageDescriptor("file.html"));
    }

    public void run() {
        Object[] selected;
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection == null || (selected = selection.toArray()).length < 1) {
            this.showMessage(Messages.show_in_browser, Messages.nothing_was_selected);
            return;
        }
        Object sel = selected[0];
        IDescribedURL describedURL = null;
        if (sel instanceof IAdaptable) {
            describedURL = this.feed ? (IDescribedURL)((IAdaptable)sel).getAdapter(IBrowseableFeed.class) : (IDescribedURL)((IAdaptable)sel).getAdapter(IBrowseable.class);
        }
        if (describedURL == null) {
            this.showError(Messages.can_not_open_browser, Messages.no_valid_URL_for_selected_object);
            return;
        }
        try {
            IWebBrowser browser = this.browserSupport.createBrowser(this.internal ? 32 : 128, null, describedURL.getName(), describedURL.getTooltip());
            browser.openURL(describedURL.getBrowseableURL());
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }
}

