/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class ImportResource
extends Task {
    private Path classpath;
    private String resource;
    private boolean optional;

    private static void closeStream(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void closeStream(OutputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        try {
            File resourceFile;
            if (this.resource == null) {
                throw new BuildException("import requires resource attribute");
            }
            if (this.getOwningTarget() == null) throw new BuildException("import only allowed as a top-level task");
            if (!"".equals(this.getOwningTarget().getName())) {
                throw new BuildException("import only allowed as a top-level task");
            }
            Project p = this.getProject();
            ProjectHelper helper = (ProjectHelper)p.getReference("ant.projectHelper");
            Vector importStack = helper.getImportStack();
            if (importStack.size() == 0) {
                throw new BuildException("import requires support in ProjectHelper");
            }
            p.log("Importing resource " + this.resource, 3);
            if (this.classpath != null) {
                p.log("using user supplied classpath: " + this.classpath, 4);
                this.classpath = this.classpath.concatSystemClasspath("ignore");
            } else {
                this.classpath = new Path(p);
                this.classpath = this.classpath.concatSystemClasspath("only");
                p.log("using system classpath: " + this.classpath, 4);
            }
            AntClassLoader loader = new AntClassLoader(p.getCoreLoader(), p, this.classpath, false);
            URL resourceURL = loader.getResource(this.resource);
            if (resourceURL == null) {
                String message = "Cannot find resource " + this.resource;
                if (!this.optional) throw new BuildException(message);
                p.log(message, 3);
                return;
            }
            boolean isLocal = "file".equalsIgnoreCase(resourceURL.getProtocol());
            if (isLocal) {
                resourceFile = new File(resourceURL.getPath());
            } else {
                InputStream input = null;
                FileOutputStream output = null;
                try {
                    int count;
                    byte[] buffer = new byte[4096];
                    input = resourceURL.openStream();
                    resourceFile = File.createTempFile("import-", ".ant");
                    resourceFile.deleteOnExit();
                    output = new FileOutputStream(resourceFile);
                    while ((count = input.read(buffer)) > 0) {
                        ((OutputStream)output).write(buffer, 0, count);
                    }
                }
                catch (IOException e) {
                    try {
                        throw new BuildException(e.getMessage());
                    }
                    catch (Throwable throwable) {
                        ImportResource.closeStream(input);
                        ImportResource.closeStream(output);
                        throw throwable;
                    }
                }
                ImportResource.closeStream(input);
                ImportResource.closeStream(output);
            }
            helper.parse(p, (Object)resourceFile);
            if (isLocal) return;
            resourceFile.delete();
            return;
        }
        catch (BuildException ex) {
            throw ProjectHelper.addLocationToBuildException((BuildException)ex, (Location)this.getLocation());
        }
    }

    public void setClasspath(Path cp) {
        if (this.classpath == null) {
            this.classpath = cp;
        } else {
            this.classpath.append(cp);
        }
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void setResource(String resource) {
        if (resource != null && resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        this.resource = resource;
    }
}

