/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class LastRevision
extends Task {
    private String property;
    private String repositoryLocation;
    private String readerType;
    private String versionSelector;
    private File workingCopy;

    public void execute() throws BuildException {
        if (this.property == null) {
            throw new BuildException("\"property\" must be set", this.getLocation());
        }
        if (this.readerType == null) {
            throw new BuildException("\"readerType\" must be set", this.getLocation());
        }
        try {
            long revNo;
            IReaderType rd = CorePlugin.getDefault().getReaderType(this.readerType);
            NullProgressMonitor nm = new NullProgressMonitor();
            if (this.repositoryLocation == null) {
                if (this.workingCopy == null) {
                    throw new BuildException("\"repositoryLocation\" or \"workingCopy\" must be set", this.getLocation());
                }
                if (this.versionSelector != null) {
                    throw new BuildException("\"versionSelector can only be used together with \"repositoryLocation\" are mutually exclusive", this.getLocation());
                }
                revNo = rd.getLastRevision(this.workingCopy, (IProgressMonitor)nm);
            } else {
                if (this.workingCopy != null) {
                    throw new BuildException("\"repositoryLocation\" or \"workingCopy\" are mutually exclusive", this.getLocation());
                }
                VersionSelector vs = null;
                if (this.versionSelector != null) {
                    vs = VersionSelector.fromString((String)this.versionSelector);
                }
                revNo = rd.getLastRevision(this.repositoryLocation, vs, (IProgressMonitor)nm);
            }
            this.getProject().setProperty(this.property, Long.toString(revNo));
        }
        catch (Exception e) {
            Throwable c = BuckminsterException.unwind((Throwable)e);
            String msg = c.getMessage();
            if (msg == null) {
                msg = c.toString();
            }
            throw new BuildException(msg, c, this.getLocation());
        }
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setReaderType(String readerType) {
        this.readerType = readerType;
    }

    public void setRepositoryLocation(String repositoryLocation) {
        this.repositoryLocation = repositoryLocation;
    }

    public void setVersionSelector(String versionSelector) {
        this.versionSelector = versionSelector;
    }

    public void setWorkingCopy(File workingCopy) {
        this.workingCopy = workingCopy;
    }
}

