/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.taskdefs;

import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class LastTimestamp
extends Task {
    private String property;
    private String repositoryLocation;
    private String readerType;
    private String versionSelector;
    private String dateFormat = "yyyy-MM-dd'T'HH:mm:ss";
    private String timeZone = "UTC";

    public void execute() throws BuildException {
        if (this.property == null) {
            throw new BuildException("\"property\" must be set", this.getLocation());
        }
        if (this.repositoryLocation == null) {
            throw new BuildException("\"repositoryLocation\" must be set", this.getLocation());
        }
        if (this.readerType == null) {
            throw new BuildException("\"readerType\" must be set", this.getLocation());
        }
        VersionSelector vs = null;
        if (this.versionSelector != null) {
            vs = VersionSelector.fromString((String)this.versionSelector);
        }
        try {
            SimpleDateFormat fmt = new SimpleDateFormat(this.dateFormat);
            fmt.setTimeZone(TimeZone.getTimeZone(this.timeZone));
            NullProgressMonitor nm = new NullProgressMonitor();
            IReaderType rd = CorePlugin.getDefault().getReaderType(this.readerType);
            this.getProject().setProperty(this.property, fmt.format(rd.getLastModification(this.repositoryLocation, vs, (IProgressMonitor)nm)));
        }
        catch (Exception e) {
            Throwable c = BuckminsterException.unwind((Throwable)e);
            String msg = c.getMessage();
            if (msg == null) {
                msg = c.toString();
            }
            throw new BuildException(msg, c, this.getLocation());
        }
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setReaderType(String readerType) {
        this.readerType = readerType;
    }

    public void setRepositoryLocation(String repositoryLocation) {
        this.repositoryLocation = repositoryLocation;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void setVersionSelector(String versionSelector) {
        this.versionSelector = versionSelector;
    }
}

