/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.taskdefs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.PropertySet;
import org.eclipse.buckminster.ant.tasks.PerformTask;

public class Perform
extends Task {
    private boolean inWorkspace;
    private boolean quiet;
    private String component;
    private String attribute;
    private final ArrayList<PropertySet> propertySets = new ArrayList();

    public void addPropertySet(PropertySet propertySet) {
        this.propertySets.add(propertySet);
    }

    public void execute() throws BuildException {
        Map<String, String> properties;
        if (this.component == null) {
            throw new BuildException("\"component\" must be set", this.getLocation());
        }
        if (this.attribute == null) {
            throw new BuildException("\"attribute\" must be set", this.getLocation());
        }
        if (this.propertySets.isEmpty()) {
            properties = Collections.emptyMap();
        } else {
            properties = new HashMap();
            for (PropertySet propertySet : this.propertySets) {
                Properties props = propertySet.getProperties();
                Enumeration<?> propNames = props.propertyNames();
                while (propNames.hasMoreElements()) {
                    String key = (String)propNames.nextElement();
                    properties.put(key, props.getProperty(key));
                }
            }
        }
        try {
            PerformTask executor = new PerformTask(this.component, this.attribute, this.inWorkspace, this.quiet, properties);
            int exitStatus = executor.execute();
            if (exitStatus != 0) {
                throw new BuildException("perform exited with " + exitStatus);
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public void setInWorkspace(boolean flag) {
        this.inWorkspace = flag;
    }

    public void setQuiet(boolean flag) {
        this.quiet = flag;
    }
}

