/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.taskdefs;

import java.io.File;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.buckminster.ant.tasks.SignatureCleanerTask;
import org.eclipse.buckminster.ant.types.FileSetGroup;

public class SignatureCleaner
extends Task {
    private final ArrayList<FileSet> fileSets = new ArrayList();
    private ArrayList<FileSetGroup> fileSetGroups;

    public void add(FileSetGroup fsGroup) throws BuildException {
        if (this.fileSetGroups == null) {
            this.fileSetGroups = new ArrayList();
        }
        this.fileSetGroups.add(fsGroup);
    }

    public void addFileset(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void execute() throws BuildException {
        if (this.fileSetGroups != null) {
            for (FileSetGroup fsg : this.fileSetGroups) {
                for (FileSet fs : fsg.getFileSets()) {
                    this.addFileset(fs);
                }
            }
            this.fileSetGroups = null;
        }
        Project proj = this.getProject();
        ArrayList<File> jarFiles = new ArrayList<File>();
        for (FileSet fs : this.fileSets) {
            DirectoryScanner ds = fs.getDirectoryScanner(proj);
            File dir = fs.getDir(proj);
            for (String file : ds.getIncludedFiles()) {
                jarFiles.add(new File(dir, file));
            }
        }
        SignatureCleanerTask cleaner = new SignatureCleanerTask(jarFiles);
        try {
            cleaner.clean();
        }
        catch (Exception e) {
            throw new BuildException(e.toString(), (Throwable)e, this.getLocation());
        }
    }
}

