/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.taskdefs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Substitute
extends Task {
    private String property;
    private String pattern;
    private String replacement;
    private String value;
    private boolean quotePattern;

    public void execute() throws BuildException {
        if (this.property == null) {
            throw new BuildException("\"property\" must be set");
        }
        if (this.pattern == null) {
            throw new BuildException("\"pattern\" must be set");
        }
        if (this.replacement == null) {
            throw new BuildException("\"replacement\" must be set");
        }
        if (this.value == null) {
            throw new BuildException("\"value\" must be set");
        }
        try {
            Matcher matcher;
            String tmp = this.pattern;
            if (this.quotePattern) {
                tmp = Pattern.quote(tmp);
            }
            if ((matcher = Pattern.compile(tmp).matcher(this.value)).find()) {
                StringBuffer sb = new StringBuffer();
                do {
                    matcher.appendReplacement(sb, this.replacement);
                } while (matcher.find());
                matcher.appendTail(sb);
                tmp = sb.toString();
            } else {
                tmp = this.value;
            }
            this.getProject().setProperty(this.property, tmp);
        }
        catch (PatternSyntaxException e) {
            throw new BuildException(e.getMessage());
        }
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setQuotePattern(boolean flag) {
        this.quotePattern = flag;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

