/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ant.taskdefs;

import java.io.File;
import java.util.Collections;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.buckminster.ant.tasks.VersionQualifierTask;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.equinox.p2.metadata.Version;

public class VersionQualifier
extends Task {
    private String componentName;
    private String componentType;
    private File propertiesFile;
    private String property;
    private String qualifier;
    private String version;
    private String versionType;

    public void execute() throws BuildException {
        try {
            if (this.componentName == null) {
                throw new BuildException("Missing attribute componentName", this.getLocation());
            }
            if (this.version == null) {
                throw new BuildException("Missing attribute version", this.getLocation());
            }
            if (this.property == null) {
                throw new BuildException("Missing attribute property", this.getLocation());
            }
            Version v = VersionHelper.createVersion((String)this.versionType, (String)this.version);
            VersionQualifierTask vq = new VersionQualifierTask(this.propertiesFile, this.qualifier);
            ComponentIdentifier cid = new ComponentIdentifier(this.componentName, this.componentType, v);
            String prop = (v = vq.replaceQualifier(cid, Collections.emptyList())) == null ? this.version : v.toString();
            this.getProject().setUserProperty(this.property, prop);
        }
        catch (Exception e) {
            throw new BuildException(e.toString(), this.getLocation());
        }
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public void setPropertiesFile(String propertiesFile) {
        this.propertiesFile = propertiesFile == null || propertiesFile.length() == 0 ? null : new File(propertiesFile);
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setVersionType(String versionType) {
        this.versionType = versionType;
    }
}

