/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.jdt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IFileReader;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.jdt.Messages;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathReader
extends JavaProject
implements IStreamConsumer<IClasspathEntry[]> {
    public static IClasspathEntry[] getClasspath(IComponentReader reader, IProgressMonitor monitor) throws CoreException {
        ClasspathReader rdr = new ClasspathReader();
        try {
            return reader instanceof ICatalogReader ? (IClasspathEntry[])((ICatalogReader)reader).readFile(".classpath", (IStreamConsumer)rdr, monitor) : (IClasspathEntry[])((IFileReader)reader).readFile((IStreamConsumer)rdr, monitor);
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public ClasspathReader() {
        super(ResourcesPlugin.getWorkspace().getRoot().getProject(" "), (JavaElement)JavaModelManager.getJavaModelManager().getJavaModel());
    }

    public IClasspathEntry[] consumeStream(IComponentReader reader, String streamName, InputStream stream, IProgressMonitor monitor) throws CoreException, IOException {
        monitor.beginTask(null, 150);
        monitor.subTask(Messages.parsing_classpath);
        try {
            ByteArrayOutputStream builder = new ByteArrayOutputStream();
            FileUtils.copyFile((InputStream)stream, (OutputStream)builder, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
            IClasspathEntry[] iClasspathEntryArray = this.decodeClasspath(new String(builder.toByteArray()), null)[0];
            return iClasspathEntryArray;
        }
        finally {
            monitor.done();
        }
    }
}

