/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.jdt.commands;

import java.io.File;
import java.util.List;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.commands.WorkspaceCommand;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallJRE
extends WorkspaceCommand {
    private static final OptionDescriptor OPT_LOCATION = new OptionDescriptor('L', "location", 3);
    private static final OptionDescriptor OPT_NAME = new OptionDescriptor('N', "name", 3);
    private static final OptionDescriptor OPT_DEFAULT_ARGS = new OptionDescriptor('D', "defaultArgs", 3);
    private File location;
    private String name;
    private String defaultArgs;

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        appendHere.add(OPT_LOCATION);
        appendHere.add(OPT_NAME);
        appendHere.add(OPT_DEFAULT_ARGS);
        super.getOptionDescriptors(appendHere);
    }

    protected void handleOption(Option option) throws Exception {
        if (option.is(OPT_LOCATION)) {
            this.location = new File(option.getValue());
        } else if (option.is(OPT_NAME)) {
            this.name = option.getValue();
        } else if (option.is(OPT_DEFAULT_ARGS)) {
            this.name = option.getValue();
        } else {
            super.handleOption(option);
        }
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        if (unparsed.length > 0) {
            throw new UsageException(Messages.Too_many_arguments);
        }
    }

    protected int internalRun(IProgressMonitor monitor) throws Exception {
        IVMInstallType vmType;
        IStatus status;
        if (this.location == null) {
            throw new UsageException("Missing required option --location <JRE location>");
        }
        if (!this.location.isDirectory()) {
            throw new UsageException(NLS.bind((String)"JRE location {0} does not appoint a directory", (Object)this.location.getAbsolutePath()));
        }
        if (this.name == null) {
            this.name = this.location.getName();
        }
        if (!(status = (vmType = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType")).validateInstallLocation(this.location)).isOK()) {
            throw new CoreException(status);
        }
        long unique = System.currentTimeMillis();
        while (vmType.findVMInstall(String.valueOf(unique)) != null) {
            ++unique;
        }
        VMStandin vm = new VMStandin(vmType, Long.toString(unique));
        vm.setInstallLocation(this.location);
        vm.setLibraryLocations(vmType.getDefaultLibraryLocations(this.location));
        vm.setName(this.name);
        if (vmType instanceof AbstractVMInstallType) {
            AbstractVMInstallType atype = (AbstractVMInstallType)vmType;
            vm.setJavadocLocation(atype.getDefaultJavadocLocation(this.location));
            String vmArgs = atype.getDefaultVMArguments(this.location);
            if (this.defaultArgs != null) {
                vmArgs = vmArgs == null ? this.defaultArgs : String.valueOf(vmArgs) + ' ' + this.defaultArgs;
            }
            vm.setVMArgs(vmArgs);
        }
        vm.convertToRealVM();
        return 0;
    }
}

