/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.jdt.internal.actor;

import java.net.URI;
import java.util.Map;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.actor.MissingPrerequisiteException;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.jdt.Messages;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.actions.JREAction;
import org.eclipse.osgi.util.NLS;

public class JREpublisherActor
extends AbstractActor {
    public static final String PROPERTY_JRE_ENVIRONMENT_NAME = "jre.environment.name";
    public static final String ALIAS_METADATA_REPOSITORY = "metadata.repository";

    public static IStatus createStatus(String message, Throwable t) {
        return new Status(4, "org.eclipse.buckminster.jdt", message, t);
    }

    protected IStatus internalPerform(IActionContext actionContext, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.publishing_jre, 10);
        PublisherInfo provider = new PublisherInfo();
        provider.setArtifactOptions(provider.getArtifactOptions() | 2);
        try {
            String jreEnvironment = this.processActorProperties(actionContext);
            URI metadataLocation = this.processPrerequisites(actionContext);
            provider.setMetadataRepository(Publisher.createMetadataRepository((IProvisioningAgent)((IProvisioningAgent)Buckminster.getDefault().getService(IProvisioningAgent.class)), (URI)metadataLocation, null, (boolean)true, (boolean)false));
            monitor.worked(3);
            JREAction action = new JREAction(jreEnvironment);
            IStatus iStatus = new Publisher((IPublisherInfo)provider).publish(new IPublisherAction[]{action}, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)7));
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected String processActorProperties(IActionContext actionContext) throws CoreException {
        String jreEnvironment = null;
        StringBuilder message = null;
        for (Map.Entry property : actionContext.getAction().getActorProperties().entrySet()) {
            String name = (String)property.getKey();
            if (PROPERTY_JRE_ENVIRONMENT_NAME.equals(name)) {
                jreEnvironment = (String)ExpandingProperties.expand((Map)actionContext.getProperties(), (Object)((String)property.getValue()), (int)0);
                continue;
            }
            if (message == null) {
                message = new StringBuilder();
            } else {
                message.append(Messages.list_separator);
            }
            message.append(name);
        }
        if (message != null) {
            throw new CoreException(JREpublisherActor.createStatus(String.valueOf(NLS.bind((String)Messages.unrecognized_properties_supplied_0, (Object)message.toString())) + '\n' + NLS.bind((String)Messages.recognized_properties_0, (Object)PROPERTY_JRE_ENVIRONMENT_NAME), null));
        }
        return jreEnvironment;
    }

    protected URI processPrerequisites(IActionContext actionContext) throws CoreException {
        CSpec cspec = actionContext.getCSpec();
        for (Prerequisite prerequisite : actionContext.getAction().getPrerequisites()) {
            Attribute attr;
            if (!ALIAS_METADATA_REPOSITORY.equals(prerequisite.getAlias()) || (attr = prerequisite.getReferencedAttribute(cspec, (IModelCache)actionContext)) == null) continue;
            return AbstractActor.getSingleAttributePath((IActionContext)actionContext, (Attribute)attr, (boolean)false).toFile().toURI();
        }
        throw new MissingPrerequisiteException(actionContext.getAction(), (Object)ALIAS_METADATA_REPOSITORY);
    }
}

