/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.jdt.prefs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.buckminster.cmdline.BasicPreferenceHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.JavaCore;
import org.osgi.service.prefs.BackingStoreException;

public class ComplianceLevelHandler
extends BasicPreferenceHandler {
    public static void setCompilanceOptions(String compliance) throws BackingStoreException {
        HashMap options = new HashMap();
        JavaCore.setComplianceOptions((String)compliance, options);
        if (options.isEmpty()) {
            throw new IllegalArgumentException("Unsupported compliance: " + compliance);
        }
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.core");
        IEclipsePreferences defaults = DefaultScope.INSTANCE.getNode("org.eclipse.jdt.core");
        for (Map.Entry entry : options.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String defaultValue = defaults.get(key, null);
            if (value == null || defaultValue != null && defaultValue.equals(value)) {
                prefs.remove(key);
                continue;
            }
            prefs.put(key, value);
        }
        prefs.flush();
    }

    public String get(String defaultValue) throws CoreException {
        return JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
    }

    public void set(String complianceLevel) throws BackingStoreException {
        ComplianceLevelHandler.setCompilanceOptions(complianceLevel);
    }

    public void unset() throws BackingStoreException {
        ComplianceLevelHandler.setCompilanceOptions((String)JavaCore.getDefaultOptions().get("org.eclipse.jdt.core.compiler.compliance"));
    }
}

