/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.sax;

import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.xml.sax.SAXException;

public abstract class StringElementHandler
extends ChildHandler {
    private char[] buffer = new char[64];
    private int validLength;

    protected StringElementHandler(AbstractHandler parentHandler) {
        super(parentHandler);
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        if (this.validLength == 0) {
            while (length > 0 && Character.isWhitespace(chars[start])) {
                ++start;
                --length;
            }
            if (length == 0) {
                return;
            }
            if (length > this.buffer.length) {
                this.buffer = new char[length];
            }
        } else if (this.validLength + length > this.buffer.length) {
            char[] newBuffer = new char[this.validLength + (this.validLength > length ? this.validLength : length)];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.validLength);
            this.buffer = newBuffer;
        }
        System.arraycopy(chars, start, this.buffer, this.validLength, length);
        this.validLength += length;
    }

    protected final char[] getBuffer() {
        return this.buffer;
    }

    protected final int getLengthAndReset() {
        int last = this.validLength - 1;
        while (last >= 0 && Character.isWhitespace(this.buffer[last])) {
            --last;
        }
        this.validLength = 0;
        return last + 1;
    }
}

