/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.download.internal;

import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.buckminster.download.Messages;
import org.eclipse.osgi.util.NLS;

public class ProgressStatistics {
    private static final int DEFAULT_REPORT_INTERVAL = 1000;
    private static final int SPEED_INTERVAL = 5000;
    private static final int SPEED_RESOLUTION = 1000;
    private final String fileName;
    private final long total;
    private final long startTime = System.currentTimeMillis();
    private long current;
    private long lastReportTime;
    private int reportInterval;
    private SortedMap<Long, Long> recentSpeedMap;
    private long recentSpeedMapKey;

    private static String convert(long amount) {
        if (amount < 1024L) {
            return String.format(Locale.US, "%dB", amount);
        }
        if (amount < 0x100000L) {
            return String.format(Locale.US, "%.2fkB", (double)amount / 1024.0);
        }
        return String.format(Locale.US, "%.2fMB", (double)amount / 1048576.0);
    }

    public ProgressStatistics(String fileName, long total) {
        this.fileName = fileName;
        this.total = total;
        this.current = 0L;
        this.lastReportTime = 0L;
        this.reportInterval = 1000;
        this.recentSpeedMap = new TreeMap<Long, Long>();
        this.recentSpeedMapKey = 0L;
    }

    public long getAverageSpeed() {
        long dur = this.getDuration();
        if (dur >= 1000L) {
            return this.current / (dur / 1000L);
        }
        return 0L;
    }

    public long getDuration() {
        return System.currentTimeMillis() - this.startTime;
    }

    public double getPercentage() {
        if (this.total > 0L) {
            return (double)this.current / (double)this.total;
        }
        return 0.0;
    }

    public synchronized long getRecentSpeed() {
        this.removeObsoleteRecentSpeedData(this.getDuration() / 1000L);
        long dur = 0L;
        long amount = 0L;
        SortedMap<Long, Long> relevantData = this.recentSpeedMap.headMap(this.recentSpeedMapKey);
        for (Map.Entry<Long, Long> entry : relevantData.entrySet()) {
            dur += 1000L;
            amount += entry.getValue().longValue();
        }
        if (dur >= 1000L) {
            return amount / (dur / 1000L);
        }
        return 0L;
    }

    public int getReportInterval() {
        return this.reportInterval;
    }

    public long getTotal() {
        return this.total;
    }

    public void increase(long inc) {
        this.registerRecentSpeed(this.getDuration() / 1000L, inc);
        this.current += inc;
    }

    public synchronized String report() {
        return this.total != -1L ? NLS.bind((String)Messages.fetching_0_1_of_2_at_3, (Object[])new String[]{this.fileName, ProgressStatistics.convert(this.current), ProgressStatistics.convert(this.total), ProgressStatistics.convert(this.getRecentSpeed())}) : NLS.bind((String)Messages.fetching_0_1_at_2, (Object[])new String[]{this.fileName, ProgressStatistics.convert(this.current), ProgressStatistics.convert(this.getRecentSpeed())});
    }

    public void setReportInterval(int reportInterval) {
        this.reportInterval = reportInterval;
    }

    public boolean shouldReport() {
        long currentTime = System.currentTimeMillis();
        if (this.lastReportTime == 0L || currentTime - this.lastReportTime >= (long)this.reportInterval) {
            this.lastReportTime = currentTime;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.report();
    }

    private synchronized void registerRecentSpeed(long key, long inc) {
        Long keyL = key;
        Long currentValueL = (Long)this.recentSpeedMap.get(keyL);
        long currentValue = 0L;
        if (currentValueL != null) {
            currentValue = currentValueL;
        }
        this.recentSpeedMap.put(keyL, inc + currentValue);
        if (this.recentSpeedMapKey != key) {
            this.recentSpeedMapKey = key;
            this.removeObsoleteRecentSpeedData(key);
        }
    }

    private synchronized void removeObsoleteRecentSpeedData(long lastKey) {
        long threshold = lastKey - 5L;
        this.recentSpeedMap.headMap(threshold).clear();
    }
}

