/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.IOException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.ValidationUtils;
import org.eclipse.egit.ui.internal.branch.BranchOperationUI;
import org.eclipse.egit.ui.internal.dialogs.AbstractBranchSelectionDialog;
import org.eclipse.egit.ui.internal.repository.CreateBranchWizard;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class BranchSelectionAndEditDialog
extends AbstractBranchSelectionDialog {
    public static final int NEW = 100;
    private String currentBranch;
    private Button deleteButton;
    private Button renameButton;
    private Button newButton;

    public BranchSelectionAndEditDialog(Shell parentShell, Repository repo, String refToMark, int settings) {
        super(parentShell, repo, refToMark, settings);
        try {
            this.currentBranch = repo.getFullBranch();
        }
        catch (IOException iOException) {
            this.currentBranch = null;
        }
    }

    BranchSelectionAndEditDialog(Shell parentShell, Repository repo, int settings) {
        this(parentShell, repo, null, settings);
    }

    protected String getMessageText() {
        return UIText.BranchSelectionAndEditDialog_Message;
    }

    protected String getTitle() {
        return UIText.BranchSelectionAndEditDialog_Title;
    }

    protected String getWindowTitle() {
        return UIText.BranchSelectionAndEditDialog_WindowTitle;
    }

    protected void refNameSelected(String refName) {
        boolean branchSelected;
        boolean tagSelected = refName != null && refName.startsWith("refs/tags/");
        boolean bl = branchSelected = refName != null && (refName.startsWith("refs/heads/") || refName.startsWith("refs/remotes/"));
        if (((TreeSelection)this.branchTree.getSelection()).size() > 1) {
            TreeSelection selection = (TreeSelection)this.branchTree.getSelection();
            this.deleteButton.setEnabled(this.onlyBranchesExcludingCurrentAreSelected(selection));
            this.renameButton.setEnabled(false);
            if (this.newButton != null) {
                this.newButton.setEnabled(false);
            }
            this.setOkButtonEnabled(false);
        } else {
            this.renameButton.setEnabled(branchSelected && !tagSelected);
            this.deleteButton.setEnabled(branchSelected && !tagSelected && !this.isCurrentBranch(refName));
            if (this.newButton != null) {
                this.newButton.setEnabled(true);
            }
            this.setOkButtonEnabled((branchSelected || tagSelected) && !this.isCurrentBranch(refName));
        }
        Button okButton = this.getButton(0);
        if (okButton != null) {
            if (BranchOperationUI.checkoutWillShowQuestionDialog(refName)) {
                okButton.setText(UIText.CheckoutDialog_OkCheckoutWithQuestion);
            } else {
                okButton.setText(UIText.CheckoutDialog_OkCheckout);
            }
        }
    }

    private boolean isCurrentBranch(String refName) {
        if (refName != null) {
            return refName.equals(this.currentBranch);
        }
        return false;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createNewButton(parent);
        this.createRenameButton(parent);
        this.createDeleteButton(parent);
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(!this.branchTree.getSelection().isEmpty());
    }

    protected Button createNewButton(Composite parent) {
        this.newButton = this.createButton(parent, 100, UIText.BranchSelectionAndEditDialog_NewBranch, false);
        this.setButtonLayoutData(this.newButton);
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateBranchWizard wiz = new CreateBranchWizard(BranchSelectionAndEditDialog.this.repo, BranchSelectionAndEditDialog.this.refNameFromDialog());
                if (new WizardDialog(BranchSelectionAndEditDialog.this.getShell(), (IWizard)wiz).open() == 0) {
                    String newRefName = wiz.getNewBranchName();
                    try {
                        BranchSelectionAndEditDialog.this.branchTree.refresh();
                        BranchSelectionAndEditDialog.this.markRef("refs/heads/" + newRefName);
                        if (BranchSelectionAndEditDialog.this.repo.getBranch().equals(newRefName)) {
                            BranchSelectionAndEditDialog.this.okPressed();
                        }
                    }
                    catch (Throwable e1) {
                        BranchSelectionAndEditDialog.this.reportError(e1, UIText.BranchSelectionAndEditDialog_ErrorCouldNotCreateNewRef, new Object[]{newRefName});
                    }
                }
            }
        });
        return this.newButton;
    }

    protected Button createRenameButton(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        this.renameButton = new Button(parent, 8);
        this.renameButton.setFont(JFaceResources.getDialogFont());
        this.renameButton.setText(UIText.BranchSelectionAndEditDialog_Rename);
        this.setButtonLayoutData(this.renameButton);
        this.renameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String refPrefix;
                String refName = BranchSelectionAndEditDialog.this.refNameFromDialog();
                if (refName.startsWith("refs/heads/")) {
                    refPrefix = "refs/heads/";
                } else if (refName.startsWith("refs/remotes/")) {
                    refPrefix = "refs/remotes/";
                } else if (refName.startsWith("refs/tags/")) {
                    refPrefix = "refs/tags/";
                } else {
                    return;
                }
                String branchName = refName.substring(refPrefix.length());
                InputDialog labelDialog = BranchSelectionAndEditDialog.this.getRefNameInputDialog(NLS.bind((String)UIText.BranchSelectionAndEditDialog_QuestionNewBranchNameMessage, (Object)branchName, (Object)refPrefix), refPrefix, branchName);
                if (labelDialog.open() == 0) {
                    String newRefName = String.valueOf(refPrefix) + labelDialog.getValue();
                    try {
                        new Git(BranchSelectionAndEditDialog.this.repo).branchRename().setOldName(refName).setNewName(labelDialog.getValue()).call();
                        BranchSelectionAndEditDialog.this.branchTree.refresh();
                        BranchSelectionAndEditDialog.this.markRef(newRefName);
                    }
                    catch (Throwable e1) {
                        BranchSelectionAndEditDialog.this.reportError(e1, UIText.BranchSelectionAndEditDialog_ErrorCouldNotRenameRef, new Object[]{refName, newRefName, e1.getMessage()});
                    }
                }
            }
        });
        return this.renameButton;
    }

    protected Button createDeleteButton(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        this.deleteButton = new Button(parent, 8);
        this.deleteButton.setFont(JFaceResources.getDialogFont());
        this.deleteButton.setText(UIText.BranchSelectionAndEditDialog_Delete);
        this.setButtonLayoutData(this.deleteButton);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    CommonUtils.runCommand("org.eclipse.ui.edit.delete", (IStructuredSelection)BranchSelectionAndEditDialog.this.branchTree.getSelection());
                    BranchSelectionAndEditDialog.this.branchTree.refresh();
                }
                catch (Throwable e) {
                    BranchSelectionAndEditDialog.this.reportError(e, UIText.BranchSelectionAndEditDialog_ErrorCouldNotDeleteRef, new Object[]{BranchSelectionAndEditDialog.this.refNameFromDialog()});
                }
            }
        });
        return this.deleteButton;
    }

    private InputDialog getRefNameInputDialog(String prompt, String refPrefix, String initialValue) {
        InputDialog labelDialog = new InputDialog(this.getShell(), UIText.BranchSelectionAndEditDialog_QuestionNewBranchTitle, prompt, initialValue, ValidationUtils.getRefNameInputValidator(this.repo, refPrefix, true));
        labelDialog.setBlockOnOpen(true);
        return labelDialog;
    }

    private void reportError(Throwable e, String message, Object ... args) {
        String msg = NLS.bind((String)message, (Object[])args);
        Activator.handleError(msg, e, true);
    }

    private boolean onlyBranchesExcludingCurrentAreSelected(TreeSelection selection) {
        for (Object sel : selection) {
            if (sel instanceof RefNode) {
                RefNode node = (RefNode)sel;
                String refName = ((Ref)node.getObject()).getName();
                if (!refName.startsWith("refs/heads/") && !refName.startsWith("refs/remotes/")) {
                    return false;
                }
                if (!this.isCurrentBranch(refName)) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

