/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractHistoryCommandHandler
extends AbstractHandler {
    AbstractHistoryCommandHandler() {
    }

    protected IWorkbenchPart getPart(ExecutionEvent event) throws ExecutionException {
        return HandlerUtil.getActivePartChecked((ExecutionEvent)event);
    }

    private Object getInput(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = this.getPart(event);
        if (!(part instanceof IHistoryView)) {
            throw new ExecutionException(UIText.AbstractHistoryCommanndHandler_NoInputMessage);
        }
        return ((IHistoryView)part).getHistoryPage().getInput();
    }

    protected Repository getRepository(ExecutionEvent event) throws ExecutionException {
        RepositoryMapping mapping;
        IResource resource;
        Object input = this.getInput(event);
        if (input == null) {
            return null;
        }
        if (input instanceof HistoryPageInput) {
            return ((HistoryPageInput)input).getRepository();
        }
        if (input instanceof RepositoryTreeNode) {
            return ((RepositoryTreeNode)input).getRepository();
        }
        if (input instanceof IResource) {
            resource = (IResource)input;
            mapping = RepositoryMapping.getMapping((IResource)resource);
            if (mapping != null) {
                return mapping.getRepository();
            }
            Repository repository = Activator.getDefault().getRepositoryCache().getRepository(resource);
            if (repository != null) {
                return repository;
            }
        }
        if (input instanceof IAdaptable && (resource = (IResource)((IAdaptable)input).getAdapter(IResource.class)) != null && (mapping = RepositoryMapping.getMapping((IResource)resource)) != null) {
            return mapping.getRepository();
        }
        Repository repo = (Repository)AdapterUtils.adapt((Object)input, Repository.class);
        if (repo != null) {
            return repo;
        }
        throw new ExecutionException(UIText.AbstractHistoryCommanndHandler_CouldNotGetRepositoryMessage);
    }

    protected String getRepoRelativePath(Repository repo, File file) {
        Path workdirPath = new Path(repo.getWorkTree().getPath());
        IPath filePath = new Path(file.getPath()).setDevice(null);
        return filePath.removeFirstSegments(workdirPath.segmentCount()).toString();
    }

    protected List<RevTag> getRevTags(ExecutionEvent event) throws ExecutionException {
        Repository repo = this.getRepository(event);
        Collection revTags = repo.getTags().values();
        ArrayList<RevTag> tags = new ArrayList<RevTag>();
        RevWalk walk = new RevWalk(repo);
        for (Ref ref : revTags) {
            try {
                tags.add(walk.parseTag((AnyObjectId)repo.resolve(ref.getName())));
            }
            catch (IOException e) {
                throw new ExecutionException(e.getMessage(), (Throwable)e);
            }
        }
        return tags;
    }

    protected GitHistoryPage getPage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        if (window.getActivePage() == null) {
            return null;
        }
        IWorkbenchPart part = window.getActivePage().getActivePart();
        if (!(part instanceof IHistoryView)) {
            return null;
        }
        IHistoryView view = (IHistoryView)part;
        IHistoryPage page = view.getHistoryPage();
        if (page instanceof GitHistoryPage) {
            return (GitHistoryPage)page;
        }
        return null;
    }

    protected IStructuredSelection getSelection(GitHistoryPage page) {
        if (page == null) {
            return StructuredSelection.EMPTY;
        }
        ISelection pageSelection = page.getSelectionProvider().getSelection();
        if (pageSelection instanceof IStructuredSelection) {
            return (IStructuredSelection)pageSelection;
        }
        return StructuredSelection.EMPTY;
    }

    protected List<RevCommit> getSelectedCommits() throws ExecutionException {
        ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
        GitHistoryPage page = this.getPage();
        if (page == null) {
            return Collections.emptyList();
        }
        IStructuredSelection selection = this.getSelection(page);
        HistoryPageInput input = page.getInputInternal();
        if (input == null) {
            return Collections.emptyList();
        }
        RevWalk walk = new RevWalk(input.getRepository());
        try {
            try {
                for (Object element : selection.toList()) {
                    RevCommit commit = (RevCommit)element;
                    RevCommit reparsed = walk.parseCommit((AnyObjectId)commit.getId());
                    commits.add(reparsed);
                }
            }
            catch (IOException e) {
                throw new ExecutionException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            walk.release();
        }
        return commits;
    }

    protected List<RefNode> getRefNodes(RevCommit commit, Repository repo, String ... refPrefixes) {
        ArrayList<Ref> availableBranches = new ArrayList<Ref>();
        ArrayList<RefNode> nodes = new ArrayList<RefNode>();
        try {
            HashMap branches = new HashMap();
            String[] stringArray = refPrefixes;
            int n = refPrefixes.length;
            int n2 = 0;
            while (n2 < n) {
                String refPrefix = stringArray[n2];
                branches.putAll(repo.getRefDatabase().getRefs(refPrefix));
                ++n2;
            }
            for (Ref branch : branches.values()) {
                if (!branch.getLeaf().getObjectId().equals((AnyObjectId)commit.getId())) continue;
                availableBranches.add(branch);
            }
            RepositoryNode repoNode = new RepositoryNode(null, repo);
            for (Ref ref : availableBranches) {
                nodes.add(new RefNode(repoNode, repo, ref));
            }
        }
        catch (IOException iOException) {}
        return nodes;
    }

    protected List<Ref> getBranchesOfCommit(GitHistoryPage page, Repository repo, boolean hideCurrentBranch) throws IOException {
        String head = repo.getFullBranch();
        return this.getBranchesOfCommit(page, head, hideCurrentBranch);
    }

    protected List<Ref> getBranchesOfCommit(GitHistoryPage page) {
        return this.getBranchesOfCommit(page, (String)null, false);
    }

    private List<Ref> getBranchesOfCommit(GitHistoryPage page, String head, boolean hideCurrentBranch) {
        ArrayList<Ref> branchesOfCommit = new ArrayList<Ref>();
        IStructuredSelection selection = this.getSelection(page);
        if (selection.isEmpty()) {
            return branchesOfCommit;
        }
        PlotCommit commit = (PlotCommit)selection.getFirstElement();
        int refCount = commit.getRefCount();
        int i = 0;
        while (i < refCount) {
            Ref ref = commit.getRef(i);
            String refName = ref.getName();
            if (!(hideCurrentBranch && head != null && refName.equals(head) || !refName.startsWith("refs/heads/") && !refName.startsWith("refs/remotes/"))) {
                branchesOfCommit.add(ref);
            }
            ++i;
        }
        return branchesOfCommit;
    }

    protected Repository getRepository(GitHistoryPage page) {
        if (page == null) {
            return null;
        }
        HistoryPageInput input = page.getInputInternal();
        if (input == null) {
            return null;
        }
        Repository repository = input.getRepository();
        return repository;
    }
}

