/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.staging;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffChangedListener;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.op.CommitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.EgitUiEditorUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.BooleanPrefAction;
import org.eclipse.egit.ui.internal.commands.shared.AbortRebaseCommand;
import org.eclipse.egit.ui.internal.commands.shared.AbstractRebaseCommandHandler;
import org.eclipse.egit.ui.internal.commands.shared.ContinueRebaseCommand;
import org.eclipse.egit.ui.internal.commands.shared.SkipRebaseCommand;
import org.eclipse.egit.ui.internal.commit.CommitHelper;
import org.eclipse.egit.ui.internal.commit.CommitJob;
import org.eclipse.egit.ui.internal.commit.CommitMessageHistory;
import org.eclipse.egit.ui.internal.commit.CommitProposalProcessor;
import org.eclipse.egit.ui.internal.components.ToggleableWarningLabel;
import org.eclipse.egit.ui.internal.decorators.ProblemLabelDecorator;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageArea;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageComponent;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageComponentState;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageComponentStateManager;
import org.eclipse.egit.ui.internal.dialogs.ICommitMessageComponentNotifications;
import org.eclipse.egit.ui.internal.dialogs.SpellcheckableMessageArea;
import org.eclipse.egit.ui.internal.gerrit.GerritUtil;
import org.eclipse.egit.ui.internal.operations.DeletePathsOperationUI;
import org.eclipse.egit.ui.internal.operations.IgnoreOperationUI;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.staging.StagingEntry;
import org.eclipse.egit.ui.internal.staging.StagingFolderEntry;
import org.eclipse.egit.ui.internal.staging.StagingViewContentProvider;
import org.eclipse.egit.ui.internal.staging.StagingViewLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StagingView
extends ViewPart
implements IShowInSource {
    public static final String VIEW_ID = "org.eclipse.egit.ui.StagingView";
    private static final String EMPTY_STRING = "";
    private FormToolkit toolkit;
    private Form form;
    private Section stagedSection;
    private Section unstagedSection;
    private Section commitMessageSection;
    private TreeViewer stagedViewer;
    private TreeViewer unstagedViewer;
    private ToggleableWarningLabel warningLabel;
    private Text filterText;
    private SpellcheckableMessageArea commitMessageText;
    private Text committerText;
    private Text authorText;
    private CommitMessageComponent commitMessageComponent;
    private boolean reactOnSelection = true;
    private ISelectionListener selectionChangedListener;
    private ToolBarManager unstagedToolBarManager;
    private ToolBarManager stagedToolBarManager;
    private Action listPresentationAction;
    private Action treePresentationAction;
    private Action compactTreePresentationAction;
    private Action unstagedExpandAllAction;
    private Action unstagedCollapseAllAction;
    private Action stagedExpandAllAction;
    private Action stagedCollapseAllAction;
    private Repository currentRepository;
    private Presentation presentation = Presentation.LIST;
    private Set<IPath> pathsToExpandInStaged = new HashSet<IPath>();
    private Set<IPath> pathsToExpandInUnstaged = new HashSet<IPath>();
    private final IEclipsePreferences.IPreferenceChangeListener prefListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (!"GitRepositoriesView.GitDirectories".equals(event.getKey())) {
                return;
            }
            Repository repo = StagingView.this.currentRepository;
            if (repo == null) {
                return;
            }
            if (Activator.getDefault().getRepositoryUtil().contains(repo)) {
                return;
            }
            StagingView.this.reload(null);
        }
    };
    private Action signedOffByAction;
    private Action addChangeIdAction;
    private Action amendPreviousCommitAction;
    private Action openNewCommitsAction;
    private Action columnLayoutAction;
    private Action fileNameModeAction;
    private Action refreshAction;
    private SashForm stagingSashForm;
    private IndexDiffChangedListener myIndexDiffListener = new IndexDiffChangedListener(){

        public void indexDiffChanged(Repository repository, IndexDiffData indexDiffData) {
            StagingView.this.reload(repository);
        }
    };
    private IndexDiffCacheEntry cacheEntry;
    private UndoRedoActionGroup undoRedoActionGroup;
    private Button commitButton;
    private Button commitAndPushButton;
    private Section rebaseSection;
    private Button rebaseContinueButton;
    private Button rebaseSkipButton;
    private Button rebaseAbortButton;
    private ListenerHandle refsChangedListener;
    private LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources());

    private Image getImage(ImageDescriptor descriptor) {
        return (Image)this.resources.get((DeviceResourceDescriptor)descriptor);
    }

    public void createPartControl(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.toolkit = new FormToolkit(parent.getDisplay());
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StagingView.this.resources.dispose();
                StagingView.this.toolkit.dispose();
            }
        });
        this.form = this.toolkit.createForm(parent);
        this.form.setImage(this.getImage(UIIcons.REPOSITORY));
        this.form.setText(UIText.StagingView_NoSelectionTitle);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.form);
        this.toolkit.decorateFormHeading(this.form);
        GridLayoutFactory.swtDefaults().applyTo(this.form.getBody());
        SashForm horizontalSashForm = new SashForm(this.form.getBody(), 0);
        this.toolkit.adapt((Control)horizontalSashForm, true, true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)horizontalSashForm);
        this.stagingSashForm = new SashForm((Composite)horizontalSashForm, this.getStagingFormOrientation());
        this.toolkit.adapt((Control)this.stagingSashForm, true, true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.stagingSashForm);
        this.unstagedSection = this.toolkit.createSection((Composite)this.stagingSashForm, 256);
        this.createUnstagedToolBarComposite();
        Composite unstagedComposite = this.toolkit.createComposite((Composite)this.unstagedSection);
        this.toolkit.paintBordersFor(unstagedComposite);
        this.unstagedSection.setClient((Control)unstagedComposite);
        GridLayoutFactory.fillDefaults().extendedMargins(2, 2, 2, 2).applyTo(unstagedComposite);
        this.unstagedViewer = this.createTree(unstagedComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.unstagedViewer.getControl());
        this.unstagedViewer.getTree().setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        this.unstagedViewer.getTree().setLinesVisible(true);
        this.unstagedViewer.setLabelProvider(this.createLabelProvider(this.unstagedViewer));
        this.unstagedViewer.setContentProvider((IContentProvider)new StagingViewContentProvider(this, true));
        this.unstagedViewer.addDragSupport(7, new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()}, (DragSourceListener)new StagingDragListener((ISelectionProvider)this.unstagedViewer));
        this.unstagedViewer.addDropSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                event.detail = 1;
                if (event.data instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.data;
                    StagingView.this.unstage(selection);
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.detail = 2;
            }
        });
        this.unstagedViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                StagingView.this.compareWith(event);
            }
        });
        StagingView.enableAutoExpand((AbstractTreeViewer)this.unstagedViewer);
        StagingView.addListenerToDisableAutoExpandOnCollapse(this.unstagedViewer);
        Composite rebaseAndCommitComposite = this.toolkit.createComposite((Composite)horizontalSashForm);
        rebaseAndCommitComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.rebaseSection = this.toolkit.createSection(rebaseAndCommitComposite, 256);
        this.rebaseSection.setText(UIText.StagingView_RebaseLabel);
        Composite rebaseComposite = this.toolkit.createComposite((Composite)this.rebaseSection);
        this.toolkit.paintBordersFor(rebaseComposite);
        this.rebaseSection.setClient((Control)rebaseComposite);
        this.rebaseSection.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        rebaseComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(true).create());
        GridDataFactory buttonGridData = GridDataFactory.fillDefaults().align(4, 0x1000000);
        this.rebaseAbortButton = this.toolkit.createButton(rebaseComposite, UIText.StagingView_RebaseAbort, 8);
        this.rebaseAbortButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StagingView.this.rebaseAbort();
            }
        });
        this.rebaseAbortButton.setImage(this.getImage(UIIcons.REBASE_ABORT));
        buttonGridData.applyTo((Control)this.rebaseAbortButton);
        this.rebaseSkipButton = this.toolkit.createButton(rebaseComposite, UIText.StagingView_RebaseSkip, 8);
        this.rebaseSkipButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StagingView.this.rebaseSkip();
            }
        });
        this.rebaseSkipButton.setImage(this.getImage(UIIcons.REBASE_SKIP));
        buttonGridData.applyTo((Control)this.rebaseSkipButton);
        this.rebaseContinueButton = this.toolkit.createButton(rebaseComposite, UIText.StagingView_RebaseContinue, 8);
        this.rebaseContinueButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StagingView.this.rebaseContinue();
            }
        });
        this.rebaseContinueButton.setImage(this.getImage(UIIcons.REBASE_CONTINUE));
        buttonGridData.applyTo((Control)this.rebaseContinueButton);
        StagingView.showControl((Control)this.rebaseSection, false);
        this.commitMessageSection = this.toolkit.createSection(rebaseAndCommitComposite, 256);
        this.commitMessageSection.setText(UIText.StagingView_CommitMessage);
        this.commitMessageSection.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Composite commitMessageToolbarComposite = this.toolkit.createComposite((Composite)this.commitMessageSection);
        commitMessageToolbarComposite.setBackground(null);
        commitMessageToolbarComposite.setLayout((Layout)StagingView.createRowLayoutWithoutMargin());
        this.commitMessageSection.setTextClient((Control)commitMessageToolbarComposite);
        ToolBarManager commitMessageToolBarManager = new ToolBarManager(0x800100);
        this.amendPreviousCommitAction = new Action(UIText.StagingView_Ammend_Previous_Commit, 2){

            public void run() {
                StagingView.this.commitMessageComponent.setAmendingButtonSelection(this.isChecked());
                StagingView.this.updateMessage();
            }
        };
        this.amendPreviousCommitAction.setImageDescriptor(UIIcons.AMEND_COMMIT);
        commitMessageToolBarManager.add((IAction)this.amendPreviousCommitAction);
        this.signedOffByAction = new Action(UIText.StagingView_Add_Signed_Off_By, 2){

            public void run() {
                StagingView.this.commitMessageComponent.setSignedOffButtonSelection(this.isChecked());
            }
        };
        this.signedOffByAction.setImageDescriptor(UIIcons.SIGNED_OFF);
        commitMessageToolBarManager.add((IAction)this.signedOffByAction);
        this.addChangeIdAction = new Action(UIText.StagingView_Add_Change_ID, 2){

            public void run() {
                StagingView.this.commitMessageComponent.setChangeIdButtonSelection(this.isChecked());
            }
        };
        this.addChangeIdAction.setImageDescriptor(UIIcons.GERRIT);
        commitMessageToolBarManager.add((IAction)this.addChangeIdAction);
        commitMessageToolBarManager.createControl(commitMessageToolbarComposite);
        Composite commitMessageComposite = this.toolkit.createComposite((Composite)this.commitMessageSection);
        this.commitMessageSection.setClient((Control)commitMessageComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(commitMessageComposite);
        this.warningLabel = new ToggleableWarningLabel(commitMessageComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).exclude(true).applyTo((Control)this.warningLabel);
        Composite commitMessageTextComposite = this.toolkit.createComposite(commitMessageComposite);
        this.toolkit.paintBordersFor(commitMessageTextComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)commitMessageTextComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).extendedMargins(2, 2, 2, 2).applyTo(commitMessageTextComposite);
        final CommitProposalProcessor commitProposalProcessor = new CommitProposalProcessor(){

            @Override
            protected Collection<String> computeFileNameProposals() {
                return StagingView.this.getStagedFileNames();
            }

            @Override
            protected Collection<String> computeMessageProposals() {
                return CommitMessageHistory.getCommitHistory();
            }
        };
        this.commitMessageText = new CommitMessageArea(commitMessageTextComposite, EMPTY_STRING, this.toolkit.getBorderStyle()){

            protected CommitProposalProcessor getCommitProposalProcessor() {
                return commitProposalProcessor;
            }

            protected IHandlerService getHandlerService() {
                return (IHandlerService)StagingView.this.getSite().getService(IHandlerService.class);
            }
        };
        this.commitMessageText.setData("FormWidgetFactory.drawBorder", "textBorder");
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.commitMessageText);
        UIUtils.addBulbDecorator((Control)this.commitMessageText.getTextWidget(), UIText.CommitDialog_ContentAssist);
        Composite composite = this.toolkit.createComposite(commitMessageComposite);
        this.toolkit.paintBordersFor(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(composite);
        this.toolkit.createLabel(composite, UIText.StagingView_Author).setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        this.authorText = this.toolkit.createText(composite, null);
        this.authorText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.authorText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.toolkit.createLabel(composite, UIText.StagingView_Committer).setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        this.committerText = this.toolkit.createText(composite, null);
        this.committerText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.committerText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Composite buttonsContainer = this.toolkit.createComposite(composite);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).indent(0, 8).applyTo((Control)buttonsContainer);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(buttonsContainer);
        Label filler = this.toolkit.createLabel(buttonsContainer, EMPTY_STRING);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)filler);
        Composite commitButtonsContainer = this.toolkit.createComposite(buttonsContainer);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)commitButtonsContainer);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(commitButtonsContainer);
        this.commitAndPushButton = this.toolkit.createButton(commitButtonsContainer, UIText.StagingView_CommitAndPush, 8);
        this.commitAndPushButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StagingView.this.commit(true);
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.commitAndPushButton);
        this.commitButton = this.toolkit.createButton(commitButtonsContainer, UIText.StagingView_Commit, 8);
        this.commitButton.setImage(this.getImage(UIIcons.COMMIT));
        this.commitButton.setText(UIText.StagingView_Commit);
        this.commitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StagingView.this.commit(false);
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.commitButton);
        this.stagedSection = this.toolkit.createSection((Composite)this.stagingSashForm, 256);
        this.createStagedToolBarComposite();
        Composite stagedComposite = this.toolkit.createComposite((Composite)this.stagedSection);
        this.toolkit.paintBordersFor(stagedComposite);
        this.stagedSection.setClient((Control)stagedComposite);
        GridLayoutFactory.fillDefaults().extendedMargins(2, 2, 2, 2).applyTo(stagedComposite);
        this.stagedViewer = this.createTree(stagedComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.stagedViewer.getControl());
        this.stagedViewer.getTree().setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        this.stagedViewer.getTree().setLinesVisible(true);
        this.stagedViewer.setLabelProvider(this.createLabelProvider(this.stagedViewer));
        this.stagedViewer.setContentProvider((IContentProvider)new StagingViewContentProvider(this, false));
        this.stagedViewer.addDragSupport(7, new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()}, (DragSourceListener)new StagingDragListener((ISelectionProvider)this.stagedViewer));
        this.stagedViewer.addDropSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                event.detail = 1;
                if (event.data instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.data;
                    StagingView.this.stage(selection);
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.detail = 2;
            }
        });
        this.stagedViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                StagingView.this.compareWith(event);
            }
        });
        StagingView.enableAutoExpand((AbstractTreeViewer)this.stagedViewer);
        StagingView.addListenerToDisableAutoExpandOnCollapse(this.stagedViewer);
        this.selectionChangedListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (!StagingView.this.reactOnSelection || part == StagingView.this.getSite().getPart()) {
                    return;
                }
                if (part instanceof IEditorPart) {
                    IEditorInput input = ((IEditorPart)part).getEditorInput();
                    if (input instanceof IFileEditorInput) {
                        StagingView.this.reactOnSelection((ISelection)new StructuredSelection((Object)((IFileEditorInput)input).getFile()));
                    }
                } else {
                    StagingView.this.reactOnSelection(selection);
                }
            }
        };
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        if (preferenceStore.contains("StagingView_SyncWithSelection")) {
            this.reactOnSelection = preferenceStore.getBoolean("StagingView_SyncWithSelection");
        } else {
            preferenceStore.setDefault("StagingView_SyncWithSelection", true);
        }
        InstanceScope.INSTANCE.getNode(org.eclipse.egit.core.Activator.getPluginId()).addPreferenceChangeListener(this.prefListener);
        this.updateSectionText();
        this.updateToolbar();
        this.enableCommitWidgets(false);
        this.refreshAction.setEnabled(false);
        this.createPopupMenu(this.unstagedViewer);
        this.createPopupMenu(this.stagedViewer);
        ICommitMessageComponentNotifications listener = new ICommitMessageComponentNotifications(){

            public void updateSignedOffToggleSelection(boolean selection) {
                StagingView.this.signedOffByAction.setChecked(selection);
            }

            public void updateChangeIdToggleSelection(boolean selection) {
                StagingView.this.addChangeIdAction.setChecked(selection);
            }

            public void statusUpdated() {
                StagingView.this.updateMessage();
            }
        };
        this.commitMessageComponent = new CommitMessageComponent(listener);
        this.commitMessageComponent.attachControls(this.commitMessageText, this.authorText, this.committerText);
        this.commitMessageText.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (UIUtils.isSubmitKeyEvent((KeyEvent)event)) {
                    event.doit = false;
                    StagingView.this.commit(false);
                }
            }
        });
        this.commitMessageText.getTextWidget().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                String commitButtonTooltip = MessageFormat.format(UIText.StagingView_CommitToolTip, UIUtils.SUBMIT_KEY_STROKE.format());
                StagingView.this.commitButton.setToolTipText(commitButtonTooltip);
            }

            public void focusLost(FocusEvent e) {
                StagingView.this.commitButton.setToolTipText(null);
            }
        });
        IWorkbenchPartSite site = this.getSite();
        ISelectionService srv = (ISelectionService)site.getService(ISelectionService.class);
        srv.addPostSelectionListener(this.selectionChangedListener);
        UIUtils.notifySelectionChangedWithCurrentSelection(this.selectionChangedListener, (IServiceLocator)site);
        site.setSelectionProvider((ISelectionProvider)this.unstagedViewer);
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                StagingViewContentProvider contentProvider = StagingView.this.getContentProvider((ContentViewer)((TreeViewer)viewer));
                if (element instanceof StagingEntry) {
                    return contentProvider.isInFilter((StagingEntry)element);
                }
                if (element instanceof StagingFolderEntry) {
                    return contentProvider.hasVisibleChildren((StagingFolderEntry)element);
                }
                return true;
            }
        };
        this.unstagedViewer.addFilter(filter);
        this.stagedViewer.addFilter(filter);
    }

    private void executeRebaseOperation(AbstractRebaseCommandHandler command) {
        try {
            command.execute(this.currentRepository);
        }
        catch (ExecutionException e) {
            Activator.showError(e.getMessage(), e);
        }
    }

    protected void rebaseAbort() {
        AbortRebaseCommand abortCommand = new AbortRebaseCommand();
        this.executeRebaseOperation(abortCommand);
    }

    protected void rebaseSkip() {
        SkipRebaseCommand skipCommand = new SkipRebaseCommand();
        this.executeRebaseOperation(skipCommand);
    }

    protected void rebaseContinue() {
        ContinueRebaseCommand continueCommand = new ContinueRebaseCommand();
        this.executeRebaseOperation(continueCommand);
    }

    private void createUnstagedToolBarComposite() {
        Composite unstagedToolbarComposite = this.toolkit.createComposite((Composite)this.unstagedSection);
        unstagedToolbarComposite.setBackground(null);
        unstagedToolbarComposite.setLayout((Layout)StagingView.createRowLayoutWithoutMargin());
        this.unstagedSection.setTextClient((Control)unstagedToolbarComposite);
        this.unstagedExpandAllAction = new Action(UIText.UIUtils_ExpandAll, 1){

            public void run() {
                StagingView.this.unstagedViewer.expandAll();
                StagingView.enableAutoExpand((AbstractTreeViewer)StagingView.this.unstagedViewer);
            }
        };
        this.unstagedExpandAllAction.setImageDescriptor(UIIcons.EXPAND_ALL);
        this.unstagedCollapseAllAction = new Action(UIText.UIUtils_CollapseAll, 1){

            public void run() {
                StagingView.this.unstagedViewer.collapseAll();
                StagingView.disableAutoExpand((AbstractTreeViewer)StagingView.this.unstagedViewer);
            }
        };
        this.unstagedCollapseAllAction.setImageDescriptor(UIIcons.COLLAPSEALL);
        this.unstagedToolBarManager = new ToolBarManager(0x800100);
        this.unstagedToolBarManager.add((IAction)this.unstagedExpandAllAction);
        this.unstagedToolBarManager.add((IAction)this.unstagedCollapseAllAction);
        this.unstagedToolBarManager.update(true);
        this.unstagedToolBarManager.createControl(unstagedToolbarComposite);
    }

    private void createStagedToolBarComposite() {
        Composite stagedToolbarComposite = this.toolkit.createComposite((Composite)this.stagedSection);
        stagedToolbarComposite.setBackground(null);
        stagedToolbarComposite.setLayout((Layout)StagingView.createRowLayoutWithoutMargin());
        this.stagedSection.setTextClient((Control)stagedToolbarComposite);
        this.stagedExpandAllAction = new Action(UIText.UIUtils_ExpandAll, 1){

            public void run() {
                StagingView.this.stagedViewer.expandAll();
                StagingView.enableAutoExpand((AbstractTreeViewer)StagingView.this.stagedViewer);
            }
        };
        this.stagedExpandAllAction.setImageDescriptor(UIIcons.EXPAND_ALL);
        this.stagedCollapseAllAction = new Action(UIText.UIUtils_CollapseAll, 1){

            public void run() {
                StagingView.this.stagedViewer.collapseAll();
                StagingView.disableAutoExpand((AbstractTreeViewer)StagingView.this.stagedViewer);
            }
        };
        this.stagedCollapseAllAction.setImageDescriptor(UIIcons.COLLAPSEALL);
        this.stagedToolBarManager = new ToolBarManager(0x800100);
        this.stagedToolBarManager.add((IAction)this.stagedExpandAllAction);
        this.stagedToolBarManager.add((IAction)this.stagedCollapseAllAction);
        this.stagedToolBarManager.update(true);
        this.stagedToolBarManager.createControl(stagedToolbarComposite);
    }

    private static RowLayout createRowLayoutWithoutMargin() {
        RowLayout layout = new RowLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        return layout;
    }

    private static void addListenerToDisableAutoExpandOnCollapse(TreeViewer treeViewer) {
        treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                StagingView.disableAutoExpand(event.getTreeViewer());
            }

            public void treeExpanded(TreeExpansionEvent event) {
            }
        });
    }

    private static void enableAutoExpand(AbstractTreeViewer treeViewer) {
        treeViewer.setAutoExpandLevel(-1);
    }

    private static void disableAutoExpand(AbstractTreeViewer treeViewer) {
        treeViewer.setAutoExpandLevel(0);
    }

    public Repository getCurrentRepository() {
        return this.currentRepository;
    }

    public ShowInContext getShowInContext() {
        if (this.stagedViewer != null && this.stagedViewer.getTree().isFocusControl()) {
            return this.getShowInContext(this.stagedViewer);
        }
        if (this.unstagedViewer != null && this.unstagedViewer.getTree().isFocusControl()) {
            return this.getShowInContext(this.unstagedViewer);
        }
        return null;
    }

    private ShowInContext getShowInContext(TreeViewer treeViewer) {
        IStructuredSelection selection = (IStructuredSelection)treeViewer.getSelection();
        ArrayList<Object> elements = new ArrayList<Object>();
        for (Object selectedElement : selection.toList()) {
            IAdaptable entry;
            if (selectedElement instanceof StagingEntry) {
                entry = (StagingEntry)selectedElement;
                IFile file = entry.getFile();
                if (file != null) {
                    elements.add(file);
                    continue;
                }
                elements.add(entry.getLocation());
                continue;
            }
            if (!(selectedElement instanceof StagingFolderEntry)) continue;
            entry = (StagingFolderEntry)selectedElement;
            IContainer container = entry.getContainer();
            if (container != null) {
                elements.add(container);
                continue;
            }
            elements.add(entry.getLocation());
        }
        return new ShowInContext(null, (ISelection)new StructuredSelection(elements));
    }

    private int getStagingFormOrientation() {
        boolean columnLayout = Activator.getDefault().getPreferenceStore().getBoolean("StagingView_ColumnLayout");
        if (columnLayout) {
            return 256;
        }
        return 512;
    }

    private void enableCommitWidgets(boolean enabled) {
        this.commitMessageText.setEnabled(enabled);
        this.committerText.setEnabled(enabled);
        this.enableAuthorText(enabled);
        this.amendPreviousCommitAction.setEnabled(enabled);
        this.signedOffByAction.setEnabled(enabled);
        this.addChangeIdAction.setEnabled(enabled);
        this.commitButton.setEnabled(enabled);
        this.commitAndPushButton.setEnabled(enabled);
        if (!enabled) {
            this.commitMessageText.setText(EMPTY_STRING);
            this.committerText.setText(EMPTY_STRING);
            this.authorText.setText(EMPTY_STRING);
        }
    }

    private void enableAuthorText(boolean enabled) {
        if (this.currentRepository != null && this.currentRepository.getRepositoryState().equals((Object)RepositoryState.CHERRY_PICKING_RESOLVED)) {
            this.authorText.setEnabled(false);
        } else {
            this.authorText.setEnabled(enabled);
        }
    }

    private void updateToolbar() {
        ControlContribution controlContribution = new ControlContribution("StagingView.searchText"){

            protected Control createControl(Composite parent) {
                Composite toolbarComposite = StagingView.this.toolkit.createComposite(parent, 0);
                toolbarComposite.setBackground(null);
                GridLayout headLayout = new GridLayout();
                headLayout.numColumns = 2;
                headLayout.marginHeight = 0;
                headLayout.marginWidth = 0;
                headLayout.marginTop = 0;
                headLayout.marginBottom = 0;
                headLayout.marginLeft = 0;
                headLayout.marginRight = 0;
                toolbarComposite.setLayout((Layout)headLayout);
                StagingView.this.filterText = new Text(toolbarComposite, 896);
                StagingView.this.filterText.setMessage(UIText.StagingView_Find);
                GridData data = new GridData(768);
                data.widthHint = 150;
                StagingView.this.filterText.setLayoutData((Object)data);
                final Display display = Display.getCurrent();
                StagingView.this.filterText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        final StagingViewSearchThread searchThread = new StagingViewSearchThread(StagingView.this);
                        display.timerExec(200, new Runnable(){

                            public void run() {
                                searchThread.start();
                            }
                        });
                    }
                });
                return toolbarComposite;
            }
        };
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolbar = actionBars.getToolBarManager();
        toolbar.add((IContributionItem)controlContribution);
        this.refreshAction = new Action(UIText.StagingView_Refresh, 1){

            public void run() {
                if (StagingView.this.cacheEntry != null) {
                    StagingView.this.cacheEntry.refreshResourcesAndIndexDiff();
                }
            }
        };
        this.refreshAction.setImageDescriptor(UIIcons.ELCL16_REFRESH);
        toolbar.add((IAction)this.refreshAction);
        BooleanPrefAction linkSelectionAction = new BooleanPrefAction((IPersistentPreferenceStore)this.getPreferenceStore(), "StagingView_SyncWithSelection", UIText.StagingView_LinkSelection){

            public void apply(boolean value) {
                StagingView.this.reactOnSelection = value;
            }
        };
        linkSelectionAction.setImageDescriptor(UIIcons.ELCL16_SYNCED);
        toolbar.add((IAction)linkSelectionAction);
        toolbar.add((IContributionItem)new Separator());
        this.openNewCommitsAction = new Action(UIText.StagingView_OpenNewCommits, 2){

            public void run() {
                StagingView.this.getPreferenceStore().setValue("StagingView_ShowNewCommits", this.isChecked());
            }
        };
        this.openNewCommitsAction.setChecked(this.getPreferenceStore().getBoolean("StagingView_ShowNewCommits"));
        this.columnLayoutAction = new Action(UIText.StagingView_ColumnLayout, 2){

            public void run() {
                StagingView.this.getPreferenceStore().setValue("StagingView_ColumnLayout", this.isChecked());
                StagingView.this.stagingSashForm.setOrientation(this.isChecked() ? 256 : 512);
            }
        };
        this.columnLayoutAction.setChecked(this.getPreferenceStore().getBoolean("StagingView_ColumnLayout"));
        this.fileNameModeAction = new Action(UIText.StagingView_ShowFileNamesFirst, 2){

            public void run() {
                boolean enable = this.isChecked();
                StagingView.this.getLabelProvider((ContentViewer)StagingView.this.stagedViewer).setFileNameMode(enable);
                StagingView.this.getLabelProvider((ContentViewer)StagingView.this.unstagedViewer).setFileNameMode(enable);
                StagingView.this.refreshViewers();
                StagingView.this.getPreferenceStore().setValue("StagingView_FileNameMode", enable);
            }
        };
        this.fileNameModeAction.setChecked(this.getPreferenceStore().getBoolean("StagingView_FileNameMode"));
        IMenuManager dropdownMenu = actionBars.getMenuManager();
        MenuManager presentationMenu = new MenuManager(UIText.StagingView_Presentation);
        this.listPresentationAction = new Action(UIText.StagingView_List, 8){

            public void run() {
                StagingView.this.presentation = Presentation.LIST;
                StagingView.this.getPreferenceStore().setValue("StagingView_Presentation", Presentation.LIST.name());
                StagingView.this.treePresentationAction.setChecked(false);
                StagingView.this.compactTreePresentationAction.setChecked(false);
                StagingView.this.setExpandCollapseActionsVisible(false);
                StagingView.this.refreshViewers();
            }
        };
        this.listPresentationAction.setImageDescriptor(UIIcons.FLAT);
        presentationMenu.add((IAction)this.listPresentationAction);
        this.treePresentationAction = new Action(UIText.StagingView_Tree, 8){

            public void run() {
                StagingView.this.presentation = Presentation.TREE;
                StagingView.this.getPreferenceStore().setValue("StagingView_Presentation", Presentation.TREE.name());
                StagingView.this.listPresentationAction.setChecked(false);
                StagingView.this.compactTreePresentationAction.setChecked(false);
                StagingView.this.setExpandCollapseActionsVisible(true);
                StagingView.this.refreshViewers();
            }
        };
        this.treePresentationAction.setImageDescriptor(UIIcons.HIERARCHY);
        presentationMenu.add((IAction)this.treePresentationAction);
        this.compactTreePresentationAction = new Action(UIText.StagingView_CompactTree, 8){

            public void run() {
                StagingView.this.presentation = Presentation.COMPACT_TREE;
                StagingView.this.getPreferenceStore().setValue("StagingView_Presentation", Presentation.COMPACT_TREE.name());
                StagingView.this.listPresentationAction.setChecked(false);
                StagingView.this.treePresentationAction.setChecked(false);
                StagingView.this.setExpandCollapseActionsVisible(true);
                StagingView.this.refreshViewers();
            }
        };
        this.compactTreePresentationAction.setImageDescriptor(UIIcons.COMPACT);
        presentationMenu.add((IAction)this.compactTreePresentationAction);
        String presentationString = this.getPreferenceStore().getString("StagingView_Presentation");
        if (presentationString.length() > 0) {
            try {
                this.presentation = Presentation.valueOf(presentationString);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        switch (this.presentation) {
            case LIST: {
                this.listPresentationAction.setChecked(true);
                this.setExpandCollapseActionsVisible(false);
                break;
            }
            case TREE: {
                this.treePresentationAction.setChecked(true);
                break;
            }
            case COMPACT_TREE: {
                this.compactTreePresentationAction.setChecked(true);
                break;
            }
        }
        dropdownMenu.add((IContributionItem)presentationMenu);
        dropdownMenu.add((IContributionItem)new Separator());
        dropdownMenu.add((IAction)this.openNewCommitsAction);
        dropdownMenu.add((IAction)this.columnLayoutAction);
        dropdownMenu.add((IAction)this.fileNameModeAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)new GlobalDeleteActionHandler());
        IUndoContext workspaceContext = (IUndoContext)ResourcesPlugin.getWorkspace().getAdapter(IUndoContext.class);
        this.undoRedoActionGroup = new UndoRedoActionGroup((IWorkbenchPartSite)this.getViewSite(), workspaceContext, true);
        this.undoRedoActionGroup.fillActionBars(actionBars);
        actionBars.updateActionBars();
    }

    private void setExpandCollapseActionsVisible(boolean visible) {
        IContributionItem item;
        IContributionItem[] iContributionItemArray = this.unstagedToolBarManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            item = iContributionItemArray[n2];
            item.setVisible(visible);
            ++n2;
        }
        iContributionItemArray = this.stagedToolBarManager.getItems();
        n = iContributionItemArray.length;
        n2 = 0;
        while (n2 < n) {
            item = iContributionItemArray[n2];
            item.setVisible(visible);
            ++n2;
        }
        this.unstagedExpandAllAction.setEnabled(visible);
        this.unstagedCollapseAllAction.setEnabled(visible);
        this.stagedExpandAllAction.setEnabled(visible);
        this.stagedCollapseAllAction.setEnabled(visible);
        this.unstagedToolBarManager.update(true);
        this.stagedToolBarManager.update(true);
    }

    private TreeViewer createTree(Composite composite) {
        Tree tree = this.toolkit.createTree(composite, 65538);
        tree.setLinesVisible(true);
        TreeViewer treeViewer = new TreeViewer(tree);
        return treeViewer;
    }

    private IBaseLabelProvider createLabelProvider(TreeViewer treeViewer) {
        StagingViewLabelProvider baseProvider = new StagingViewLabelProvider(this);
        baseProvider.setFileNameMode(this.getPreferenceStore().getBoolean("StagingView_FileNameMode"));
        ProblemLabelDecorator decorator = new ProblemLabelDecorator((StructuredViewer)treeViewer);
        return new TreeDecoratingLabelProvider((ILabelProvider)baseProvider, decorator);
    }

    private IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    private StagingViewLabelProvider getLabelProvider(ContentViewer viewer) {
        IBaseLabelProvider base = viewer.getLabelProvider();
        ILabelProvider labelProvider = ((TreeDecoratingLabelProvider)base).getLabelProvider();
        return (StagingViewLabelProvider)labelProvider;
    }

    private StagingViewContentProvider getContentProvider(ContentViewer viewer) {
        return (StagingViewContentProvider)viewer.getContentProvider();
    }

    private void updateSectionText() {
        this.stagedSection.setText(MessageFormat.format(UIText.StagingView_StagedChanges, this.getSectionCount(this.stagedViewer)));
        this.unstagedSection.setText(MessageFormat.format(UIText.StagingView_UnstagedChanges, this.getSectionCount(this.unstagedViewer)));
    }

    private String getSectionCount(TreeViewer viewer) {
        StagingViewContentProvider contentProvider = this.getContentProvider((ContentViewer)viewer);
        int count = contentProvider.getCount();
        int shownCount = contentProvider.getShownCount();
        if (shownCount == count) {
            return Integer.toString(count);
        }
        return String.valueOf(shownCount) + "/" + count;
    }

    private void updateMessage() {
        String message = this.commitMessageComponent.getStatus().getMessage();
        boolean needsRedraw = false;
        if (message != null) {
            this.warningLabel.showMessage(message);
            needsRedraw = true;
        } else {
            needsRedraw = this.warningLabel.getVisible();
            this.warningLabel.hideMessage();
        }
        if (needsRedraw) {
            this.commitMessageSection.redraw();
        }
    }

    private void compareWith(OpenEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.isEmpty() || !(selection.getFirstElement() instanceof StagingEntry)) {
            return;
        }
        StagingEntry stagingEntry = (StagingEntry)selection.getFirstElement();
        if (stagingEntry.isSubmodule()) {
            return;
        }
        switch (stagingEntry.getState()) {
            case ADDED: 
            case CHANGED: 
            case REMOVED: {
                CommonUtils.runCommand("org.eclipse.egit.ui.team.CompareIndexWithHead", selection);
                break;
            }
            default: {
                CommonUtils.runCommand("org.eclipse.egit.ui.team.CompareWithIndex", selection);
            }
        }
    }

    private void createPopupMenu(final TreeViewer treeViewer) {
        final MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        Control control = treeViewer.getControl();
        control.setMenu(menuMgr.createContextMenu(control));
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                final IStructuredSelection selection = (IStructuredSelection)treeViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                ArrayList<StagingEntry> stagingEntryList = new ArrayList<StagingEntry>();
                boolean submoduleSelected = false;
                boolean folderSelected = false;
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof StagingFolderEntry) {
                        StagingFolderEntry folder = (StagingFolderEntry)element;
                        folderSelected = true;
                        StagingViewContentProvider contentProvider = StagingView.this.getContentProvider((ContentViewer)treeViewer);
                        List<StagingEntry> stagingEntries = contentProvider.getStagingEntriesFiltered(folder);
                        for (StagingEntry stagingEntry : stagingEntries) {
                            if (stagingEntryList.contains(stagingEntry)) continue;
                            stagingEntryList.add(stagingEntry);
                        }
                    } else if (element instanceof StagingEntry) {
                        StagingEntry entry = (StagingEntry)element;
                        if (entry.isSubmodule()) {
                            submoduleSelected = true;
                        }
                        if (!stagingEntryList.contains(entry)) {
                            stagingEntryList.add(entry);
                        }
                    }
                    ++n2;
                }
                StructuredSelection fileSelection = new StructuredSelection(stagingEntryList);
                if (!folderSelected) {
                    Action openWorkingTreeVersion = new Action(UIText.CommitFileDiffViewer_OpenWorkingTreeVersionInEditorMenuLabel, (IStructuredSelection)fileSelection){
                        private final /* synthetic */ IStructuredSelection val$fileSelection;
                        {
                            this.val$fileSelection = iStructuredSelection;
                            super($anonymous0);
                        }

                        public void run() {
                            StagingView.this.openSelectionInEditor((ISelection)this.val$fileSelection);
                        }
                    };
                    openWorkingTreeVersion.setEnabled(!submoduleSelected);
                    menuMgr.add((IAction)openWorkingTreeVersion);
                }
                Set availableActions = StagingView.getAvailableActions((IStructuredSelection)fileSelection);
                boolean addReplaceWithFileInGitIndex = availableActions.contains((Object)StagingEntry.Action.REPLACE_WITH_FILE_IN_GIT_INDEX);
                boolean addReplaceWithHeadRevision = availableActions.contains((Object)StagingEntry.Action.REPLACE_WITH_HEAD_REVISION);
                boolean addStage = availableActions.contains((Object)StagingEntry.Action.STAGE);
                boolean addUnstage = availableActions.contains((Object)StagingEntry.Action.UNSTAGE);
                boolean addDelete = availableActions.contains((Object)StagingEntry.Action.DELETE);
                boolean addIgnore = availableActions.contains((Object)StagingEntry.Action.IGNORE);
                boolean addLaunchMergeTool = availableActions.contains((Object)StagingEntry.Action.LAUNCH_MERGE_TOOL);
                if (addStage) {
                    menuMgr.add((IAction)new Action(UIText.StagingView_StageItemMenuLabel){

                        public void run() {
                            StagingView.this.stage(selection);
                        }
                    });
                }
                if (addUnstage) {
                    menuMgr.add((IAction)new Action(UIText.StagingView_UnstageItemMenuLabel){

                        public void run() {
                            StagingView.this.unstage(selection);
                        }
                    });
                }
                boolean selectionIncludesNonWorkspaceResources = StagingView.this.selectionIncludesNonWorkspaceResources((ISelection)fileSelection);
                if (addReplaceWithFileInGitIndex) {
                    if (selectionIncludesNonWorkspaceResources) {
                        menuMgr.add((IAction)new ReplaceAction(UIText.StagingView_replaceWithFileInGitIndex, (IStructuredSelection)fileSelection, false));
                    } else {
                        menuMgr.add(StagingView.this.createItem(UIText.StagingView_replaceWithFileInGitIndex, "org.eclipse.egit.ui.team.Discard", (IStructuredSelection)fileSelection));
                    }
                }
                if (addReplaceWithHeadRevision) {
                    if (selectionIncludesNonWorkspaceResources) {
                        menuMgr.add((IAction)new ReplaceAction(UIText.StagingView_replaceWithHeadRevision, (IStructuredSelection)fileSelection, true));
                    } else {
                        menuMgr.add(StagingView.this.createItem(UIText.StagingView_replaceWithHeadRevision, "org.eclipse.egit.ui.team.ReplaceWithHead", (IStructuredSelection)fileSelection));
                    }
                }
                if (addIgnore) {
                    menuMgr.add((IAction)new IgnoreAction((IStructuredSelection)fileSelection));
                }
                if (addDelete) {
                    menuMgr.add((IAction)new DeleteAction((IStructuredSelection)fileSelection));
                }
                if (addLaunchMergeTool) {
                    menuMgr.add(StagingView.this.createItem(UIText.StagingView_MergeTool, "org.eclipse.egit.ui.team.MergeTool", (IStructuredSelection)fileSelection));
                }
                menuMgr.add((IContributionItem)new Separator());
                menuMgr.add(StagingView.this.createShowInMenu());
            }
        });
    }

    Presentation getPresentation() {
        return this.presentation;
    }

    String getFilterString() {
        if (this.filterText != null) {
            return this.filterText.getText().trim();
        }
        return EMPTY_STRING;
    }

    public void refreshViewers() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Object[] unstagedExpanded = StagingView.this.unstagedViewer.getExpandedElements();
                Object[] stagedExpanded = StagingView.this.stagedViewer.getExpandedElements();
                StagingView.this.unstagedViewer.refresh();
                StagingView.this.stagedViewer.refresh();
                StagingView.this.updateSectionText();
                StagingView.this.unstagedViewer.setExpandedElements(unstagedExpanded);
                StagingView.this.stagedViewer.setExpandedElements(stagedExpanded);
            }
        });
    }

    private IContributionItem createShowInMenu() {
        IWorkbenchWindow workbenchWindow = this.getSite().getWorkbenchWindow();
        return UIUtils.createShowInMenu(workbenchWindow);
    }

    private void replaceWith(String[] files, boolean headRevision) {
        if (files == null || files.length == 0) {
            return;
        }
        CheckoutCommand checkoutCommand = new Git(this.currentRepository).checkout();
        if (headRevision) {
            checkoutCommand.setStartPoint("HEAD");
        }
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            checkoutCommand.addPath(path);
            ++n2;
        }
        try {
            checkoutCommand.call();
        }
        catch (Exception e) {
            Activator.handleError(UIText.StagingView_checkoutFailed, e, true);
        }
    }

    private String[] getSelectedFiles(IStructuredSelection selection) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object selectedItem : selection) {
            if (!(selectedItem instanceof StagingEntry)) continue;
            StagingEntry stagingEntry = (StagingEntry)selectedItem;
            result.add(stagingEntry.getPath());
        }
        return result.toArray(new String[result.size()]);
    }

    private static List<IPath> getSelectedPaths(IStructuredSelection selection) {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        for (StagingEntry stagingEntry : selection) {
            paths.add(stagingEntry.getLocation());
        }
        return paths;
    }

    private boolean selectionIncludesNonWorkspaceResources(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        for (Object selectedObject : structuredSelection) {
            if (!(selectedObject instanceof StagingEntry)) {
                return false;
            }
            StagingEntry stagingEntry = (StagingEntry)selectedObject;
            IFile file = stagingEntry.getFile();
            if (file != null) continue;
            return true;
        }
        return false;
    }

    private void openSelectionInEditor(ISelection s) {
        if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iss = (IStructuredSelection)s;
        for (Object element : iss.toList()) {
            if (!(element instanceof StagingEntry)) continue;
            StagingEntry entry = (StagingEntry)element;
            String relativePath = entry.getPath();
            String path = new Path(this.currentRepository.getWorkTree().getAbsolutePath()).append(relativePath).toOSString();
            this.openFileInEditor(path);
        }
    }

    private void openFileInEditor(String filePath) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        File file = new File(filePath);
        if (!file.exists()) {
            String message = NLS.bind((String)UIText.CommitFileDiffViewer_FileDoesNotExist, (Object)filePath);
            Activator.showError(message, null);
        }
        IWorkbenchPage page = window.getActivePage();
        EgitUiEditorUtils.openEditor(file, page);
    }

    private static Set<StagingEntry.Action> getAvailableActions(IStructuredSelection selection) {
        EnumSet<StagingEntry.Action> availableActions = EnumSet.noneOf(StagingEntry.Action.class);
        for (StagingEntry stagingEntry : selection) {
            if (availableActions.isEmpty()) {
                availableActions.addAll(stagingEntry.getAvailableActions());
                continue;
            }
            availableActions.retainAll(stagingEntry.getAvailableActions());
        }
        return availableActions;
    }

    private IAction createItem(String text, final String commandId, final IStructuredSelection selection) {
        return new Action(text){

            public void run() {
                CommonUtils.runCommand(commandId, selection);
            }
        };
    }

    private void reactOnSelection(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            IResource adapted;
            StructuredSelection ssel = (StructuredSelection)selection;
            if (ssel.size() != 1) {
                return;
            }
            Object firstElement = ssel.getFirstElement();
            if (firstElement instanceof IResource) {
                this.showResource((IResource)firstElement);
            } else if (firstElement instanceof RepositoryTreeNode) {
                RepositoryTreeNode repoNode = (RepositoryTreeNode)firstElement;
                this.reload(repoNode.getRepository());
            } else if (firstElement instanceof IAdaptable && (adapted = (IResource)((IAdaptable)firstElement).getAdapter(IResource.class)) != null) {
                this.showResource(adapted);
            }
        }
    }

    private void showResource(IResource resource) {
        IProject project = resource.getProject();
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)project);
        if (mapping == null) {
            return;
        }
        if (mapping.getRepository() != this.currentRepository) {
            this.reload(mapping.getRepository());
        }
    }

    private void stage(IStructuredSelection selection) {
        StagingViewContentProvider contentProvider = this.getContentProvider((ContentViewer)this.unstagedViewer);
        Git git = new Git(this.currentRepository);
        Iterator iterator = selection.iterator();
        ArrayList<String> addPaths = new ArrayList<String>();
        ArrayList<String> rmPaths = new ArrayList<String>();
        this.resetPathsToExpand();
        while (iterator.hasNext()) {
            RepositoryMapping mapping;
            Object element = iterator.next();
            if (element instanceof StagingEntry) {
                StagingEntry entry = (StagingEntry)element;
                this.selectEntryForStaging(entry, addPaths, rmPaths);
                StagingView.addPathAndParentPaths(entry.getParentPath(), this.pathsToExpandInStaged);
                continue;
            }
            if (element instanceof StagingFolderEntry) {
                StagingFolderEntry folder = (StagingFolderEntry)element;
                List<StagingEntry> entries = contentProvider.getStagingEntriesFiltered(folder);
                for (StagingEntry entry : entries) {
                    this.selectEntryForStaging(entry, addPaths, rmPaths);
                }
                StagingView.addExpandedPathsBelowFolder(folder, this.unstagedViewer, this.pathsToExpandInStaged);
                continue;
            }
            IResource resource = (IResource)AdapterUtils.adapt(element, IResource.class);
            if (resource == null || (mapping = RepositoryMapping.getMapping((IResource)resource)) == null || mapping.getRepository() != this.currentRepository) continue;
            String path = mapping.getRepoRelativePath(resource);
            if (EMPTY_STRING.equals(path)) {
                addPaths.add(".");
                continue;
            }
            addPaths.add(path);
        }
        if (!addPaths.isEmpty()) {
            try {
                AddCommand add = git.add();
                for (String addPath : addPaths) {
                    add.addFilepattern(addPath);
                }
                add.call();
            }
            catch (NoFilepatternException noFilepatternException) {
            }
            catch (JGitInternalException e1) {
                Activator.handleError(e1.getCause().getMessage(), e1.getCause(), true);
            }
            catch (Exception e1) {
                Activator.handleError(e1.getMessage(), e1, true);
            }
        }
        if (!rmPaths.isEmpty()) {
            try {
                RmCommand rm = git.rm().setCached(true);
                for (String rmPath : rmPaths) {
                    rm.addFilepattern(rmPath);
                }
                rm.call();
            }
            catch (NoFilepatternException noFilepatternException) {
            }
            catch (JGitInternalException e) {
                Activator.handleError(e.getCause().getMessage(), e.getCause(), true);
            }
            catch (Exception e) {
                Activator.handleError(e.getMessage(), e, true);
            }
        }
    }

    private void selectEntryForStaging(StagingEntry entry, List<String> addPaths, List<String> rmPaths) {
        switch (entry.getState()) {
            case ADDED: 
            case CHANGED: 
            case REMOVED: {
                break;
            }
            case MODIFIED: 
            case PARTIALLY_MODIFIED: 
            case UNTRACKED: 
            case CONFLICTING: {
                addPaths.add(entry.getPath());
                break;
            }
            case MISSING: 
            case MISSING_AND_CHANGED: {
                rmPaths.add(entry.getPath());
            }
        }
    }

    private void unstage(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        List<String> paths = this.processUnstageSelection(selection);
        if (paths.isEmpty()) {
            return;
        }
        try {
            Git git = new Git(this.currentRepository);
            ResetCommand reset = git.reset();
            for (String path : paths) {
                reset.addPath(path);
            }
            reset.call();
        }
        catch (GitAPIException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
    }

    private List<String> processUnstageSelection(IStructuredSelection selection) {
        ArrayList<String> paths = new ArrayList<String>();
        this.resetPathsToExpand();
        for (Object element : selection.toList()) {
            if (element instanceof StagingEntry) {
                StagingEntry entry = (StagingEntry)element;
                this.addUnstagePath(entry, paths);
                StagingView.addPathAndParentPaths(entry.getParentPath(), this.pathsToExpandInUnstaged);
                continue;
            }
            if (!(element instanceof StagingFolderEntry)) continue;
            StagingFolderEntry folder = (StagingFolderEntry)element;
            List<StagingEntry> entries = this.getContentProvider((ContentViewer)this.stagedViewer).getStagingEntriesFiltered(folder);
            for (StagingEntry entry : entries) {
                this.addUnstagePath(entry, paths);
            }
            StagingView.addExpandedPathsBelowFolder(folder, this.stagedViewer, this.pathsToExpandInUnstaged);
        }
        return paths;
    }

    private void addUnstagePath(StagingEntry entry, List<String> paths) {
        switch (entry.getState()) {
            case ADDED: 
            case CHANGED: 
            case REMOVED: {
                paths.add(entry.getPath());
                return;
            }
        }
    }

    private void resetPathsToExpand() {
        this.pathsToExpandInStaged = new HashSet<IPath>();
        this.pathsToExpandInUnstaged = new HashSet<IPath>();
    }

    private static void addExpandedPathsBelowFolder(StagingFolderEntry folder, TreeViewer treeViewer, Set<IPath> addToSet) {
        Object[] expandedElements;
        Object[] objectArray = expandedElements = treeViewer.getExpandedElements();
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object expandedElement = objectArray[n2];
            if (expandedElement instanceof StagingFolderEntry) {
                StagingFolderEntry expandedFolder = (StagingFolderEntry)expandedElement;
                if (folder.getPath().isPrefixOf(expandedFolder.getPath())) {
                    StagingView.addPathAndParentPaths(expandedFolder.getPath(), addToSet);
                }
            }
            ++n2;
        }
    }

    private static void addPathAndParentPaths(IPath initialPath, Set<IPath> addToSet) {
        IPath p = initialPath;
        while (p.segmentCount() >= 1) {
            addToSet.add(p);
            p = p.removeLastSegments(1);
        }
    }

    private boolean isValidRepo(Repository repository) {
        return repository != null && !repository.isBare() && repository.getWorkTree().exists() && org.eclipse.egit.core.Activator.getDefault().getRepositoryUtil().contains(repository);
    }

    private void clearRepository() {
        this.saveCommitMessageComponentState();
        this.currentRepository = null;
        StagingViewUpdate update = new StagingViewUpdate(null, null, null);
        this.unstagedViewer.setInput((Object)update);
        this.stagedViewer.setInput((Object)update);
        this.enableCommitWidgets(false);
        this.refreshAction.setEnabled(false);
        this.updateSectionText();
        this.form.setText(UIText.StagingView_NoSelectionTitle);
    }

    protected void updateRebaseButtonVisibility(final boolean isRebasing) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                StagingView.showControl((Control)StagingView.this.rebaseSection, isRebasing);
                StagingView.this.rebaseSection.getParent().layout(true);
            }
        });
    }

    private static void showControl(Control c, boolean show) {
        c.setVisible(show);
        GridData g = (GridData)c.getLayoutData();
        g.exclude = !show;
    }

    public void setAmending(boolean isAmending) {
        if (this.amendPreviousCommitAction.isChecked() != isAmending) {
            this.amendPreviousCommitAction.setChecked(isAmending);
            this.amendPreviousCommitAction.run();
        }
    }

    public void reload(final Repository repository) {
        if (this.form.isDisposed()) {
            return;
        }
        if (repository == null) {
            this.asyncExec(new Runnable(){

                public void run() {
                    StagingView.this.clearRepository();
                }
            });
            return;
        }
        if (!this.isValidRepo(repository)) {
            return;
        }
        final boolean repositoryChanged = this.currentRepository != repository;
        this.asyncExec(new Runnable(){

            public void run() {
                boolean indexDiffAvailable;
                if (StagingView.this.form.isDisposed()) {
                    return;
                }
                IndexDiffData indexDiff = StagingView.this.doReload(repository);
                boolean bl = indexDiffAvailable = indexDiff != null;
                if (repositoryChanged) {
                    StagingView.this.resetPathsToExpand();
                    if (StagingView.this.refsChangedListener != null) {
                        StagingView.this.refsChangedListener.remove();
                    }
                    StagingView.this.refsChangedListener = repository.getListenerList().addRefsChangedListener(new RefsChangedListener(){

                        public void onRefsChanged(RefsChangedEvent event) {
                            StagingView.this.updateRebaseButtonVisibility(repository.getRepositoryState().isRebasing());
                        }
                    });
                }
                StagingViewUpdate update = new StagingViewUpdate(StagingView.this.currentRepository, indexDiff, null);
                Object[] unstagedExpanded = StagingView.this.unstagedViewer.getExpandedElements();
                Object[] stagedExpanded = StagingView.this.stagedViewer.getExpandedElements();
                StagingView.this.unstagedViewer.setInput((Object)update);
                StagingView.this.stagedViewer.setInput((Object)update);
                StagingView.this.expandPreviousExpandedAndPaths(unstagedExpanded, StagingView.this.unstagedViewer, StagingView.this.pathsToExpandInUnstaged);
                StagingView.this.expandPreviousExpandedAndPaths(stagedExpanded, StagingView.this.stagedViewer, StagingView.this.pathsToExpandInStaged);
                StagingView.this.refreshAction.setEnabled(true);
                StagingView.this.updateRebaseButtonVisibility(repository.getRepositoryState().isRebasing());
                boolean commitEnabled = indexDiffAvailable && repository.getRepositoryState().canCommit() && indexDiff.getConflicting().isEmpty();
                StagingView.this.commitButton.setEnabled(commitEnabled);
                boolean commitAndPushEnabled = commitEnabled && !repository.getRepositoryState().isRebasing();
                StagingView.this.commitAndPushButton.setEnabled(commitAndPushEnabled);
                boolean rebaseContinueEnabled = indexDiffAvailable && repository.getRepositoryState().isRebasing() && indexDiff.getConflicting().isEmpty();
                StagingView.this.rebaseContinueButton.setEnabled(rebaseContinueEnabled);
                StagingView.this.form.setText(StagingView.getRepositoryName(repository));
                StagingView.this.updateCommitMessageComponent(repositoryChanged, indexDiffAvailable);
                StagingView.this.enableCommitWidgets(indexDiffAvailable && indexDiff.getConflicting().isEmpty());
                StagingView.this.updateSectionText();
            }
        });
    }

    private IndexDiffData doReload(Repository repository) {
        this.currentRepository = repository;
        IndexDiffCacheEntry entry = org.eclipse.egit.core.Activator.getDefault().getIndexDiffCache().getIndexDiffCacheEntry(this.currentRepository);
        if (this.cacheEntry != null && this.cacheEntry != entry) {
            this.cacheEntry.removeIndexDiffChangedListener(this.myIndexDiffListener);
        }
        this.cacheEntry = entry;
        this.cacheEntry.addIndexDiffChangedListener(this.myIndexDiffListener);
        return this.cacheEntry.getIndexDiff();
    }

    private void expandPreviousExpandedAndPaths(Object[] previous, TreeViewer viewer, Set<IPath> additionalPaths) {
        if (viewer.getAutoExpandLevel() == -1) {
            return;
        }
        HashSet<IPath> paths = new HashSet<IPath>(additionalPaths);
        Object[] objectArray = previous;
        int n = previous.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof StagingFolderEntry) {
                StagingView.addPathAndParentPaths(((StagingFolderEntry)element).getPath(), paths);
            }
            ++n2;
        }
        ArrayList<StagingFolderEntry> expand = new ArrayList<StagingFolderEntry>();
        StagingViewContentProvider stagedContentProvider = this.getContentProvider((ContentViewer)viewer);
        StagingFolderEntry[] stagingFolderEntryArray = stagedContentProvider.getStagingFolderEntries();
        int n3 = stagingFolderEntryArray.length;
        int n4 = 0;
        while (n4 < n3) {
            StagingFolderEntry folder = stagingFolderEntryArray[n4];
            if (paths.contains(folder.getPath())) {
                expand.add(folder);
            }
            ++n4;
        }
        viewer.setExpandedElements(expand.toArray());
    }

    private void clearCommitMessageToggles() {
        this.amendPreviousCommitAction.setChecked(false);
        this.addChangeIdAction.setChecked(false);
        this.signedOffByAction.setChecked(false);
    }

    void updateCommitMessageComponent(boolean repositoryChanged, boolean indexDiffAvailable) {
        CommitHelper helper = new CommitHelper(this.currentRepository);
        CommitMessageComponentState oldState = null;
        if (repositoryChanged) {
            if (this.userEnteredCommmitMessage()) {
                this.saveCommitMessageComponentState();
            } else {
                this.deleteCommitMessageComponentState();
            }
            oldState = this.loadCommitMessageComponentState();
            this.commitMessageComponent.setRepository(this.currentRepository);
            if (oldState == null) {
                this.loadInitialState(helper);
            } else {
                this.loadExistingState(helper, oldState);
            }
        } else if (this.userEnteredCommmitMessage()) {
            if (!this.commitMessageComponent.getHeadCommit().equals((AnyObjectId)helper.getPreviousCommit())) {
                this.addHeadChangedWarning(this.commitMessageComponent.getCommitMessage());
            }
        } else {
            this.loadInitialState(helper);
        }
        this.amendPreviousCommitAction.setChecked(this.commitMessageComponent.isAmending());
        this.amendPreviousCommitAction.setEnabled(indexDiffAvailable && helper.amendAllowed());
        this.updateMessage();
    }

    private void loadExistingState(CommitHelper helper, CommitMessageComponentState oldState) {
        boolean headCommitChanged = !oldState.getHeadCommit().equals((AnyObjectId)this.getCommitId(helper.getPreviousCommit()));
        this.commitMessageComponent.enableListeners(false);
        this.commitMessageComponent.setAuthor(oldState.getAuthor());
        if (headCommitChanged) {
            this.addHeadChangedWarning(oldState.getCommitMessage());
        } else {
            this.commitMessageComponent.setCommitMessage(oldState.getCommitMessage());
        }
        this.commitMessageComponent.setCommitter(oldState.getCommitter());
        this.commitMessageComponent.setHeadCommit(this.getCommitId(helper.getPreviousCommit()));
        this.commitMessageComponent.setCommitAllowed(helper.canCommit());
        this.commitMessageComponent.setCannotCommitMessage(helper.getCannotCommitMessage());
        boolean amendAllowed = helper.amendAllowed();
        this.commitMessageComponent.setAmendAllowed(amendAllowed);
        if (!amendAllowed) {
            this.commitMessageComponent.setAmending(false);
        } else if (!headCommitChanged && oldState.getAmend()) {
            this.commitMessageComponent.setAmending(true);
        } else {
            this.commitMessageComponent.setAmending(false);
        }
        this.commitMessageComponent.updateUIFromState();
        this.commitMessageComponent.updateSignedOffAndChangeIdButton();
        this.commitMessageComponent.enableListeners(true);
    }

    private void addHeadChangedWarning(String commitMessage) {
        if (!commitMessage.startsWith(UIText.StagingView_headCommitChanged)) {
            String message = String.valueOf(UIText.StagingView_headCommitChanged) + Text.DELIMITER + Text.DELIMITER + commitMessage;
            this.commitMessageComponent.setCommitMessage(message);
        }
    }

    private void loadInitialState(CommitHelper helper) {
        this.commitMessageComponent.enableListeners(false);
        this.commitMessageComponent.resetState();
        this.commitMessageComponent.setAuthor(helper.getAuthor());
        this.commitMessageComponent.setCommitMessage(helper.getCommitMessage());
        this.commitMessageComponent.setCommitter(helper.getCommitter());
        this.commitMessageComponent.setHeadCommit(this.getCommitId(helper.getPreviousCommit()));
        this.commitMessageComponent.setCommitAllowed(helper.canCommit());
        this.commitMessageComponent.setCannotCommitMessage(helper.getCannotCommitMessage());
        this.commitMessageComponent.setAmendAllowed(helper.amendAllowed());
        this.commitMessageComponent.setAmending(false);
        this.commitMessageComponent.setDefaults();
        this.commitMessageComponent.updateUI();
        this.commitMessageComponent.enableListeners(true);
    }

    private boolean userEnteredCommmitMessage() {
        if (this.commitMessageComponent.getRepository() == null) {
            return false;
        }
        String message = this.commitMessageComponent.getCommitMessage().replace(UIText.StagingView_headCommitChanged, EMPTY_STRING);
        if (message == null || message.trim().length() == 0) {
            return false;
        }
        String chIdLine = "Change-Id: I" + ObjectId.zeroId().name();
        if (GerritUtil.getCreateChangeId((Config)this.currentRepository.getConfig()) && this.commitMessageComponent.getCreateChangeId()) {
            if (message.trim().equals(chIdLine)) {
                return false;
            }
            message = message.replace(chIdLine, EMPTY_STRING);
        }
        return !Activator.getDefault().getPreferenceStore().getBoolean("commit_dialog_signed_off_by") || !this.commitMessageComponent.isSignedOff() || !message.trim().equals("Signed-off-by: " + this.commitMessageComponent.getCommitter());
    }

    private ObjectId getCommitId(RevCommit commit) {
        if (commit == null) {
            return ObjectId.zeroId();
        }
        return commit.getId();
    }

    private void saveCommitMessageComponentState() {
        Repository repo = this.commitMessageComponent.getRepository();
        if (repo != null) {
            CommitMessageComponentStateManager.persistState(repo, this.commitMessageComponent.getState());
        }
    }

    private void deleteCommitMessageComponentState() {
        if (this.commitMessageComponent.getRepository() != null) {
            CommitMessageComponentStateManager.deleteState(this.commitMessageComponent.getRepository());
        }
    }

    private CommitMessageComponentState loadCommitMessageComponentState() {
        return CommitMessageComponentStateManager.loadState(this.currentRepository);
    }

    private static String getRepositoryName(Repository repository) {
        String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(repository);
        RepositoryState state = repository.getRepositoryState();
        if (state != RepositoryState.SAFE) {
            return String.valueOf(repoName) + '|' + state.getDescription();
        }
        return repoName;
    }

    private Collection<String> getStagedFileNames() {
        StagingViewContentProvider stagedContentProvider = this.getContentProvider((ContentViewer)this.stagedViewer);
        StagingEntry[] entries = stagedContentProvider.getStagingEntries();
        ArrayList<String> files = new ArrayList<String>();
        StagingEntry[] stagingEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            StagingEntry entry = stagingEntryArray[n2];
            files.add(entry.getPath());
            ++n2;
        }
        return files;
    }

    private void commit(boolean pushUpstream) {
        if (!this.isCommitWithoutFilesAllowed()) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)UIText.StagingView_committingNotPossible, (String)UIText.StagingView_noStagedFiles);
            return;
        }
        if (!this.commitMessageComponent.checkCommitInfo()) {
            return;
        }
        if (!UIUtils.saveAllEditors(this.currentRepository)) {
            return;
        }
        String commitMessage = this.commitMessageComponent.getCommitMessage();
        CommitOperation commitOperation = null;
        try {
            commitOperation = new CommitOperation(this.currentRepository, this.commitMessageComponent.getAuthor(), this.commitMessageComponent.getCommitter(), commitMessage);
        }
        catch (CoreException e) {
            Activator.handleError(UIText.StagingView_commitFailed, e, true);
            return;
        }
        if (this.amendPreviousCommitAction.isChecked()) {
            commitOperation.setAmending(true);
        }
        commitOperation.setComputeChangeId(this.addChangeIdAction.isChecked());
        CommitJob commitJob = new CommitJob(this.currentRepository, commitOperation).setOpenCommitEditor(this.openNewCommitsAction.isChecked()).setPushUpstream(pushUpstream);
        commitJob.schedule();
        CommitMessageHistory.saveCommitHistory(commitMessage);
        this.clearCommitMessageToggles();
        this.commitMessageText.setText(EMPTY_STRING);
    }

    private boolean isCommitWithoutFilesAllowed() {
        if (this.stagedViewer.getTree().getItemCount() > 0) {
            return true;
        }
        if (this.amendPreviousCommitAction.isChecked()) {
            return true;
        }
        return CommitHelper.isCommitWithoutFilesAllowed(this.currentRepository);
    }

    public void setFocus() {
        this.unstagedViewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        ISelectionService srv = (ISelectionService)this.getSite().getService(ISelectionService.class);
        srv.removePostSelectionListener(this.selectionChangedListener);
        if (this.cacheEntry != null) {
            this.cacheEntry.removeIndexDiffChangedListener(this.myIndexDiffListener);
        }
        if (this.undoRedoActionGroup != null) {
            this.undoRedoActionGroup.dispose();
        }
        InstanceScope.INSTANCE.getNode(org.eclipse.egit.core.Activator.getPluginId()).removePreferenceChangeListener(this.prefListener);
        if (this.refsChangedListener != null) {
            this.refsChangedListener.remove();
        }
    }

    private void asyncExec(Runnable runnable) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
    }

    private class DeleteAction
    extends Action {
        private final IStructuredSelection selection;

        DeleteAction(IStructuredSelection selection) {
            super(UIText.StagingView_DeleteItemMenuLabel);
            this.selection = selection;
        }

        public void run() {
            DeletePathsOperationUI operation = new DeletePathsOperationUI(StagingView.getSelectedPaths(this.selection), (IShellProvider)StagingView.this.getSite());
            operation.run();
        }
    }

    private class GlobalDeleteActionHandler
    extends Action {
        private GlobalDeleteActionHandler() {
        }

        public void run() {
            DeletePathsOperationUI operation = new DeletePathsOperationUI(StagingView.getSelectedPaths(this.getSelection()), (IShellProvider)StagingView.this.getSite());
            operation.run();
        }

        public boolean isEnabled() {
            if (!StagingView.this.unstagedViewer.getTree().isFocusControl()) {
                return false;
            }
            IStructuredSelection selection = this.getSelection();
            if (selection.isEmpty()) {
                return false;
            }
            for (Object element : selection.toList()) {
                if (!(element instanceof StagingEntry)) {
                    return false;
                }
                StagingEntry entry = (StagingEntry)element;
                if (entry.getAvailableActions().contains((Object)StagingEntry.Action.DELETE)) continue;
                return false;
            }
            return true;
        }

        private IStructuredSelection getSelection() {
            return (IStructuredSelection)StagingView.this.unstagedViewer.getSelection();
        }
    }

    private static class IgnoreAction
    extends Action {
        private final IStructuredSelection selection;

        IgnoreAction(IStructuredSelection selection) {
            super(UIText.StagingView_IgnoreItemMenuLabel);
            this.selection = selection;
        }

        public void run() {
            IgnoreOperationUI operation = new IgnoreOperationUI(StagingView.getSelectedPaths(this.selection));
            operation.run();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Presentation {
        LIST,
        TREE,
        COMPACT_TREE;

    }

    private class ReplaceAction
    extends Action {
        IStructuredSelection selection;
        private final boolean headRevision;

        ReplaceAction(String text, IStructuredSelection selection, boolean headRevision) {
            super(text);
            this.selection = selection;
            this.headRevision = headRevision;
        }

        public void run() {
            boolean performAction = MessageDialog.openConfirm((Shell)StagingView.this.form.getShell(), (String)UIText.DiscardChangesAction_confirmActionTitle, (String)UIText.DiscardChangesAction_confirmActionMessage);
            if (!performAction) {
                return;
            }
            String[] files = StagingView.this.getSelectedFiles(this.selection);
            StagingView.this.replaceWith(files, this.headRevision);
        }
    }

    static class StagingDragListener
    extends DragSourceAdapter {
        private ISelectionProvider provider;

        public StagingDragListener(ISelectionProvider provider) {
            this.provider = provider;
        }

        public void dragStart(DragSourceEvent event) {
            event.doit = !this.provider.getSelection().isEmpty();
        }

        public void dragFinished(DragSourceEvent event) {
            if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }
        }

        public void dragSetData(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.provider.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                LocalSelectionTransfer.getTransfer().setSelection((ISelection)selection);
                return;
            }
            if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                ArrayList<String> files = new ArrayList<String>();
                for (Object selected : selection.toList()) {
                    StagingEntry entry;
                    File file;
                    if (!(selected instanceof StagingEntry) || !(file = new File((entry = (StagingEntry)selected).getRepository().getWorkTree(), entry.getPath())).exists()) continue;
                    files.add(file.getAbsolutePath());
                }
                if (!files.isEmpty()) {
                    event.data = files.toArray(new String[files.size()]);
                    return;
                }
            }
        }
    }

    static class StagingViewSearchThread
    extends Thread {
        private StagingView stagingView;
        private static final Object lock = new Object();
        private static volatile int globalThreadIndex = 0;
        private int currentThreadIx;

        public StagingViewSearchThread(StagingView stagingView) {
            super("staging_view_filter_thread" + ++globalThreadIndex);
            this.stagingView = stagingView;
            this.currentThreadIx = globalThreadIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = lock;
            synchronized (object) {
                if (this.currentThreadIx < globalThreadIndex) {
                    return;
                }
                this.stagingView.refreshViewers();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StagingViewUpdate {
        Repository repository;
        IndexDiffData indexDiff;
        Collection<String> changedResources;

        StagingViewUpdate(Repository theRepository, IndexDiffData theIndexDiff, Collection<String> theChanges) {
            this.repository = theRepository;
            this.indexDiff = theIndexDiff;
            this.changedResources = theChanges;
        }
    }

    static class TreeDecoratingLabelProvider
    extends DecoratingLabelProvider {
        ILabelProvider provider;
        ILabelDecorator decorator;

        public TreeDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            super(provider, decorator);
            this.provider = provider;
            this.decorator = decorator;
        }

        public Image getColumnImage(Object element) {
            Image decorated;
            Image image = this.provider.getImage(element);
            if (image != null && this.decorator != null && (decorated = this.decorator.decorateImage(image, element)) != null) {
                return decorated;
            }
            return image;
        }

        public String getText(Object element) {
            return this.provider.getText(element);
        }
    }
}

