/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.model.common.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.model.common.CommonPackage;
import org.eclipse.buckminster.model.common.Split;
import org.eclipse.buckminster.model.common.SplitType;
import org.eclipse.buckminster.model.common.impl.ValueFilterImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class SplitImpl
extends ValueFilterImpl
implements Split {
    protected static final int LIMIT_EDEFAULT = 0;
    protected int limit = 0;
    protected static final String PATTERN_EDEFAULT = null;
    protected String pattern = PATTERN_EDEFAULT;
    protected static final SplitType STYLE_EDEFAULT = SplitType.UNQUOTED;
    protected SplitType style = STYLE_EDEFAULT;
    protected boolean styleESet;
    protected static final Pattern COMPILED_PATTERN_EDEFAULT = null;
    protected Pattern compiledPattern = COMPILED_PATTERN_EDEFAULT;

    protected SplitImpl() {
    }

    @Override
    public String checkedGetValue(Map<String, String> properties, int recursionGuard) {
        List<String> values = this.checkedGetValues(properties, recursionGuard);
        int top = values.size();
        if (top == 0) {
            return "";
        }
        if (top == 1) {
            return values.get(0);
        }
        StringBuilder bld = new StringBuilder();
        int idx = 0;
        while (idx < top) {
            bld.append(values.get(idx));
            ++idx;
        }
        return bld.toString();
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getLimit();
            }
            case 4: {
                return this.getPattern();
            }
            case 5: {
                return this.getStyle();
            }
            case 6: {
                return this.getCompiledPattern();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.limit != 0;
            }
            case 4: {
                return PATTERN_EDEFAULT == null ? this.pattern != null : !PATTERN_EDEFAULT.equals(this.pattern);
            }
            case 5: {
                return this.isSetStyle();
            }
            case 6: {
                return COMPILED_PATTERN_EDEFAULT == null ? this.compiledPattern != null : !COMPILED_PATTERN_EDEFAULT.equals(this.compiledPattern);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setLimit((Integer)newValue);
                return;
            }
            case 4: {
                this.setPattern((String)newValue);
                return;
            }
            case 5: {
                this.setStyle((SplitType)((Object)newValue));
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setLimit(0);
                return;
            }
            case 4: {
                this.setPattern(PATTERN_EDEFAULT);
                return;
            }
            case 5: {
                this.unsetStyle();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public synchronized Pattern getCompiledPattern() {
        if (this.compiledPattern == null) {
            String tmp = this.getPattern();
            if (tmp == null) {
                return null;
            }
            if (this.getStyle() == SplitType.QUOTED) {
                tmp = Pattern.quote(tmp);
            }
            this.compiledPattern = Pattern.compile(tmp);
        }
        return this.compiledPattern;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public SplitType getStyle() {
        return this.style;
    }

    @Override
    public boolean isMultiValued() {
        return true;
    }

    @Override
    public boolean isSetStyle() {
        return this.styleESet;
    }

    @Override
    public void setLimit(int newLimit) {
        int oldLimit = this.limit;
        this.limit = newLimit;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldLimit, this.limit));
        }
    }

    @Override
    public synchronized void setPattern(String newPattern) {
        this.setPatternGen(newPattern);
        this.compiledPattern = null;
    }

    public void setPatternGen(String newPattern) {
        String oldPattern = this.pattern;
        this.pattern = newPattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldPattern, (Object)this.pattern));
        }
    }

    @Override
    public void setStyle(SplitType newStyle) {
        this.setStyleGen(newStyle);
        this.compiledPattern = null;
    }

    public void setStyleGen(SplitType newStyle) {
        SplitType oldStyle = this.style;
        this.style = newStyle == null ? STYLE_EDEFAULT : newStyle;
        boolean oldStyleESet = this.styleESet;
        this.styleESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldStyle, (Object)this.style, !oldStyleESet));
        }
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (limit: ");
        result.append(this.limit);
        result.append(", pattern: ");
        result.append(this.pattern);
        result.append(", style: ");
        if (this.styleESet) {
            result.append((Object)this.style);
        } else {
            result.append("<unset>");
        }
        result.append(", compiledPattern: ");
        result.append(this.compiledPattern);
        result.append(')');
        return result.toString();
    }

    @Override
    public void unsetStyle() {
        SplitType oldStyle = this.style;
        boolean oldStyleESet = this.styleESet;
        this.style = STYLE_EDEFAULT;
        this.styleESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 5, (Object)oldStyle, (Object)STYLE_EDEFAULT, oldStyleESet));
        }
    }

    @Override
    protected List<String> checkedGetValues(Map<String, String> properties, int recursionGuard) {
        String source = this.checkedGetSourceValue(properties, recursionGuard);
        if (source == null) {
            return Collections.emptyList();
        }
        if (this.getStyle() != SplitType.GROUPS) {
            return Arrays.asList(this.getCompiledPattern().split(source, this.limit));
        }
        Matcher m = this.getCompiledPattern().matcher(source);
        if (!m.matches()) {
            return Collections.emptyList();
        }
        int nGroups = m.groupCount();
        ArrayList<String> result = new ArrayList<String>(nGroups);
        int idx = 0;
        while (idx < nGroups) {
            result.add(m.group(idx + 1));
            ++idx;
        }
        return result;
    }

    @Override
    protected EClass eStaticClass() {
        return CommonPackage.Literals.SPLIT;
    }
}

