/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.model.common.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.model.common.CommonFactory;
import org.eclipse.buckminster.model.common.Constant;
import org.eclipse.buckminster.model.common.Value;
import org.eclipse.buckminster.model.common.impl.ValueImpl;
import org.eclipse.buckminster.model.common.util.BMProperties;
import org.eclipse.buckminster.model.common.util.CircularExpansionException;
import org.eclipse.buckminster.model.common.util.IProperties;
import org.eclipse.buckminster.model.common.util.ImmutablePropertyException;
import org.eclipse.buckminster.model.common.util.MapUnion;

public class ExpandingProperties
implements IProperties {
    public static final int MAX_NESTING_DEPTH = 64;
    private final Map<String, Value> map;

    public static Map<String, String> createUnmodifiableProperties(Map<String, String> aMap) {
        aMap = aMap == null || aMap.size() == 0 ? Collections.emptyMap() : Collections.unmodifiableMap(new ExpandingProperties(aMap));
        return aMap;
    }

    public static String expand(Map<String, String> properties, String value, int nestingLevel) {
        return ExpandingProperties.checkedExpand(properties, value, value, nestingLevel);
    }

    private static String checkedExpand(Map<String, String> props, String topValue, String value, int recursionGuard) {
        if (recursionGuard > 64) {
            throw new CircularExpansionException(topValue);
        }
        if (value == null) {
            return null;
        }
        StringBuilder bld = null;
        int fragmentStart = 0;
        int top = value.length();
        if (top < 4) {
            return value;
        }
        --top;
        int idx = 0;
        while (idx < top) {
            char c = value.charAt(idx);
            if (c == '$') {
                int startPos;
                int endPos;
                if (value.charAt(idx + 1) == '$') {
                    if (bld == null) {
                        bld = new StringBuilder();
                    }
                    if (idx > fragmentStart) {
                        bld.append(value.substring(fragmentStart, idx));
                    }
                    fragmentStart = ++idx;
                } else if (value.charAt(idx + 1) == '{' && idx + 3 < top && (endPos = ExpandingProperties.parsePropertyName(value, startPos = idx + 2, true)) >= 0) {
                    String propVal;
                    String propKey = value.substring(startPos, endPos);
                    String string = propVal = props instanceof ExpandingProperties ? ((ExpandingProperties)props).getExpandedProperty(propKey, recursionGuard + 1) : props.get(propKey);
                    if (propVal != null) {
                        if (bld == null) {
                            bld = new StringBuilder();
                        }
                        if (idx > fragmentStart) {
                            bld.append(value.substring(fragmentStart, idx));
                        }
                        bld.append(ExpandingProperties.checkedExpand(props, topValue, propVal, recursionGuard + 1));
                        fragmentStart = endPos + 1;
                    }
                    idx = endPos;
                }
            }
            ++idx;
        }
        if (bld != null) {
            if (fragmentStart < ++top) {
                bld.append(value.substring(fragmentStart, top));
            }
            value = bld.toString();
        }
        return value;
    }

    /*
     * Unable to fully structure code
     */
    private static int parsePropertyName(String source, int startIndex, boolean inResolve) {
        if (source == null) {
            return -1;
        }
        top = source.length();
        if (startIndex >= top) {
            return -1;
        }
        idx = startIndex;
        if (Character.isJavaIdentifierStart(c = source.charAt(idx++))) ** GOTO lbl17
        return -1;
lbl-1000:
        // 1 sources

        {
            last = c;
            if ((c = source.charAt(idx++)) == '.') {
                if (last != '.' && idx != top && (!inResolve || source.charAt(idx) != '}')) continue;
                return -1;
            }
            if (inResolve && c == '}') {
                return idx - 1;
            }
            if (Character.isJavaIdentifierPart(c)) continue;
            return -1;
lbl17:
            // 3 sources

            ** while (idx < top)
        }
lbl18:
        // 1 sources

        return top;
    }

    public ExpandingProperties() {
        this.map = new HashMap<String, Value>();
    }

    public ExpandingProperties(int size) {
        this.map = new HashMap<String, Value>(size);
    }

    public ExpandingProperties(Map<String, String> dflts) {
        Map<String, Value> dfltMap;
        HashMap<String, Value> overlay = new HashMap<String, Value>();
        if (dflts == null || dflts.size() == 0) {
            this.map = overlay;
            return;
        }
        if (dflts instanceof ExpandingProperties) {
            dfltMap = ((ExpandingProperties)dflts).map;
        } else {
            dfltMap = new HashMap<String, Value>(dflts.size());
            for (Map.Entry<String, String> de : dflts.entrySet()) {
                Constant constant = CommonFactory.eINSTANCE.createConstant();
                constant.setValue(de.getValue());
                constant.setMutable(true);
                dfltMap.put(de.getKey(), constant);
            }
        }
        this.map = new MapUnion<String, Value>(overlay, dfltMap);
    }

    public ExpandingProperties(Map<String, Value> map, Map<String, Value> overlay) {
        if (overlay != null) {
            map = new MapUnion<String, Value>(overlay, map);
        }
        this.map = map;
    }

    @Override
    public void clear() {
        if (this.map.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Value> ee : this.map.entrySet()) {
            if (ee.getValue().isMutable()) continue;
            throw new ImmutablePropertyException(ee.getKey());
        }
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new AbstractSet<Map.Entry<String, String>>(){

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                return new Iterator<Map.Entry<String, String>>(){
                    private final Iterator<Map.Entry<String, Value>> itor;
                    {
                        this.itor = ExpandingProperties.this.map.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.itor.hasNext();
                    }

                    @Override
                    public Map.Entry<String, String> next() {
                        return new EntryWrapper(this.itor.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return ExpandingProperties.this.map.size();
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof ExpandingProperties && this.map.equals(((ExpandingProperties)o).map);
    }

    @Override
    public String get(Object key) {
        return key instanceof String ? this.getExpandedProperty((String)key, 0) : null;
    }

    public String getExpandedProperty(String key, int recursionGuard) {
        return this.convertValue(this.map.get(key), recursionGuard);
    }

    public Value getInternalValue(String key) {
        return this.map.get(key);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public Set<String> immutableKeySet() {
        HashSet<String> immutableSet = new HashSet<String>();
        for (Map.Entry<String, Value> me : this.map.entrySet()) {
            if (me.getValue().isMutable()) continue;
            immutableSet.add(me.getKey());
        }
        return immutableSet;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean isMutable(String key) {
        Value v = this.map.get(key);
        return v == null || v.isMutable();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Set<String> mutableKeySet() {
        HashSet<String> mutableSet = new HashSet<String>();
        for (Map.Entry<String, Value> me : this.map.entrySet()) {
            if (!me.getValue().isMutable()) continue;
            mutableSet.add(me.getKey());
        }
        return mutableSet;
    }

    @Override
    public Set<String> overlayKeySet() {
        return this.map instanceof MapUnion ? ((MapUnion)this.map).overlayKeySet() : this.map.keySet();
    }

    @Override
    public String put(String key, String propVal) {
        Constant constant = CommonFactory.eINSTANCE.createConstant();
        constant.setValue(propVal);
        return this.convertValue(this.setProperty(key, constant), 0);
    }

    @Override
    public String put(String key, String propVal, boolean mutable) {
        Constant constant = CommonFactory.eINSTANCE.createConstant();
        constant.setValue(propVal);
        constant.setMutable(mutable);
        return this.convertValue(this.setProperty(key, constant), 0);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> t) {
        this.putAll(t, false);
    }

    public void putAll(Map<? extends String, ? extends String> t, boolean mutable) {
        if (t instanceof ExpandingProperties) {
            for (Map.Entry<String, Value> ee : ((ExpandingProperties)t).map.entrySet()) {
                ee.getValue().setMutable(mutable);
                this.setProperty(ee.getKey(), ee.getValue());
            }
        } else {
            for (Map.Entry<? extends String, ? extends String> ee : t.entrySet()) {
                Constant constant = CommonFactory.eINSTANCE.createConstant();
                constant.setValue(ee.getValue());
                constant.setMutable(mutable);
                this.setProperty(ee.getKey(), constant);
            }
        }
    }

    @Override
    public String remove(Object key) {
        String strKey;
        Value vh;
        if (key instanceof String && (vh = this.map.remove(strKey = (String)key)) != null) {
            if (!vh.isMutable()) {
                this.map.put(strKey, vh);
                throw new ImmutablePropertyException(strKey);
            }
            return ((ValueImpl)vh).checkedGetValue(this, 0);
        }
        return null;
    }

    @Override
    public void setMutable(String key, boolean flag) {
        Value v = this.map.get(key);
        if (v != null) {
            v.setMutable(flag);
        }
    }

    public Value setProperty(String key, Value propertyHolder) {
        Value v = this.map.put(key, propertyHolder);
        if (v != null && !v.isMutable() && !v.equals(propertyHolder)) {
            this.map.put(key, v);
            throw new ImmutablePropertyException(key);
        }
        return v;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        BMProperties.store(this, out, comments);
    }

    @Override
    public boolean supportsMutability() {
        return true;
    }

    @Override
    public Collection<String> values() {
        return new AbstractCollection<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private final Iterator<Value> itor;
                    {
                        this.itor = ExpandingProperties.this.map.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.itor.hasNext();
                    }

                    @Override
                    public String next() {
                        String value = ExpandingProperties.this.convertValue(this.itor.next(), 0);
                        if (value != null) {
                            value = ExpandingProperties.expand(ExpandingProperties.this, value, 0);
                        }
                        return value;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return ExpandingProperties.this.map.size();
            }
        };
    }

    private String convertValue(Value vh, int recursionGuard) {
        return vh == null ? null : ((ValueImpl)vh).checkedGetValue(this, recursionGuard);
    }

    class EntryWrapper
    implements Map.Entry<String, String> {
        private final Map.Entry<String, Value> entry;

        public EntryWrapper(Map.Entry<String, Value> entry) {
            this.entry = entry;
        }

        @Override
        public String getKey() {
            return this.entry.getKey();
        }

        @Override
        public String getValue() {
            String value = ExpandingProperties.this.convertValue(this.entry.getValue(), 0);
            if (value != null) {
                value = ExpandingProperties.expand(ExpandingProperties.this, value, 0);
            }
            return value;
        }

        @Override
        public synchronized String setValue(String value) {
            String key = this.entry.getKey();
            Value vh = this.entry.getValue();
            Constant constant = CommonFactory.eINSTANCE.createConstant();
            constant.setValue(value);
            if (vh != null && !vh.isMutable() && !vh.equals(constant)) {
                throw new ImmutablePropertyException(key);
            }
            this.entry.setValue(constant);
            return ExpandingProperties.this.convertValue(vh, 0);
        }
    }
}

