/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.range;

import java.util.List;
import org.elasticsearch.search.facet.Facet;

public interface RangeFacet
extends Facet,
Iterable<Entry> {
    public static final String TYPE = "range";

    public List<Entry> getEntries();

    public static class Entry {
        double from = Double.NEGATIVE_INFINITY;
        double to = Double.POSITIVE_INFINITY;
        String fromAsString;
        String toAsString;
        long count;
        long totalCount;
        double total;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        boolean foundInDoc;

        Entry() {
        }

        public double getFrom() {
            return this.from;
        }

        public String getFromAsString() {
            if (this.fromAsString != null) {
                return this.fromAsString;
            }
            return Double.toString(this.from);
        }

        public double getTo() {
            return this.to;
        }

        public String getToAsString() {
            if (this.toAsString != null) {
                return this.toAsString;
            }
            return Double.toString(this.to);
        }

        public long getCount() {
            return this.count;
        }

        public long getTotalCount() {
            return this.totalCount;
        }

        public double getTotal() {
            return this.total;
        }

        public double getMean() {
            if (this.totalCount == 0L) {
                return 0.0;
            }
            return this.total / (double)this.totalCount;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }
    }
}

