/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class HighlightBuilder
implements ToXContent {
    private List<Field> fields;
    private String tagsSchema;
    private String[] preTags;
    private String[] postTags;
    private String order;
    private String encoder;
    private Boolean requireFieldMatch;
    private String highlighterType;
    private String fragmenter;
    private QueryBuilder highlightQuery;
    private Integer noMatchSize;
    private Integer phraseLimit;
    private Map<String, Object> options;
    private Boolean forceSource;

    public HighlightBuilder field(String name) {
        if (this.fields == null) {
            this.fields = Lists.newArrayList();
        }
        this.fields.add(new Field(name));
        return this;
    }

    public HighlightBuilder field(String name, int fragmentSize) {
        if (this.fields == null) {
            this.fields = Lists.newArrayList();
        }
        this.fields.add(new Field(name).fragmentSize(fragmentSize));
        return this;
    }

    public HighlightBuilder field(String name, int fragmentSize, int numberOfFragments) {
        if (this.fields == null) {
            this.fields = Lists.newArrayList();
        }
        this.fields.add(new Field(name).fragmentSize(fragmentSize).numOfFragments(numberOfFragments));
        return this;
    }

    public HighlightBuilder field(String name, int fragmentSize, int numberOfFragments, int fragmentOffset) {
        if (this.fields == null) {
            this.fields = Lists.newArrayList();
        }
        this.fields.add(new Field(name).fragmentSize(fragmentSize).numOfFragments(numberOfFragments).fragmentOffset(fragmentOffset));
        return this;
    }

    public HighlightBuilder field(Field field) {
        if (this.fields == null) {
            this.fields = Lists.newArrayList();
        }
        this.fields.add(field);
        return this;
    }

    public HighlightBuilder tagsSchema(String schemaName) {
        this.tagsSchema = schemaName;
        return this;
    }

    public HighlightBuilder encoder(String encoder) {
        this.encoder = encoder;
        return this;
    }

    public HighlightBuilder preTags(String ... preTags) {
        this.preTags = preTags;
        return this;
    }

    public HighlightBuilder postTags(String ... postTags) {
        this.postTags = postTags;
        return this;
    }

    public HighlightBuilder order(String order) {
        this.order = order;
        return this;
    }

    public HighlightBuilder requireFieldMatch(boolean requireFieldMatch) {
        this.requireFieldMatch = requireFieldMatch;
        return this;
    }

    public HighlightBuilder highlighterType(String highlighterType) {
        this.highlighterType = highlighterType;
        return this;
    }

    public HighlightBuilder fragmenter(String fragmenter) {
        this.fragmenter = fragmenter;
        return this;
    }

    public HighlightBuilder highlightQuery(QueryBuilder highlightQuery) {
        this.highlightQuery = highlightQuery;
        return this;
    }

    public HighlightBuilder noMatchSize(Integer noMatchSize) {
        this.noMatchSize = noMatchSize;
        return this;
    }

    public HighlightBuilder phraseLimit(Integer phraseLimit) {
        this.phraseLimit = phraseLimit;
        return this;
    }

    public HighlightBuilder options(Map<String, Object> options) {
        this.options = options;
        return this;
    }

    public HighlightBuilder forceSource(boolean forceSource) {
        this.forceSource = forceSource;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("highlight");
        if (this.tagsSchema != null) {
            builder.field("tags_schema", this.tagsSchema);
        }
        if (this.preTags != null) {
            builder.array("pre_tags", this.preTags);
        }
        if (this.postTags != null) {
            builder.array("post_tags", this.postTags);
        }
        if (this.order != null) {
            builder.field("order", this.order);
        }
        if (this.encoder != null) {
            builder.field("encoder", this.encoder);
        }
        if (this.requireFieldMatch != null) {
            builder.field("require_field_match", (Object)this.requireFieldMatch);
        }
        if (this.highlighterType != null) {
            builder.field("type", this.highlighterType);
        }
        if (this.fragmenter != null) {
            builder.field("fragmenter", this.fragmenter);
        }
        if (this.highlightQuery != null) {
            builder.field("highlight_query", this.highlightQuery);
        }
        if (this.noMatchSize != null) {
            builder.field("no_match_size", this.noMatchSize);
        }
        if (this.phraseLimit != null) {
            builder.field("phrase_limit", this.phraseLimit);
        }
        if (this.options != null && this.options.size() > 0) {
            builder.field("options", this.options);
        }
        if (this.forceSource != null) {
            builder.field("force_source", (Object)this.forceSource);
        }
        if (this.fields != null) {
            builder.startObject("fields");
            for (Field field : this.fields) {
                builder.startObject(field.name());
                if (field.preTags != null) {
                    builder.field("pre_tags", field.preTags);
                }
                if (field.postTags != null) {
                    builder.field("post_tags", field.postTags);
                }
                if (field.fragmentSize != -1) {
                    builder.field("fragment_size", field.fragmentSize);
                }
                if (field.numOfFragments != -1) {
                    builder.field("number_of_fragments", field.numOfFragments);
                }
                if (field.fragmentOffset != -1) {
                    builder.field("fragment_offset", field.fragmentOffset);
                }
                if (field.highlightFilter != null) {
                    builder.field("highlight_filter", (Object)field.highlightFilter);
                }
                if (field.order != null) {
                    builder.field("order", field.order);
                }
                if (field.requireFieldMatch != null) {
                    builder.field("require_field_match", (Object)field.requireFieldMatch);
                }
                if (field.boundaryMaxScan != -1) {
                    builder.field("boundary_max_scan", field.boundaryMaxScan);
                }
                if (field.boundaryChars != null) {
                    builder.field("boundary_chars", (Object)field.boundaryChars);
                }
                if (field.highlighterType != null) {
                    builder.field("type", field.highlighterType);
                }
                if (field.fragmenter != null) {
                    builder.field("fragmenter", field.fragmenter);
                }
                if (field.highlightQuery != null) {
                    builder.field("highlight_query", field.highlightQuery);
                }
                if (field.noMatchSize != null) {
                    builder.field("no_match_size", field.noMatchSize);
                }
                if (field.matchedFields != null) {
                    builder.field("matched_fields", field.matchedFields);
                }
                if (field.phraseLimit != null) {
                    builder.field("phrase_limit", field.phraseLimit);
                }
                if (field.options != null && field.options.size() > 0) {
                    builder.field("options", field.options);
                }
                if (field.forceSource != null) {
                    builder.field("force_source", (Object)field.forceSource);
                }
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static class Field {
        final String name;
        String[] preTags;
        String[] postTags;
        int fragmentSize = -1;
        int fragmentOffset = -1;
        int numOfFragments = -1;
        Boolean highlightFilter;
        String order;
        Boolean requireFieldMatch;
        int boundaryMaxScan = -1;
        char[] boundaryChars;
        String highlighterType;
        String fragmenter;
        QueryBuilder highlightQuery;
        Integer noMatchSize;
        String[] matchedFields;
        Integer phraseLimit;
        Map<String, Object> options;
        Boolean forceSource;

        public Field(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public Field preTags(String ... preTags) {
            this.preTags = preTags;
            return this;
        }

        public Field postTags(String ... postTags) {
            this.postTags = postTags;
            return this;
        }

        public Field fragmentSize(int fragmentSize) {
            this.fragmentSize = fragmentSize;
            return this;
        }

        public Field fragmentOffset(int fragmentOffset) {
            this.fragmentOffset = fragmentOffset;
            return this;
        }

        public Field numOfFragments(int numOfFragments) {
            this.numOfFragments = numOfFragments;
            return this;
        }

        public Field highlightFilter(boolean highlightFilter) {
            this.highlightFilter = highlightFilter;
            return this;
        }

        public Field order(String order) {
            this.order = order;
            return this;
        }

        public Field requireFieldMatch(boolean requireFieldMatch) {
            this.requireFieldMatch = requireFieldMatch;
            return this;
        }

        public Field boundaryMaxScan(int boundaryMaxScan) {
            this.boundaryMaxScan = boundaryMaxScan;
            return this;
        }

        public Field boundaryChars(char[] boundaryChars) {
            this.boundaryChars = boundaryChars;
            return this;
        }

        public Field highlighterType(String highlighterType) {
            this.highlighterType = highlighterType;
            return this;
        }

        public Field fragmenter(String fragmenter) {
            this.fragmenter = fragmenter;
            return this;
        }

        public Field highlightQuery(QueryBuilder highlightQuery) {
            this.highlightQuery = highlightQuery;
            return this;
        }

        public Field noMatchSize(Integer noMatchSize) {
            this.noMatchSize = noMatchSize;
            return this;
        }

        public Field options(Map<String, Object> options) {
            this.options = options;
            return this;
        }

        public Field matchedFields(String ... matchedFields) {
            this.matchedFields = matchedFields;
            return this;
        }

        public Field phraseLimit(Integer phraseLimit) {
            this.phraseLimit = phraseLimit;
            return this;
        }

        public Field forceSource(boolean forceSource) {
            this.forceSource = forceSource;
            return this;
        }
    }
}

