/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.NetException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class DataPacket
extends Packet
implements SQLnetDef {
    static final boolean DEBUG2 = false;
    protected int pktOffset;
    protected int dataFlags;
    protected boolean isBufferFull = false;
    protected boolean isBufferEmpty = false;
    protected int availableBytesToSend = 0;
    protected int availableBytesToRead = 0;
    protected int sessionIdSize = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Aug_23_13:32:03_PDT_2011";
    public static final boolean TRACE = false;

    public DataPacket(SessionAtts sessionAtts, int n2) {
        super(sessionAtts, n2, 6, sessionAtts.poolEnabled ? 1 : 0);
        this.initialize(n2);
    }

    public DataPacket(SessionAtts sessionAtts) {
        this(sessionAtts, sessionAtts.getSDU());
    }

    protected void receive() throws IOException, NetException {
        super.receive();
        this.pktOffset = 10;
        this.dataOff = 10;
        this.dataLen = this.length - this.dataOff - (this.sAtts.poolEnabled ? 16 : 0);
        this.dataFlags = this.buffer[8] & 0xFF;
        this.dataFlags <<= 8;
        this.dataFlags |= this.buffer[9] & 0xFF;
        if (this.type == 6 && (this.dataFlags & 0x40) != 0) {
            this.sAtts.dataEOF = true;
        }
        if (this.type == 6 && 0 == this.dataLen) {
            this.type = 7;
        }
        if (this.sAtts.poolEnabled) {
            this.sAtts.timestampLastIO = System.currentTimeMillis();
        }
    }

    protected void send() throws IOException {
        this.send(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(int n2) throws IOException {
        this.buffer[8] = (byte)(n2 / 256);
        this.buffer[9] = (byte)(n2 % 256);
        this.setBufferLength(this.pktOffset);
        OutputStream outputStream = this.sAtts.ntOutputStream;
        synchronized (outputStream) {
            if (this.sAtts.poolEnabled) {
                boolean bl;
                int n3 = 20;
                do {
                    bl = false;
                    try {
                        this.sAtts.ntOutputStream.write(this.buffer, 0, this.pktOffset);
                    }
                    catch (SocketException socketException) {
                        if (socketException.getMessage().startsWith("Connection reset") && --n3 > 0) {
                            if (!this.sAtts.attemptingReconnect) {
                                this.sAtts.ns.reconnectIfRequired(false);
                            }
                            bl = true;
                            continue;
                        }
                        throw socketException;
                    }
                } while (bl);
            } else {
                this.sAtts.ntOutputStream.write(this.buffer, 0, this.pktOffset);
            }
        }
        this.pktOffset = 10;
        this.availableBytesToSend = 0;
        this.isBufferFull = false;
        if (this.sAtts.poolEnabled) {
            this.sAtts.timestampLastIO = System.currentTimeMillis();
        }
    }

    protected void putDataInBuffer(byte by) throws IOException {
        this.buffer[this.pktOffset++] = by;
        this.isBufferFull = this.pktOffset == this.buffer.length - this.sessionIdSize;
        ++this.availableBytesToSend;
    }

    protected int putDataInBuffer(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = n4 = this.buffer.length - this.sessionIdSize - this.pktOffset <= n3 ? this.buffer.length - this.sessionIdSize - this.pktOffset : n3;
        if (n4 > 0) {
            System.arraycopy(byArray, n2, this.buffer, this.pktOffset, n4);
            this.pktOffset += n4;
            this.isBufferFull = this.pktOffset == this.buffer.length - this.sessionIdSize;
            this.availableBytesToSend = this.dataOff < this.pktOffset ? this.pktOffset - this.dataOff : 0;
        }
        return n4;
    }

    public long readLongLSB(int n2) throws BreakNetException, NetException, IOException {
        long l2 = 0L;
        int n3 = n2;
        int n4 = 0;
        while (n3 > 0) {
            l2 |= ((long)this.buffer[this.pktOffset] & 0xFFL) << 8 * n4;
            --n3;
            ++n4;
            ++this.pktOffset;
            --this.availableBytesToRead;
        }
        return l2;
    }

    public long readLongMSB(int n2) throws BreakNetException, NetException, IOException {
        long l2 = 0L;
        int n3 = n2;
        while (n3 > 0) {
            l2 |= ((long)this.buffer[this.pktOffset] & 0xFFL) << 8 * (n3 - 1);
            --n3;
            ++this.pktOffset;
            --this.availableBytesToRead;
        }
        return l2;
    }

    protected int getDataFromBuffer(byte[] byArray, int n2, int n3) throws NetException {
        int n4;
        int n5 = n4 = this.availableBytesToRead <= n3 ? this.availableBytesToRead : n3;
        if (n4 > 0) {
            System.arraycopy(this.buffer, this.pktOffset, byArray, n2, n4);
            this.pktOffset += n4;
            this.isBufferEmpty = this.pktOffset == this.length;
            this.availableBytesToRead -= n4;
        }
        return n4;
    }

    protected byte get1ByteDataFromBuffer() throws NetException {
        byte by = this.buffer[this.pktOffset];
        ++this.pktOffset;
        this.isBufferEmpty = this.pktOffset >= this.length;
        --this.availableBytesToRead;
        return by;
    }

    protected void setBufferLength(int n2) throws NetException {
        if (this.sAtts.poolEnabled) {
            System.arraycopy(this.sAtts.sessionId, 0, this.buffer, this.pktOffset, 16);
            n2 += 16;
            this.pktOffset += 16;
        }
        this.buffer[0] = (byte)(n2 / 256);
        this.buffer[1] = (byte)(n2 % 256);
    }

    protected void initialize(int n2) {
        this.pktOffset = 10;
        this.dataOff = 10;
        this.dataLen = n2 - this.dataOff;
        this.dataFlags = 0;
        this.sessionIdSize = this.sAtts.poolEnabled ? 16 : 0;
    }
}

