/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.jdk;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jboss.logging.LoggerPlugin;
import org.jboss.logging.MDCProvider;
import org.jboss.logging.MDCSupport;
import org.jboss.logging.NDCProvider;
import org.jboss.logging.NDCSupport;
import org.jboss.logging.jdk.JBossLevel;
import org.jboss.logging.jdk.JDKMDCProvider;
import org.jboss.logging.jdk.JDKNDCProvider;

public class JDK14LoggerPlugin
implements LoggerPlugin,
MDCSupport,
NDCSupport {
    private Logger log;
    private String name;

    public void init(String name) {
        this.name = name;
        this.log = Logger.getLogger(name);
    }

    private void doLog(Level level, Object message, Throwable t) {
        LogRecord record = new LogRecord(level, message.toString());
        record.setLoggerName(this.name);
        record.setThrown(t);
        record.setSourceMethodName(null);
        this.log.log(record);
    }

    public boolean isTraceEnabled() {
        return this.log.isLoggable(JBossLevel.TRACE);
    }

    public void trace(Object message) {
        this.doLog(JBossLevel.TRACE, message, null);
    }

    public void trace(Object message, Throwable t) {
        this.doLog(JBossLevel.TRACE, message, t);
    }

    public void trace(String loggerFcqn, Object message, Throwable t) {
        this.doLog(JBossLevel.TRACE, message, t);
    }

    @Deprecated
    public boolean isDebugEnabled() {
        return this.log.isLoggable(JBossLevel.DEBUG);
    }

    public void debug(Object message) {
        this.doLog(JBossLevel.DEBUG, message, null);
    }

    public void debug(Object message, Throwable t) {
        this.doLog(JBossLevel.DEBUG, message, t);
    }

    public void debug(String loggerFcqn, Object message, Throwable t) {
        this.doLog(JBossLevel.DEBUG, message, t);
    }

    @Deprecated
    public boolean isInfoEnabled() {
        return this.log.isLoggable(JBossLevel.INFO);
    }

    public void info(Object message) {
        this.doLog(JBossLevel.INFO, message, null);
    }

    public void info(Object message, Throwable t) {
        this.doLog(JBossLevel.INFO, message, t);
    }

    public void info(String loggerFcqn, Object message, Throwable t) {
        this.doLog(JBossLevel.INFO, message, t);
    }

    public void warn(Object message) {
        this.doLog(JBossLevel.WARN, message, null);
    }

    public void warn(Object message, Throwable t) {
        this.doLog(JBossLevel.WARN, message, t);
    }

    public void warn(String loggerFcqn, Object message, Throwable t) {
        this.doLog(JBossLevel.WARN, message, t);
    }

    public void error(Object message) {
        this.doLog(JBossLevel.ERROR, message, null);
    }

    public void error(Object message, Throwable t) {
        this.doLog(JBossLevel.ERROR, message, t);
    }

    public void error(String loggerFcqn, Object message, Throwable t) {
        this.doLog(JBossLevel.ERROR, message, t);
    }

    public void fatal(Object message) {
        this.doLog(JBossLevel.FATAL, message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.doLog(JBossLevel.FATAL, message, t);
    }

    public void fatal(String loggerFcqn, Object message, Throwable t) {
        this.doLog(JBossLevel.FATAL, message, t);
    }

    public NDCProvider getNDCProvider() {
        return new JDKNDCProvider();
    }

    public MDCProvider getMDCProvider() {
        return new JDKMDCProvider();
    }
}

