/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.endpoint.deployers.impl;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jboss.aop.advice.Interceptor;
import org.jboss.ejb3.common.lang.SerializableMethod;
import org.jboss.ejb3.endpoint.Endpoint;
import org.jboss.ejb3.endpoint.SessionFactory;
import org.jboss.ejb3.proxy.impl.handler.session.SessionProxyInvocationHandler;
import org.jboss.ejb3.proxy.spi.container.InvokableContext;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointImpl
implements Endpoint,
SessionFactory {
    private static final Logger log = Logger.getLogger(EndpointImpl.class);
    private InvokableContext container;
    private SessionFactory factory;

    public Serializable createSession(Class<?>[] initTypes, Object[] initValues) {
        if (initTypes != null && initTypes.length != 0) {
            throw new UnsupportedOperationException("SessionFactory " + this + " does not support arguments");
        }
        if (initValues != null && initValues.length != 0) {
            throw new UnsupportedOperationException("SessionFactory " + this + " does not support arguments");
        }
        return this.factory.createSession((Class[])initTypes, initValues);
    }

    public void destroySession(Serializable session) {
        if (this.factory == null) {
            throw new IllegalStateException("Endpoint " + this + " is not session aware");
        }
        this.factory.destroySession(session);
    }

    public SessionFactory getSessionFactory() throws IllegalStateException {
        if (this.factory == null) {
            throw new IllegalStateException("Endpoint " + this + " is not session aware");
        }
        return this;
    }

    public Object invoke(final Serializable session, Class<?> invokedBusinessInterface, Method method, Object[] args) throws Throwable {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class[] interfaces = new Class[]{invokedBusinessInterface};
        SessionProxyInvocationHandler handler = new SessionProxyInvocationHandler(){
            private static final long serialVersionUID = 1L;

            public String getBusinessInterfaceType() {
                throw new UnsupportedOperationException();
            }

            public String getContainerGuid() {
                throw new UnsupportedOperationException();
            }

            public String getContainerName() {
                throw new UnsupportedOperationException();
            }

            public Interceptor[] getInterceptors() {
                throw new UnsupportedOperationException();
            }

            public Object getTarget() {
                return session;
            }

            public void setBusinessInterfaceType(String businessInterfaceType) {
                throw new UnsupportedOperationException();
            }

            public void setContainerGuid(String containerGuid) {
                throw new UnsupportedOperationException();
            }

            public void setContainerName(String containerName) {
                throw new UnsupportedOperationException();
            }

            public void setInterceptors(Interceptor[] interceptors) {
                throw new UnsupportedOperationException();
            }

            public void setTarget(Object target) {
                throw new UnsupportedOperationException();
            }

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                throw new UnsupportedOperationException();
            }
        };
        Object proxy = Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)handler);
        SerializableMethod businessMethod = new SerializableMethod(method, invokedBusinessInterface);
        return this.container.invoke(proxy, businessMethod, args);
    }

    public boolean isSessionAware() {
        return this.factory != null;
    }

    public void setContainer(InvokableContext container) {
        this.container = container;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Set container: " + container.getClass().getName()));
        }
        if (container instanceof SessionFactory) {
            this.factory = (SessionFactory)container;
        }
    }
}

