/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Properties;
import org.jgroups.Address;
import org.jgroups.blocks.BasicConnectionTable;
import org.jgroups.blocks.ConnectionTableNIO;
import org.jgroups.protocols.BasicTCP;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.PortsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCP_NIO
extends BasicTCP
implements BasicConnectionTable.Receiver {
    private int m_reader_threads = 3;
    private int m_writer_threads = 3;
    private int m_processor_threads = 5;
    private int m_processor_minThreads = 5;
    private int m_processor_maxThreads = 5;
    private int m_processor_queueSize = 100;
    private long m_processor_keepAliveTime = Long.MAX_VALUE;
    private ConnectionTableNIO ct;

    protected ConnectionTableNIO getConnectionTable(long ri, long cet, InetAddress b_addr, InetAddress bc_addr, int s_port, int e_port, PortsManager pm) throws Exception {
        ConnectionTableNIO retval = null;
        if (ri == 0L && cet == 0L) {
            retval = new ConnectionTableNIO((BasicConnectionTable.Receiver)this, b_addr, bc_addr, s_port, e_port, pm, false);
        } else {
            if (ri == 0L) {
                ri = 5000L;
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("reaper_interval was 0, set it to " + ri));
                }
            }
            if (cet == 0L) {
                cet = 300000L;
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("conn_expire_time was 0, set it to " + cet));
                }
            }
            retval = new ConnectionTableNIO(this, b_addr, bc_addr, s_port, e_port, pm, ri, cet, false);
        }
        retval.setThreadFactory(this.getThreadFactory());
        retval.setProcessorMaxThreads(this.getProcessorMaxThreads());
        retval.setProcessorQueueSize(this.getProcessorQueueSize());
        retval.setProcessorMinThreads(this.getProcessorMinThreads());
        retval.setProcessorKeepAliveTime(this.getProcessorKeepAliveTime());
        retval.setProcessorThreads(this.getProcessorThreads());
        retval.start();
        return retval;
    }

    @Override
    public String printConnections() {
        return this.ct.toString();
    }

    @Override
    public void send(Address dest, byte[] data, int offset, int length) throws Exception {
        this.ct.send(dest, data, offset, length);
    }

    @Override
    public void start() throws Exception {
        this.ct = this.getConnectionTable(this.reaper_interval, this.conn_expire_time, this.bind_addr, this.external_addr, this.start_port, this.end_port, this.pm);
        this.ct.setUseSendQueues(this.use_send_queues);
        this.ct.setReceiveBufferSize(this.recv_buf_size);
        this.ct.setSendBufferSize(this.send_buf_size);
        this.ct.setSocketConnectionTimeout(this.sock_conn_timeout);
        this.ct.setPeerAddressReadTimeout(this.peer_addr_read_timeout);
        this.ct.setTcpNodelay(this.tcp_nodelay);
        this.ct.setLinger(this.linger);
        this.local_addr = this.ct.getLocalAddress();
        if (this.additional_data != null && this.local_addr instanceof IpAddress) {
            ((IpAddress)this.local_addr).setAdditionalData(this.additional_data);
        }
        super.start();
    }

    @Override
    public void retainAll(Collection<Address> members) {
        this.ct.retainAll(members);
    }

    @Override
    public void stop() {
        this.ct.stop();
        super.stop();
    }

    @Override
    public String getName() {
        return "TCP_NIO";
    }

    public int getReaderThreads() {
        return this.m_reader_threads;
    }

    public int getWriterThreads() {
        return this.m_writer_threads;
    }

    public int getProcessorThreads() {
        return this.m_processor_threads;
    }

    public int getProcessorMinThreads() {
        return this.m_processor_minThreads;
    }

    public int getProcessorMaxThreads() {
        return this.m_processor_maxThreads;
    }

    public int getProcessorQueueSize() {
        return this.m_processor_queueSize;
    }

    public long getProcessorKeepAliveTime() {
        return this.m_processor_keepAliveTime;
    }

    public int getOpenConnections() {
        return this.ct.getNumConnections();
    }

    @Override
    public boolean setProperties(Properties props) {
        String str = props.getProperty("reader_threads");
        if (str != null) {
            this.m_reader_threads = Integer.parseInt(str);
            props.remove("reader_threads");
        }
        if ((str = props.getProperty("writer_threads")) != null) {
            this.m_writer_threads = Integer.parseInt(str);
            props.remove("writer_threads");
        }
        if ((str = props.getProperty("processor_threads")) != null) {
            this.m_processor_threads = Integer.parseInt(str);
            props.remove("processor_threads");
        }
        if ((str = props.getProperty("processor_minThreads")) != null) {
            this.m_processor_minThreads = Integer.parseInt(str);
            props.remove("processor_minThreads");
        }
        if ((str = props.getProperty("processor_maxThreads")) != null) {
            this.m_processor_maxThreads = Integer.parseInt(str);
            props.remove("processor_maxThreads");
        }
        if ((str = props.getProperty("processor_queueSize")) != null) {
            this.m_processor_queueSize = Integer.parseInt(str);
            props.remove("processor_queueSize");
        }
        if ((str = props.getProperty("processor_keepAliveTime")) != null) {
            this.m_processor_keepAliveTime = Long.parseLong(str);
            props.remove("processor_keepAliveTime");
        }
        return super.setProperties(props);
    }
}

